/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Component;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;

public class ExpressionComposer {
    public String compose(Term term) {
        if (term == null) {
            return "1";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.composeTerm(stringBuilder, term);
        return stringBuilder.toString();
    }

    private void composeTerm(StringBuilder stringBuilder, Term term) {
        if (term.getComp() != null) {
            this.composeComp(stringBuilder, term.getComp());
        }
        if (term.getOp() != null) {
            this.composeOp(stringBuilder, term.getOp());
        }
        if (term.getTerm() != null) {
            this.composeTerm(stringBuilder, term.getTerm());
        }
    }

    private void composeComp(StringBuilder stringBuilder, Component component) {
        if (component instanceof Factor) {
            this.composeFactor(stringBuilder, (Factor)component);
        } else if (component instanceof Symbol) {
            this.composeSymbol(stringBuilder, (Symbol)component);
        } else if (component instanceof Term) {
            stringBuilder.append('(');
            this.composeTerm(stringBuilder, (Term)component);
            stringBuilder.append(')');
        } else {
            stringBuilder.append('?');
        }
    }

    private void composeSymbol(StringBuilder stringBuilder, Symbol symbol) {
        if (symbol.getPrefix() != null) {
            stringBuilder.append(symbol.getPrefix().getCode());
        }
        stringBuilder.append(symbol.getUnit().getCode());
        if (symbol.getExponent() != 1) {
            stringBuilder.append(symbol.getExponent());
        }
    }

    private void composeFactor(StringBuilder stringBuilder, Factor factor) {
        stringBuilder.append(factor.getValue());
    }

    private void composeOp(StringBuilder stringBuilder, Operator operator) {
        if (operator == Operator.DIVISION) {
            stringBuilder.append("/");
        } else {
            stringBuilder.append(".");
        }
    }

    public String compose(Canonical canonical) {
        return this.compose(canonical, true);
    }

    public String compose(Canonical canonical, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append(canonical.getValue().asDecimal());
        }
        boolean bl2 = true;
        for (Canonical.CanonicalUnit canonicalUnit : canonical.getUnits()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(".");
            }
            stringBuilder.append(canonicalUnit.getBase().getCode());
            if (canonicalUnit.getExponent() == 1) continue;
            stringBuilder.append(canonicalUnit.getExponent());
        }
        return stringBuilder.toString();
    }
}

