/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.ucum.Component;
import org.hl7.fhir.utilities.ucum.ConceptKind;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Lexer;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Prefix;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.TokenType;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.Unit;

public class ExpressionParser {
    private UcumModel model;

    public ExpressionParser(UcumModel ucumModel) {
        this.model = ucumModel;
    }

    public Term parse(String string) throws Exception {
        Lexer lexer = new Lexer(string);
        Term term = this.parseTerm(lexer, true);
        if (!lexer.finished()) {
            throw new Exception("Expression was not parsed completely. Syntax Error?");
        }
        return term;
    }

    private Term parseTerm(Lexer lexer, boolean bl) throws Exception {
        Term term = new Term();
        if (bl && lexer.getType() == TokenType.NONE) {
            term.setComp(new Factor(1));
        } else if (lexer.getType() == TokenType.SOLIDUS) {
            term.setOp(Operator.DIVISION);
            lexer.consume();
            term.setTerm(this.parseTerm(lexer, false));
        } else {
            if (lexer.getType() == TokenType.ANNOTATION) {
                term.setComp(new Factor(1));
                lexer.consume();
            } else {
                term.setComp(this.parseComp(lexer));
            }
            if (lexer.getType() != TokenType.NONE && lexer.getType() != TokenType.CLOSE) {
                if (lexer.getType() == TokenType.SOLIDUS) {
                    term.setOp(Operator.DIVISION);
                    lexer.consume();
                } else if (lexer.getType() == TokenType.PERIOD) {
                    term.setOp(Operator.MULTIPLICATION);
                    lexer.consume();
                } else if (lexer.getType() == TokenType.ANNOTATION) {
                    term.setOp(Operator.MULTIPLICATION);
                } else {
                    lexer.error("Expected '/' or '.'");
                }
                term.setTerm(this.parseTerm(lexer, false));
            }
        }
        return term;
    }

    private Component parseComp(Lexer lexer) throws Exception {
        if (lexer.getType() == TokenType.NUMBER) {
            Factor factor = new Factor(lexer.getTokenAsInt());
            lexer.consume();
            return factor;
        }
        if (lexer.getType() == TokenType.SYMBOL) {
            return this.parseSymbol(lexer);
        }
        if (lexer.getType() == TokenType.NONE) {
            lexer.error("unexpected end of expression looking for a symbol or a number");
        } else {
            if (lexer.getType() == TokenType.OPEN) {
                lexer.consume();
                Term term = this.parseTerm(lexer, true);
                if (lexer.getType() == TokenType.CLOSE) {
                    lexer.consume();
                } else {
                    lexer.error("Unexpected Token Type '" + lexer.getType().toString() + "' looking for a close bracket");
                }
                return term;
            }
            lexer.error("unexpected token looking for a symbol or a number");
        }
        return null;
    }

    private Component parseSymbol(Lexer lexer) throws Exception {
        Symbol symbol = new Symbol();
        String string = lexer.getToken();
        Prefix prefix = null;
        Unit unit = null;
        for (Prefix prefix2 : this.model.getPrefixes()) {
            if (!string.startsWith(prefix2.getCode()) || (unit = this.model.getUnit(string.substring(prefix2.getCode().length()))) == null || unit.getKind() != ConceptKind.BASEUNIT && !((DefinedUnit)unit).isMetric()) continue;
            prefix = prefix2;
            break;
        }
        if (prefix != null) {
            symbol.setPrefix(prefix);
            symbol.setUnit(unit);
        } else {
            unit = this.model.getUnit(string);
            if (unit != null) {
                symbol.setUnit(unit);
            } else if (!string.equals("1")) {
                lexer.error("The unit '" + string + "' is unknown");
            }
        }
        lexer.consume();
        if (lexer.getType() == TokenType.NUMBER) {
            symbol.setExponent(lexer.getTokenAsInt());
            lexer.consume();
        } else {
            symbol.setExponent(1);
        }
        return symbol;
    }
}

