/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.ucum.Component;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;

public class FormalStructureComposer {
    public String compose(Term term) {
        StringBuilder stringBuilder = new StringBuilder();
        this.composeTerm(stringBuilder, term);
        return stringBuilder.toString();
    }

    private void composeTerm(StringBuilder stringBuilder, Term term) {
        if (term.getComp() != null) {
            this.composeComp(stringBuilder, term.getComp());
        }
        if (term.getOp() != null) {
            this.composeOp(stringBuilder, term.getOp());
        }
        if (term.getTerm() != null) {
            this.composeTerm(stringBuilder, term.getTerm());
        }
    }

    private void composeComp(StringBuilder stringBuilder, Component component) {
        if (component instanceof Factor) {
            this.composeFactor(stringBuilder, (Factor)component);
        } else if (component instanceof Symbol) {
            this.composeSymbol(stringBuilder, (Symbol)component);
        } else if (component instanceof Term) {
            this.composeTerm(stringBuilder, (Term)component);
        } else {
            stringBuilder.append('?');
        }
    }

    private void composeSymbol(StringBuilder stringBuilder, Symbol symbol) {
        stringBuilder.append('(');
        if (symbol.getPrefix() != null) {
            stringBuilder.append(symbol.getPrefix().getNames().get(0));
        }
        stringBuilder.append(symbol.getUnit().getNames().get(0));
        if (symbol.getExponent() != 1) {
            stringBuilder.append(" ^ ");
            stringBuilder.append(symbol.getExponent());
        }
        stringBuilder.append(')');
    }

    private void composeFactor(StringBuilder stringBuilder, Factor factor) {
        stringBuilder.append(factor.getValue());
    }

    private void composeOp(StringBuilder stringBuilder, Operator operator) {
        if (operator == Operator.DIVISION) {
            stringBuilder.append(" / ");
        } else {
            stringBuilder.append(" * ");
        }
    }
}

