/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.TokenType;

public class Lexer {
    private static final char NO_CHAR = '\u0000';
    private String source;
    private int index;
    private String token;
    private TokenType type;
    private int start;

    public Lexer(String string) throws Exception {
        this.source = string;
        if (string == null) {
            string = "";
        }
        this.index = 0;
        this.consume();
    }

    public void consume() throws Exception {
        char c;
        this.token = null;
        this.type = TokenType.NONE;
        this.start = this.index;
        if (!(this.index >= this.source.length() || this.checkSingle(c = this.nextChar(), '/', TokenType.SOLIDUS) || this.checkSingle(c, '.', TokenType.PERIOD) || this.checkSingle(c, '(', TokenType.OPEN) || this.checkSingle(c, ')', TokenType.CLOSE) || this.checkAnnotation(c) || this.checkNumber(c) || this.checkNumberOrSymbol(c))) {
            throw new Exception("Error processing unit '" + this.source + "': unexpected character '" + c + "' at position " + Integer.toString(this.start));
        }
    }

    private boolean checkNumber(char c) throws Exception {
        if (c == '+' || c == '-') {
            this.token = String.valueOf(c);
            c = this.peekChar();
            while (c >= '0' && c <= '9') {
                this.token = this.token + c;
                ++this.index;
                c = this.peekChar();
            }
            if (this.token.length() == 1) {
                throw new Exception("Error processing unit'" + this.source + "': unexpected character '" + c + "' at position " + Integer.toString(this.start) + ": a + or - must be followed by at least one digit");
            }
            this.type = TokenType.NUMBER;
            return true;
        }
        return false;
    }

    private boolean checkNumberOrSymbol(char c) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isValidSymbolChar(c, true)) {
            this.token = String.valueOf(c);
            bl = bl || c < '0' || c > '9';
            bl2 = this.checkBrackets(c, bl2);
            c = this.peekChar();
            bl2 = this.checkBrackets(c, bl2);
            while (this.isValidSymbolChar(c, !bl || bl2)) {
                this.token = this.token + c;
                bl = bl || c != '\u0000' && (c < '0' || c > '9');
                ++this.index;
                c = this.peekChar();
                bl2 = this.checkBrackets(c, bl2);
            }
            this.type = bl ? TokenType.SYMBOL : TokenType.NUMBER;
            return true;
        }
        return false;
    }

    private boolean checkBrackets(char c, boolean bl) throws Exception {
        if (c == '[') {
            if (bl) {
                this.error("Nested [");
            } else {
                return true;
            }
        }
        if (c == ']') {
            if (!bl) {
                this.error("] without [");
            } else {
                return false;
            }
        }
        return bl;
    }

    private boolean isValidSymbolChar(char c, boolean bl) {
        return bl && c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '[' || c == ']' || c == '%' || c == '*' || c == '^' || c == '\'' || c == '\"' || c == '_';
    }

    private boolean checkAnnotation(char c) throws Exception {
        if (c == '{') {
            StringBuilder stringBuilder = new StringBuilder();
            while (c != '}') {
                c = this.nextChar();
                if (!Utilities.isAsciiChar(c)) {
                    throw new Exception("Error processing unit'" + this.source + "': Annotation contains non-ascii characters");
                }
                if (c == '\u0000') {
                    throw new Exception("Error processing unit'" + this.source + "': unterminated annotation");
                }
                stringBuilder.append(c);
            }
            this.token = stringBuilder.toString();
            this.type = TokenType.ANNOTATION;
            return true;
        }
        return false;
    }

    private boolean checkSingle(char c, char c2, TokenType tokenType) {
        if (c == c2) {
            this.token = String.valueOf(c);
            this.type = tokenType;
            return true;
        }
        return false;
    }

    private char nextChar() {
        char c = this.index < this.source.length() ? this.source.charAt(this.index) : (char)'\u0000';
        ++this.index;
        return c;
    }

    private char peekChar() {
        return this.index < this.source.length() ? this.source.charAt(this.index) : (char)'\u0000';
    }

    public String getToken() {
        return this.token;
    }

    public TokenType getType() {
        return this.type;
    }

    public void error(String string) throws Exception {
        throw new Exception("Error processing unit '" + this.source + "': " + string + "' at position " + Integer.toString(this.start));
    }

    public int getTokenAsInt() {
        return this.token.charAt(0) == '+' ? Integer.parseInt(this.token.substring(1)) : Integer.parseInt(this.token);
    }

    public boolean finished() {
        return this.index == this.source.length();
    }
}

