/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.ucum.Concept;
import org.hl7.fhir.utilities.ucum.ConceptKind;
import org.hl7.fhir.utilities.ucum.Prefix;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.Unit;

public class Search {
    public List<Concept> doSearch(UcumModel ucumModel, ConceptKind conceptKind, String string, boolean bl) {
        ArrayList<Concept> arrayList = new ArrayList<Concept>();
        if (conceptKind == null || conceptKind == ConceptKind.PREFIX) {
            this.searchPrefixes(arrayList, ucumModel.getPrefixes(), string, bl);
        }
        if (conceptKind == null || conceptKind == ConceptKind.BASEUNIT) {
            this.searchUnits(arrayList, ucumModel.getBaseUnits(), string, bl);
        }
        if (conceptKind == null || conceptKind == ConceptKind.UNIT) {
            this.searchUnits(arrayList, ucumModel.getDefinedUnits(), string, bl);
        }
        return arrayList;
    }

    private void searchUnits(List<Concept> list, List<? extends Unit> list2, String string, boolean bl) {
        for (Unit unit : list2) {
            if (!this.matchesUnit(unit, string, bl)) continue;
            list.add(unit);
        }
    }

    private boolean matchesUnit(Unit unit, String string, boolean bl) {
        return this.matches(unit.getProperty(), string, bl) || this.matchesConcept(unit, string, bl);
    }

    private void searchPrefixes(List<Concept> list, List<? extends Prefix> list2, String string, boolean bl) {
        for (Concept concept : list2) {
            if (!this.matchesConcept(concept, string, bl)) continue;
            list.add(concept);
        }
    }

    private boolean matchesConcept(Concept concept, String string, boolean bl) {
        for (String string2 : concept.getNames()) {
            if (!this.matches(string2, string, bl)) continue;
            return true;
        }
        if (this.matches(concept.getCode(), string, bl)) {
            return true;
        }
        if (this.matches(concept.getCodeUC(), string, bl)) {
            return true;
        }
        return this.matches(concept.getPrintSymbol(), string, bl);
    }

    private boolean matches(String string, String string2, boolean bl) {
        return string != null && (bl && string.matches(string2) || !bl && string.toLowerCase().contains(string2.toLowerCase()));
    }
}

