/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Concept;
import org.hl7.fhir.utilities.ucum.ConceptKind;
import org.hl7.fhir.utilities.ucum.Converter;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.DefinitionParser;
import org.hl7.fhir.utilities.ucum.ExpressionComposer;
import org.hl7.fhir.utilities.ucum.ExpressionParser;
import org.hl7.fhir.utilities.ucum.FormalStructureComposer;
import org.hl7.fhir.utilities.ucum.Pair;
import org.hl7.fhir.utilities.ucum.Search;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.UcumService;
import org.hl7.fhir.utilities.ucum.UcumValidator;
import org.hl7.fhir.utilities.ucum.special.Registry;

public class UcumEssenceService
implements UcumService {
    public static final String UCUM_OID = "2.16.840.1.113883.6.8";
    private UcumModel model;
    private Registry handlers = new Registry();

    public UcumEssenceService(InputStream inputStream) throws Exception {
        assert (inputStream != null) : this.paramError("factory", "stream", "must not be null");
        try {
            this.model = new DefinitionParser().parse(inputStream);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public UcumEssenceService(String string) throws Exception {
        assert (new File(string).exists()) : this.paramError("factory", "file", "must exist");
        try {
            this.model = new DefinitionParser().parse(string);
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    private String paramError(String string, String string2, String string3) {
        return this.getClass().getName() + "." + string + "." + string2 + " is not acceptable: " + string3;
    }

    @Override
    public UcumService.UcumVersionDetails ucumIdentification() {
        return new UcumService.UcumVersionDetails(this.model.getRevisionDate(), this.model.getVersion());
    }

    @Override
    public UcumModel getModel() {
        return this.model;
    }

    @Override
    public List<Concept> search(ConceptKind conceptKind, String string, boolean bl) {
        assert (this.checkStringParam(string)) : this.paramError("search", "text", "must not be null or empty");
        return new Search().doSearch(this.model, conceptKind, string, bl);
    }

    @Override
    public List<String> validateUCUM() {
        return new UcumValidator(this.model, this.handlers).validate();
    }

    @Override
    public Set<String> getProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        for (DefinedUnit definedUnit : this.model.getDefinedUnits()) {
            hashSet.add(definedUnit.getProperty());
        }
        return hashSet;
    }

    @Override
    public String validate(String string) {
        assert (string != null) : this.paramError("validate", "unit", "must not be null");
        try {
            new ExpressionParser(this.model).parse(string);
            return null;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String validateInProperty(String string, String string2) {
        assert (this.checkStringParam(string)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(string2)) : this.paramError("validateInProperty", "property", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(string);
            Canonical canonical = new Converter(this.model, this.handlers).convert(term);
            String string3 = new ExpressionComposer().compose(canonical, false);
            if (canonical.getUnits().size() == 1) {
                if (string2.equals(canonical.getUnits().get(0).getBase().getProperty())) {
                    return null;
                }
                return "unit " + string + " is of the property type " + canonical.getUnits().get(0).getBase().getProperty() + " (" + string3 + "), not " + string2 + " as required.";
            }
            if ("concentration".equals(string2) && ("g/L".equals(string3) || "mol/L".equals(string3))) {
                return null;
            }
            return "unit " + string + " has the base units " + string3 + ", and are not from the property " + string2 + " as required.";
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String validateCanonicalUnits(String string, String string2) {
        assert (this.checkStringParam(string)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(string2)) : this.paramError("validateCanonicalUnits", "canonical", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(string);
            Canonical canonical = new Converter(this.model, this.handlers).convert(term);
            String string3 = new ExpressionComposer().compose(canonical, false);
            if (!string2.equals(string3)) {
                return "unit " + string + " has the base units " + string3 + ", not " + string2 + " as required.";
            }
            return null;
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    @Override
    public String analyse(String string) throws Exception {
        if (Utilities.noString(string)) {
            return "(unity)";
        }
        assert (this.checkStringParam(string)) : this.paramError("analyse", "unit", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse(string);
        return new FormalStructureComposer().compose(term);
    }

    @Override
    public String getCanonicalUnits(String string) throws Exception {
        assert (this.checkStringParam(string)) : this.paramError("getCanonicalUnits", "unit", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(string);
            return new ExpressionComposer().compose(new Converter(this.model, this.handlers).convert(term), false);
        }
        catch (Exception exception) {
            throw new Exception("Error processing " + string + ": " + exception.getMessage(), exception);
        }
    }

    @Override
    public List<DefinedUnit> getDefinedForms(String string) throws Exception {
        assert (this.checkStringParam(string)) : this.paramError("getDefinedForms", "code", "must not be null or empty");
        ArrayList<DefinedUnit> arrayList = new ArrayList<DefinedUnit>();
        BaseUnit baseUnit = this.model.getBaseUnit(string);
        if (baseUnit != null) {
            for (DefinedUnit definedUnit : this.model.getDefinedUnits()) {
                if (definedUnit.isSpecial() || !string.equals(this.getCanonicalUnits(definedUnit.getCode()))) continue;
                arrayList.add(definedUnit);
            }
        }
        return arrayList;
    }

    private boolean checkStringParam(String string) {
        return string != null && !string.equals("");
    }

    @Override
    public Pair getCanonicalForm(Pair pair) throws Exception {
        assert (pair != null) : this.paramError("getCanonicalForm", "value", "must not be null");
        assert (this.checkStringParam(pair.getCode())) : this.paramError("getCanonicalForm", "value.code", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse(pair.getCode());
        Canonical canonical = new Converter(this.model, this.handlers).convert(term);
        if (pair.getValue() == null) {
            return new Pair(null, new ExpressionComposer().compose(canonical, false));
        }
        return new Pair(pair.getValue().multiply(canonical.getValue()), new ExpressionComposer().compose(canonical, false));
    }

    @Override
    public Decimal convert(Decimal decimal, String string, String string2) throws Exception {
        String string3;
        assert (decimal != null) : this.paramError("convert", "value", "must not be null");
        assert (this.checkStringParam(string)) : this.paramError("convert", "sourceUnit", "must not be null or empty");
        assert (this.checkStringParam(string2)) : this.paramError("convert", "destUnit", "must not be null or empty");
        if (string.equals(string2)) {
            return decimal;
        }
        Canonical canonical = new Converter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(string));
        Canonical canonical2 = new Converter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(string2));
        String string4 = new ExpressionComposer().compose(canonical, false);
        if (!string4.equals(string3 = new ExpressionComposer().compose(canonical2, false))) {
            throw new Exception("Unable to convert between units " + string + " and " + string2 + " as they do not have matching canonical forms (" + string4 + " and " + string3 + " respectively)");
        }
        Decimal decimal2 = decimal.multiply(canonical.getValue());
        return decimal2.divide(canonical2.getValue());
    }

    @Override
    public Pair multiply(Pair pair, Pair pair2) throws Exception {
        Pair pair3 = new Pair(pair.getValue().multiply(pair2.getValue()), pair.getCode() + "." + pair2.getCode());
        return this.getCanonicalForm(pair3);
    }

    @Override
    public String getCommonDisplay(String string) {
        return string.replace("[", "").replace("]", "");
    }

    @Override
    public boolean isComparable(String string, String string2) throws Exception {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        String string3 = this.getCanonicalUnits(string);
        String string4 = this.getCanonicalUnits(string2);
        return string3.equals(string4);
    }
}

