/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.Prefix;
import org.hl7.fhir.utilities.ucum.Unit;

public class UcumModel {
    private String version;
    private String revision;
    private Date revisionDate;
    private List<Prefix> prefixes = new ArrayList<Prefix>();
    private List<BaseUnit> baseUnits = new ArrayList<BaseUnit>();
    private List<DefinedUnit> definedUnits = new ArrayList<DefinedUnit>();

    public UcumModel(String string, String string2, Date date) {
        this.version = string;
        this.revision = string2;
        this.revisionDate = date;
    }

    public List<Prefix> getPrefixes() {
        return this.prefixes;
    }

    public List<BaseUnit> getBaseUnits() {
        return this.baseUnits;
    }

    public List<DefinedUnit> getDefinedUnits() {
        return this.definedUnits;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void setRevisionDate(Date date) {
        this.revisionDate = date;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Unit getUnit(String string) {
        for (Unit unit : this.getBaseUnits()) {
            if (!unit.getCode().equals(string)) continue;
            return unit;
        }
        for (Unit unit : this.getDefinedUnits()) {
            if (!unit.getCode().equals(string)) continue;
            return unit;
        }
        return null;
    }

    public BaseUnit getBaseUnit(String string) {
        for (BaseUnit baseUnit : this.getBaseUnits()) {
            if (!baseUnit.getCode().equals(string)) continue;
            return baseUnit;
        }
        return null;
    }
}

