/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.ucum.Concept;
import org.hl7.fhir.utilities.ucum.ConceptKind;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.Pair;
import org.hl7.fhir.utilities.ucum.UcumModel;

public interface UcumService {
    public UcumModel getModel();

    public UcumVersionDetails ucumIdentification();

    public List<String> validateUCUM();

    public List<Concept> search(ConceptKind var1, String var2, boolean var3);

    public Set<String> getProperties();

    public String validate(String var1);

    public String analyse(String var1) throws Exception;

    public String validateInProperty(String var1, String var2);

    public String validateCanonicalUnits(String var1, String var2);

    public String getCanonicalUnits(String var1) throws Exception;

    public boolean isComparable(String var1, String var2) throws Exception;

    public List<DefinedUnit> getDefinedForms(String var1) throws Exception;

    public Pair getCanonicalForm(Pair var1) throws Exception;

    public Decimal convert(Decimal var1, String var2, String var3) throws Exception;

    public Pair multiply(Pair var1, Pair var2) throws Exception;

    public String getCommonDisplay(String var1);

    public static class UcumVersionDetails {
        private Date releaseDate;
        private String version;

        public UcumVersionDetails(Date date, String string) {
            this.releaseDate = date;
            this.version = string;
        }

        public Date getReleaseDate() {
            return this.releaseDate;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

