/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.ucum.Converter;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.ExpressionComposer;
import org.hl7.fhir.utilities.ucum.ExpressionParser;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.Unit;
import org.hl7.fhir.utilities.ucum.special.Registry;

public class UcumValidator {
    private UcumModel model;
    private List<String> result;
    private Registry handlers;

    public UcumValidator(UcumModel ucumModel, Registry registry) {
        this.model = ucumModel;
        this.handlers = registry;
    }

    public List<String> validate() {
        this.result = new ArrayList<String>();
        this.checkCodes();
        this.checkUnits();
        return this.result;
    }

    private void checkCodes() {
        for (Unit unit : this.model.getBaseUnits()) {
            this.checkUnitCode(unit.getCode(), true);
        }
        for (Unit unit : this.model.getDefinedUnits()) {
            this.checkUnitCode(unit.getCode(), true);
        }
    }

    private void checkUnits() {
        for (DefinedUnit definedUnit : this.model.getDefinedUnits()) {
            if (!definedUnit.isSpecial()) {
                this.checkUnitCode(definedUnit.getValue().getUnit(), false);
                continue;
            }
            if (this.handlers.exists(definedUnit.getCode())) continue;
            this.result.add("No Handler for " + definedUnit.getCode().toString());
        }
    }

    private void checkUnitCode(String string, boolean bl) {
        try {
            Term term = new ExpressionParser(this.model).parse(string);
            String string2 = new ExpressionComposer().compose(term);
            if (!string2.equals(string)) {
                this.result.add("Round trip failed: " + string + " -> " + string2);
            }
            new Converter(this.model, this.handlers).convert(term);
        }
        catch (Exception exception) {
            this.result.add(string + ": " + exception.getMessage());
        }
        if (bl) {
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '[') {
                        if (bl2) {
                            throw new Exception("nested [");
                        }
                        bl2 = true;
                    }
                    if (c == ']') {
                        if (!bl2) {
                            throw new Exception("] without [");
                        }
                        bl2 = false;
                    }
                    boolean bl4 = bl3 = bl3 || c < '0' || c > '9';
                    if (c < '0' || c > '9' || bl2 || !bl3) continue;
                    throw new Exception("code " + string + " is ambiguous because  it has digits outside []");
                }
            }
            catch (Exception exception) {
                this.result.add(exception.getMessage());
            }
        }
    }
}

