/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum.special;

import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.special.CelsiusHandler;
import org.hl7.fhir.utilities.ucum.special.FahrenheitHandler;
import org.hl7.fhir.utilities.ucum.special.HoldingHandler;
import org.hl7.fhir.utilities.ucum.special.SpecialUnitHandler;

public class Registry {
    Map<String, SpecialUnitHandler> handlers = new HashMap<String, SpecialUnitHandler>();

    public Registry() {
        this.init();
    }

    private void register(SpecialUnitHandler specialUnitHandler) {
        this.handlers.put(specialUnitHandler.getCode(), specialUnitHandler);
    }

    private void init() {
        this.register(new CelsiusHandler());
        this.register(new FahrenheitHandler());
        this.register(new HoldingHandler("[p'diop]", "deg"));
        this.register(new HoldingHandler("%[slope]", "deg"));
        this.register(new HoldingHandler("[hp_X]", "1"));
        this.register(new HoldingHandler("[hp_C]", "1"));
        this.register(new HoldingHandler("[pH]", "mol/l"));
        this.register(new HoldingHandler("Np", "1"));
        this.register(new HoldingHandler("B", "1"));
        this.register(new HoldingHandler("B[SPL]", "10*-5.Pa", new Decimal(2)));
        this.register(new HoldingHandler("B[V]", "V"));
        this.register(new HoldingHandler("B[mV]", "mV"));
        this.register(new HoldingHandler("B[uV]", "uV"));
        this.register(new HoldingHandler("B[W]", "W"));
        this.register(new HoldingHandler("B[kW]", "kW"));
        this.register(new HoldingHandler("bit_s", "1"));
    }

    public boolean exists(String string) {
        return this.handlers.containsKey(string);
    }

    public SpecialUnitHandler get(String string) {
        return this.handlers.get(string);
    }
}

