/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.Pair;
import org.hl7.fhir.utilities.ucum.UcumEssenceService;
import org.hl7.fhir.utilities.ucum.UcumService;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class UcumTester {
    private String definitions;
    private String tests;
    private UcumService ucumSvc;
    private int errCount;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("UCUM Tester - parameters:");
            System.out.println("  -definitions [filename] - filename for the UCUM definitions");
            System.out.println("  -tests [fileanme] - filename for the UCUM tests");
            System.out.println("See http://unitsofmeasure.org/trac/ for source files for both ucum definitions");
            System.out.println("(ucum-essence.xml) and tests (http://unitsofmeasure.org/trac/wiki/FunctionalTests)");
        } else {
            UcumTester ucumTester = new UcumTester();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                ++i;
                if (string.equalsIgnoreCase("-definitions")) {
                    ucumTester.setDefinitions(stringArray[i]);
                    continue;
                }
                if (string.equalsIgnoreCase("-tests")) {
                    ucumTester.setTests(stringArray[i]);
                    continue;
                }
                System.out.println("Unknown parameter: '" + string + "'");
            }
            ucumTester.execute();
        }
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(String string) {
        this.definitions = string;
    }

    public String getTests() {
        return this.tests;
    }

    public void setTests(String string) {
        this.tests = string;
    }

    private void execute() throws Exception {
        this.testDecimal();
        this.ucumSvc = new UcumEssenceService(this.definitions);
        this.errCount = 0;
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput((InputStream)new FileInputStream(this.tests), null);
        int n = xmlPullParser.next();
        if (n != 2) {
            throw new XmlPullParserException("Unable to process XML document");
        }
        if (!xmlPullParser.getName().equals("ucumTests")) {
            throw new XmlPullParserException("Unable to process XML document: expected 'ucumTests' but found '" + xmlPullParser.getName() + "'");
        }
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("history")) {
                this.skipElement(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("validation")) {
                this.runValidationTests(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("displayNameGeneration")) {
                this.runDisplayNameGeneration(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("conversion")) {
                this.runConversion(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("multiplication")) {
                this.runMultiplication(xmlPullParser);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        xmlPullParser.next();
        if (this.errCount > 0) {
            System.err.println(Integer.toString(this.errCount) + " errors");
        }
    }

    private void runMultiplication(XmlPullParser xmlPullParser) throws Exception {
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("case")) {
                this.runMultiplicationCase(xmlPullParser);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        xmlPullParser.next();
    }

    private void runMultiplicationCase(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue(null, "id");
        String string2 = xmlPullParser.getAttributeValue(null, "v1");
        String string3 = xmlPullParser.getAttributeValue(null, "u1");
        String string4 = xmlPullParser.getAttributeValue(null, "v2");
        String string5 = xmlPullParser.getAttributeValue(null, "u2");
        String string6 = xmlPullParser.getAttributeValue(null, "vRes");
        String string7 = xmlPullParser.getAttributeValue(null, "uRes");
        Pair pair = new Pair(new Decimal(string2), string3);
        Pair pair2 = new Pair(new Decimal(string4), string5);
        Pair pair3 = this.ucumSvc.multiply(pair, pair2);
        this.debug("Multiplication Test " + string + ": the value '" + string2 + " " + string3 + "' * '" + string4 + " " + string5 + "' ==> " + pair3.getValue().toString() + " " + pair3.getCode());
        if (pair3.getValue().comparesTo(new Decimal(string6)) != 0 || !pair3.getCode().equals(string7)) {
            ++this.errCount;
            System.err.println("Test " + string + ": The value '" + string6 + " " + string7 + "' was expected, but the result was " + pair3.getValue().toString() + " " + pair3.getCode());
        }
        while (xmlPullParser.getEventType() != 3) {
            xmlPullParser.next();
        }
        xmlPullParser.next();
    }

    private void testDecimal() throws Exception {
        this.testAsInteger();
        this.testStringSupport();
        this.testCompares();
        this.testAddition();
        this.testMultiplication();
    }

    private void testMultiplication() throws Exception {
        this.testMultiply("2", "2", "4");
        this.testMultiply("2", "0.5", "1");
        this.testMultiply("0", "0", "0");
        this.testMultiply("0", "1", "0");
        this.testMultiply("4", "4", "16");
        this.testMultiply("20", "20", "400");
        this.testMultiply("200", "20", "4000");
        this.testMultiply("400", "400", "160000");
        this.testMultiply("2.0", "2.0", "4.0");
        this.testMultiply("2.00", "2.0", "4.0");
        this.testMultiply("2.0", "0.2", "0.4");
        this.testMultiply("2.0", "0.20", "0.40");
        this.testMultiply("13", "13", "169");
        this.testMultiply("12", "89", "1068");
        this.testMultiply("1234", "6789", "8377626");
        this.testMultiply("10000", "0.0001", "1");
        this.testMultiply("10000", "0.00010", "1.0");
        this.testMultiply("10000", "0.000100", "1.00");
        this.testMultiply("10000", "0.0001000", "1.000");
        this.testMultiply("10000", "0.00010000", "1.0000");
        this.testMultiply("10000", "0.000100000", "1.00000");
        this.testMultiply("10000.0", "0.000100000", "1.00000");
        this.testMultiply("10000.0", "0.0001000000", "1.00000");
        this.testMultiply("10000.0", "0.00010000000", "1.00000");
        this.testMultiply("2", "-2", "-4");
        this.testMultiply("-2", "2", "-4");
        this.testMultiply("-2", "-2", "4");
        this.testMultiply("35328734682734", "2349834295876423", "83016672387407213199375780482");
        this.testMultiply("35328734682734000000000", "2349834295876423000000000", "83016672387407213199375780482000000000000000000");
        this.testMultiply("3532873468.2734", "23498342958.76423", "83016672387407213199.375780482");
        this.testDivide("500", "4", "125");
        this.testDivide("1260257", "37", "34061");
        this.testDivide("127", "4", "31.75");
        this.testDivide("10", "10", "1");
        this.testDivide("1", "1", "1");
        this.testDivide("10", "3", "3.3");
        this.testDivide("10.0", "3", "3.33");
        this.testDivide("10.00", "3", "3.333");
        this.testDivide("10.00", "3.0", "3.3");
        this.testDivide("100", "1", "100");
        this.testDivide("1000", "10", "100");
        this.testDivide("100001", "10", "10000.1");
        this.testDivide("100", "10", "10");
        this.testDivide("1", "10", "0.1");
        this.testDivide("1", "15", "0.067");
        this.testDivide("1.0", "15", "0.067");
        this.testDivide("1.00", "15.0", "0.0667");
        this.testDivide("1", "0.1", "10");
        this.testDivide("1", "0.10", "10");
        this.testDivide("1", "0.010", "100");
        this.testDivide("1", "1.5", "0.67");
        this.testDivide("1.0", "1.5", "0.67");
        this.testDivide("10", "1.5", "6.7");
        this.testDivide("-1", "1", "-1");
        this.testDivide("1", "-1", "-1");
        this.testDivide("-1", "-1", "1");
        this.testDivide("2", "2", "1");
        this.testDivide("20", "2", "10");
        this.testDivide("22", "2", "11");
        this.testDivide("83016672387407213199375780482", "2349834295876423", "35328734682734");
        this.testDivide("83016672387407213199375780482000000000000000000", "2349834295876423000000000", "35328734682734000000000");
        this.testDivide("83016672387407213199.375780482", "23498342958.76423", "3532873468.2734");
        this.testDivInt("500", "4", "125");
        this.testDivInt("1260257", "37", "34061");
        this.testDivInt("127", "4", "31");
        this.testDivInt("10", "10", "1");
        this.testDivInt("1", "1", "1");
        this.testDivInt("100", "1", "100");
        this.testDivInt("1000", "10", "100");
        this.testDivInt("100001", "10", "10000");
        this.testDivInt("1", "1.5", "0");
        this.testDivInt("10", "1.5", "6");
        this.testModulo("10", "1", "0");
        this.testModulo("7", "4", "3");
        this.testMultiply("2", "2", "4");
        this.testMultiply("2.0", "2.0", "4.0");
        this.testMultiply("2.00", "2.0", "4.0");
        this.testDivide("10", "3", "3.3");
        this.testDivide("10.0", "3", "3.33");
        this.testDivide("10.00", "3", "3.333");
        this.testDivide("10.00", "3.0", "3.3");
        this.testDivide("10", "3.0", "3.3");
    }

    private void testModulo(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.modulo(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " % " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testDivInt(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.divInt(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " /(int) " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testDivide(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.divide(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " / " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testMultiply(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.multiply(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " * " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testAddition() throws Exception {
        this.testAdd("1", "1", "2");
        this.testAdd("0", "1", "1");
        this.testAdd("0", "0", "0");
        this.testAdd("5", "5", "10");
        this.testAdd("10", "1", "11");
        this.testAdd("11", "12", "23");
        this.testAdd("15", "16", "31");
        this.testAdd("150", "160", "310");
        this.testAdd("153", "168", "321");
        this.testAdd("15300000000000000000000000000000000001", "1680", "15300000000000000000000000000000001681");
        this.testAdd("1", ".1", "1.1");
        this.testAdd("1", ".001", "1.001");
        this.testAdd(".1", ".1", "0.2");
        this.testAdd(".1", ".01", "0.11");
        this.testSubtract("2", "1", "1");
        this.testSubtract("2", "0", "2");
        this.testSubtract("0", "0", "0");
        this.testSubtract("0", "2", "-2");
        this.testSubtract("2", "2", "0");
        this.testSubtract("1", "2", "-1");
        this.testSubtract("20", "1", "19");
        this.testSubtract("2", ".1", "1.9");
        this.testSubtract("2", ".000001", "1.999999");
        this.testSubtract("2", "2.000001", "-0.000001");
        this.testSubtract("3.5", "35.5", "-32.0");
        this.testAdd("5", "6", "11");
        this.testAdd("5", "-6", "-1");
        this.testAdd("-5", "6", "1");
        this.testAdd("-5", "-6", "-11");
        this.testSubtract("5", "6", "-1");
        this.testSubtract("6", "5", "1");
        this.testSubtract("5", "-6", "11");
        this.testSubtract("6", "-5", "11");
        this.testSubtract("-5", "6", "-11");
        this.testSubtract("-6", "5", "-11");
        this.testSubtract("-5", "-6", "1");
        this.testSubtract("-6", "-5", "-1");
        this.testAdd("2", "0.001", "2.001");
        this.testAdd("2.0", "0.001", "2.001");
    }

    private void testSubtract(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.subtract(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " - " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testAdd(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        Decimal decimal3 = decimal.add(decimal2);
        this.check(decimal3.asDecimal().equals(string3), string + " + " + string2 + " = " + string3 + ", but the library returned " + decimal3.asDecimal());
    }

    private void testCompares() throws Exception {
        this.testCompares("1", "1", 0);
        this.testCompares("0", "0", 0);
        this.testCompares("0", "1", -1);
        this.testCompares("1", "0", 1);
        this.testCompares("10", "10", 0);
        this.testCompares("100", "100", 0);
        this.testCompares("0.1", "0.1", 0);
        this.testCompares("0.01", "0.01", 0);
        this.testCompares("0.01", "0.0100", 0);
        this.testCompares("1", "1.00000000", 0);
        this.testCompares("1.111111", "1.111111", 0);
    }

    private void testCompares(String string, String string2, int n) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = new Decimal(string2);
        int n2 = decimal.comparesTo(decimal2);
        this.check(n2 == n, "Compare fail: " + string + ".compares(" + string2 + ") should be " + Integer.toString(n) + " but was " + Integer.toString(n2));
    }

    private void testStringSupport() throws Exception {
        this.testString("1", "1", "1e0");
        this.testString("0", "0", "0e0");
        this.testString("10", "10", "1.0e1");
        this.testString("99", "99", "9.9e1");
        this.testString("-1", "-1", "-1e0");
        this.testString("-0", "0", "0e0");
        this.testString("-10", "-10", "-1.0e1");
        this.testString("-99", "-99", "-9.9e1");
        this.testString("1.1", "1.1", "1.1e0");
        this.testString("-1.1", "-1.1", "-1.1e0");
        this.testString("11.1", "11.1", "1.11e1");
        this.testString("1.11", "1.11", "1.11e0");
        this.testString("1.111", "1.111", "1.111e0");
        this.testString("0.1", "0.1", "1e-1");
        this.testString("00.1", "0.1", "1e-1");
        this.testString(".1", "0.1", "1e-1");
        this.testString("1.0", "1.0", "1.0e0");
        this.testString("1.00", "1.00", "1.00e0");
        this.testString("1.000000000000000000000000000000000000000", "1.000000000000000000000000000000000000000", "1.000000000000000000000000000000000000000e0");
        this.testString("-11.1", "-11.1", "-1.11e1");
        this.testString("-1.11", "-1.11", "-1.11e0");
        this.testString("-1.111", "-1.111", "-1.111e0");
        this.testString("-0.1", "-0.1", "-1e-1");
        this.testString("-00.1", "-0.1", "-1e-1");
        this.testString("-.1", "-0.1", "-1e-1");
        this.testString("-1.0", "-1.0", "-1.0e0");
        this.testString("-1.00", "-1.00", "-1.00e0");
        this.testString("-1.000000000000000000000000000000000000000", "-1.000000000000000000000000000000000000000", "-1.000000000000000000000000000000000000000e0");
        this.testString("0.0", "0.0", "0.0e0");
        this.testString("0.0000", "0.0000", "0.0000e0");
        this.testString("0.1", "0.1", "1e-1");
        this.testString("00.1", "0.1", "1e-1");
        this.testString("0.100", "0.100", "1.00e-1");
        this.testString("100", "100", "1.00e2");
        this.testString("1.0", "1.0", "1.0e0");
        this.testString("1.1", "1.1", "1.1e0");
        this.testString("-0.1", "-0.1", "-1e-1");
        this.testString("0.01", "0.01", "1e-2");
        this.testString("0.001", "0.001", "1e-3");
        this.testString("0.0001", "0.0001", "1e-4");
        this.testString("00.0001", "0.0001", "1e-4");
        this.testString("000.0001", "0.0001", "1e-4");
        this.testString("-0.01", "-0.01", "-1e-2");
        this.testString("10.01", "10.01", "1.001e1");
        this.testString("0.0001", "0.0001", "1e-4");
        this.testString("0.00001", "0.00001", "1e-5");
        this.testString("0.000001", "0.000001", "1e-6");
        this.testString("0.0000001", "0.0000001", "1e-7");
        this.testString("0.000000001", "0.000000001", "1e-9");
        this.testString("0.00000000001", "0.00000000001", "1e-11");
        this.testString("0.0000000000001", "0.0000000000001", "1e-13");
        this.testString("0.000000000000001", "0.000000000000001", "1e-15");
        this.testString("0.00000000000000001", "0.00000000000000001", "1e-17");
        this.testString("10.1", "10.1", "1.01e1");
        this.testString("100.1", "100.1", "1.001e2");
        this.testString("1000.1", "1000.1", "1.0001e3");
        this.testString("10000.1", "10000.1", "1.00001e4");
        this.testString("100000.1", "100000.1", "1.000001e5");
        this.testString("1000000.1", "1000000.1", "1.0000001e6");
        this.testString("10000000.1", "10000000.1", "1.00000001e7");
        this.testString("100000000.1", "100000000.1", "1.000000001e8");
        this.testString("1000000000.1", "1000000000.1", "1.0000000001e9");
        this.testString("10000000000.1", "10000000000.1", "1.00000000001e10");
        this.testString("100000000000.1", "100000000000.1", "1.000000000001e11");
        this.testString("1000000000000.1", "1000000000000.1", "1.0000000000001e12");
        this.testString("10000000000000.1", "10000000000000.1", "1.00000000000001e13");
        this.testString("100000000000000.1", "100000000000000.1", "1.000000000000001e14");
        this.testTrunc("1", "1");
        this.testTrunc("1.01", "1");
        this.testTrunc("-1.01", "-1");
        this.testTrunc("0.01", "0");
        this.testTrunc("-0.01", "0");
        this.testTrunc("0.1", "0");
        this.testTrunc("0.0001", "0");
        this.testTrunc("100.000000000000000000000000000000000000000001", "100");
    }

    private void testTrunc(String string, String string2) throws Exception {
        Decimal decimal = new Decimal(string);
        Decimal decimal2 = decimal.trunc();
        this.check(decimal2.asDecimal().equals(string2), "wrong trunc - expected " + string2 + " but got " + decimal2.asDecimal());
    }

    private void testString(String string, String string2, String string3) throws Exception {
        Decimal decimal = new Decimal(string);
        String string4 = decimal.toString();
        String string5 = decimal.asScientific();
        this.check(string4.equals(string2), "decimal: expected " + string2 + " but got " + string4);
        this.check(string5.equals(string3), "scientific: expected " + string3 + " but got " + string5);
        decimal = new Decimal(string3);
        string4 = decimal.asDecimal();
        this.check(string4.equals(string2), "decimal(2): expected " + string2 + " but got " + string4);
    }

    private void testAsInteger() throws Exception {
        this.testInteger(0);
        this.testInteger(1);
        this.testInteger(2);
        this.testInteger(64);
        this.testInteger(Integer.MAX_VALUE);
        this.testInteger(-1);
        this.testInteger(-2);
        this.testInteger(-64);
        this.testInteger(Integer.MIN_VALUE);
    }

    private void testInteger(int n) throws Exception {
        Decimal decimal = new Decimal(n);
        this.check(decimal.asInteger() == n, "Failed to round trip the integer " + Integer.toString(n));
    }

    private void check(boolean bl, String string) {
        if (!bl) {
            throw new Error(string);
        }
    }

    private void runConversion(XmlPullParser xmlPullParser) throws Exception {
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("case")) {
                this.runConversionCase(xmlPullParser);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        xmlPullParser.next();
    }

    private void runConversionCase(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue(null, "id");
        String string2 = xmlPullParser.getAttributeValue(null, "value");
        String string3 = xmlPullParser.getAttributeValue(null, "srcUnit");
        String string4 = xmlPullParser.getAttributeValue(null, "dstUnit");
        String string5 = xmlPullParser.getAttributeValue(null, "outcome");
        System.out.println("case " + string + ": " + string2 + " " + string3 + " -> " + string5 + " " + string4);
        Decimal decimal = this.ucumSvc.convert(new Decimal(string2), string3, string4);
        this.debug("Convert Test " + string + ": the value '" + string2 + " " + string3 + "' ==> " + decimal.toString() + " " + string4);
        if (decimal.comparesTo(new Decimal(string5)) != 0) {
            ++this.errCount;
            System.err.println("Test " + string + ": The value '" + string5 + "' was expected the result was " + decimal.toString());
        }
        while (xmlPullParser.getEventType() != 3) {
            xmlPullParser.next();
        }
        xmlPullParser.next();
    }

    private void debug(String string) {
        System.out.println(string);
    }

    private void runDisplayNameGeneration(XmlPullParser xmlPullParser) throws Exception {
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("case")) {
                this.runDisplayNameGenerationCase(xmlPullParser);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        xmlPullParser.next();
    }

    private void runDisplayNameGenerationCase(XmlPullParser xmlPullParser) throws Exception {
        String string = xmlPullParser.getAttributeValue(null, "id");
        String string2 = xmlPullParser.getAttributeValue(null, "unit");
        String string3 = xmlPullParser.getAttributeValue(null, "display");
        String string4 = this.ucumSvc.analyse(string2);
        this.debug("Analyse Test " + string + ": the unit '" + string2 + "' ==> " + string4);
        if (!string4.equals(string3)) {
            ++this.errCount;
            System.err.println("Test " + string + ": The unit '" + string2 + "' was expected to be displayed as '" + string3 + "', but was displayed as " + string4);
        }
        while (xmlPullParser.getEventType() != 3) {
            xmlPullParser.next();
        }
        xmlPullParser.next();
    }

    private void runValidationTests(XmlPullParser xmlPullParser) throws Exception {
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("case")) {
                this.runValidationCase(xmlPullParser);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        xmlPullParser.next();
    }

    private void runValidationCase(XmlPullParser xmlPullParser) throws Exception {
        boolean bl;
        String string = xmlPullParser.getAttributeValue(null, "id");
        String string2 = xmlPullParser.getAttributeValue(null, "unit");
        boolean bl2 = "true".equals(xmlPullParser.getAttributeValue(null, "valid"));
        String string3 = xmlPullParser.getAttributeValue(null, "reason");
        String string4 = this.ucumSvc.validate(string2);
        boolean bl3 = bl = string4 == null;
        if (bl) {
            this.debug("Validation Test " + string + ": the unit '" + string2 + "' is valid");
        } else {
            this.debug("Validation Test " + string + ": the unit '" + string2 + "' is not valid because " + string4);
        }
        if (bl2 != bl) {
            ++this.errCount;
            if (bl2) {
                System.err.println("Test " + string + ": The unit '" + string2 + "' was expected to be valid, but wasn't accepted");
            } else {
                System.err.println("Test " + string + ": The unit '" + string2 + "' was expected to be invalid because '" + string3 + "', but was accepted");
            }
        }
        while (xmlPullParser.getEventType() != 3) {
            xmlPullParser.next();
        }
        xmlPullParser.next();
    }

    private void skipElement(XmlPullParser xmlPullParser) throws Exception {
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 2) {
                this.skipElement(xmlPullParser);
                continue;
            }
            xmlPullParser.next();
        }
        xmlPullParser.next();
    }
}

