/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.IXMLWriter;

public class XhtmlComposer {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private boolean pretty;
    private Writer dst;

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        this.pretty = bl;
    }

    public String compose(XhtmlDocument xhtmlDocument) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.dst = stringWriter;
        this.composeDoc(xhtmlDocument);
        return stringWriter.toString();
    }

    public String compose(XhtmlNode xhtmlNode) throws Exception {
        StringWriter stringWriter = new StringWriter();
        this.dst = stringWriter;
        this.writeNode("", xhtmlNode);
        return stringWriter.toString();
    }

    public void compose(OutputStream outputStream, XhtmlDocument xhtmlDocument) throws Exception {
        byte[] byArray = new byte[]{-17, -69, -65};
        outputStream.write(byArray);
        this.dst = new OutputStreamWriter(outputStream, "UTF-8");
        this.composeDoc(xhtmlDocument);
        this.dst.flush();
    }

    private void composeDoc(XhtmlDocument xhtmlDocument) throws Exception {
        for (XhtmlNode xhtmlNode : xhtmlDocument.getChildNodes()) {
            this.writeNode("  ", xhtmlNode);
        }
    }

    private void writeNode(String string, XhtmlNode xhtmlNode) throws Exception {
        if (xhtmlNode.getNodeType() == NodeType.Comment) {
            this.writeComment(string, xhtmlNode);
        } else if (xhtmlNode.getNodeType() == NodeType.DocType) {
            this.writeDocType(xhtmlNode);
        } else if (xhtmlNode.getNodeType() == NodeType.Instruction) {
            this.writeInstruction(xhtmlNode);
        } else if (xhtmlNode.getNodeType() == NodeType.Element) {
            this.writeElement(string, xhtmlNode);
        } else if (xhtmlNode.getNodeType() == NodeType.Text) {
            this.writeText(xhtmlNode);
        } else {
            throw new Exception("Unknown node type: " + xhtmlNode.getNodeType().toString());
        }
    }

    private void writeText(XhtmlNode xhtmlNode) throws Exception {
        for (char c : xhtmlNode.getContent().toCharArray()) {
            if (c == '&') {
                this.dst.append("&amp;");
                continue;
            }
            if (c == '<') {
                this.dst.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.dst.append("&gt;");
                continue;
            }
            if (c == '\"') {
                this.dst.append("&quot;");
                continue;
            }
            if (c == XhtmlNode.NBSP.charAt(0)) {
                this.dst.append("&nbsp;");
                continue;
            }
            if (c == '\u00a7') {
                this.dst.append("&sect;");
                continue;
            }
            if (c == '\u00a9') {
                this.dst.append("&copy;");
                continue;
            }
            if (c == '\u2122') {
                this.dst.append("&trade;");
                continue;
            }
            if (c == '\u03bc') {
                this.dst.append("&mu;");
                continue;
            }
            if (c == '\u00ae') {
                this.dst.append("&reg;");
                continue;
            }
            this.dst.append(c);
        }
    }

    private void writeComment(String string, XhtmlNode xhtmlNode) throws IOException {
        this.dst.append(string + "<!-- " + xhtmlNode.getContent().trim() + " -->" + (this.isPretty() ? "\r\n" : ""));
    }

    private void writeDocType(XhtmlNode xhtmlNode) throws IOException {
        this.dst.append("<!" + xhtmlNode.getContent() + ">\r\n");
    }

    private void writeInstruction(XhtmlNode xhtmlNode) throws IOException {
        this.dst.append("<?" + xhtmlNode.getContent() + "?>\r\n");
    }

    private String escapeHtml(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String attributes(XhtmlNode xhtmlNode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : xhtmlNode.getAttributes().keySet()) {
            stringBuilder.append(" " + string + "=\"" + this.escapeHtml(xhtmlNode.getAttributes().get(string)) + "\"");
        }
        return stringBuilder.toString();
    }

    private void writeElement(String string, XhtmlNode xhtmlNode) throws Exception {
        if (!this.pretty) {
            string = "";
        }
        if (xhtmlNode.getChildNodes().size() == 0) {
            this.dst.append(string + "<" + xhtmlNode.getName() + this.attributes(xhtmlNode) + "/>" + (this.isPretty() ? "\r\n" : ""));
        } else {
            boolean bl = xhtmlNode.allChildrenAreText();
            if (bl || !this.pretty) {
                this.dst.append(string + "<" + xhtmlNode.getName() + this.attributes(xhtmlNode) + ">");
            } else {
                this.dst.append(string + "<" + xhtmlNode.getName() + this.attributes(xhtmlNode) + ">\r\n");
            }
            if (xhtmlNode.getName() == "head" && xhtmlNode.getElement("meta") == null) {
                this.dst.append(string + "  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>" + (this.isPretty() ? "\r\n" : ""));
            }
            for (XhtmlNode xhtmlNode2 : xhtmlNode.getChildNodes()) {
                this.writeNode(string + "  ", xhtmlNode2);
            }
            if (bl) {
                this.dst.append("</" + xhtmlNode.getName() + ">" + (this.isPretty() ? "\r\n" : ""));
            } else if (xhtmlNode.getChildNodes().get(xhtmlNode.getChildNodes().size() - 1).getNodeType() == NodeType.Text) {
                this.dst.append((this.isPretty() ? "\r\n" + string : "") + "</" + xhtmlNode.getName() + ">" + (this.isPretty() ? "\r\n" : ""));
            } else {
                this.dst.append(string + "</" + xhtmlNode.getName() + ">" + (this.isPretty() ? "\r\n" : ""));
            }
        }
    }

    public void compose(IXMLWriter iXMLWriter, XhtmlNode xhtmlNode) throws Exception {
        if (xhtmlNode.getNodeType() == NodeType.Comment) {
            iXMLWriter.comment(xhtmlNode.getContent(), this.isPretty());
        } else if (xhtmlNode.getNodeType() == NodeType.Element) {
            this.composeElement(iXMLWriter, xhtmlNode);
        } else if (xhtmlNode.getNodeType() == NodeType.Text) {
            iXMLWriter.text(xhtmlNode.getContent());
        } else {
            throw new Exception("Unhandled node type: " + xhtmlNode.getNodeType().toString());
        }
    }

    private void composeElement(IXMLWriter iXMLWriter, XhtmlNode xhtmlNode) throws Exception {
        for (String object : xhtmlNode.getAttributes().keySet()) {
            iXMLWriter.attribute(object, xhtmlNode.getAttributes().get(object));
        }
        iXMLWriter.open(XHTML_NS, xhtmlNode.getName());
        for (XhtmlNode xhtmlNode2 : xhtmlNode.getChildNodes()) {
            this.compose(iXMLWriter, xhtmlNode2);
        }
        iXMLWriter.close(XHTML_NS, xhtmlNode.getName());
    }

    public String composePlainText(XhtmlNode xhtmlNode) {
        StringBuilder stringBuilder = new StringBuilder();
        this.composePlainText(xhtmlNode, stringBuilder, false);
        return stringBuilder.toString().trim();
    }

    private boolean composePlainText(XhtmlNode xhtmlNode, StringBuilder stringBuilder, boolean bl) {
        if (xhtmlNode.getNodeType() == NodeType.Text) {
            String string;
            if (!bl & ((string = xhtmlNode.getContent()).startsWith(" ") || string.startsWith("\r") || string.startsWith("\n") || string.endsWith("\t"))) {
                stringBuilder.append(" ");
                bl = true;
            }
            String string2 = string.trim().replace("\r", " ").replace("\n", " ").replace("\t", " ");
            while (string2.contains("  ")) {
                string2 = string2.replace("  ", " ");
            }
            if (!Utilities.noString(string2)) {
                stringBuilder.append(string2);
                bl = false;
                if (!bl & (string.endsWith(" ") || string.endsWith("\r") || string.endsWith("\n") || string.endsWith("\t"))) {
                    stringBuilder.append(" ");
                    bl = true;
                }
            }
            return bl;
        }
        if (xhtmlNode.getNodeType() == NodeType.Element) {
            if (xhtmlNode.getName().equals("li")) {
                stringBuilder.append("* ");
                bl = true;
            }
            for (XhtmlNode xhtmlNode2 : xhtmlNode.getChildNodes()) {
                bl = this.composePlainText(xhtmlNode2, stringBuilder, bl);
            }
            if (xhtmlNode.getName().equals("p")) {
                stringBuilder.append("\r\n\r\n");
                bl = true;
            }
            if (xhtmlNode.getName().equals("br") || xhtmlNode.getName().equals("li")) {
                stringBuilder.append("\r\n");
                bl = true;
            }
            return bl;
        }
        return bl;
    }
}

