/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.xhtml.NodeType;

public class XhtmlNode {
    public static final String NBSP = Character.toString('\u00a0');
    private NodeType nodeType;
    private String name;
    private Map<String, String> Attributes = new HashMap<String, String>();
    private List<XhtmlNode> childNodes = new ArrayList<XhtmlNode>();
    private String content;

    public XhtmlNode() {
    }

    public XhtmlNode(NodeType nodeType, String string) {
        this.nodeType = nodeType;
        this.name = string;
    }

    public XhtmlNode(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Map<String, String> getAttributes() {
        return this.Attributes;
    }

    public List<XhtmlNode> getChildNodes() {
        return this.childNodes;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        if (this.nodeType == NodeType.Text && this.nodeType == NodeType.Comment) {
            throw new Error("Wrong node type");
        }
        this.content = string;
    }

    public XhtmlNode addTag(String string) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type. is " + this.nodeType.toString());
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element);
        xhtmlNode.setName(string);
        this.childNodes.add(xhtmlNode);
        return xhtmlNode;
    }

    public XhtmlNode addTag(int n, String string) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type. is " + this.nodeType.toString());
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element);
        xhtmlNode.setName(string);
        this.childNodes.add(n, xhtmlNode);
        return xhtmlNode;
    }

    public XhtmlNode addComment(String string) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Comment);
        xhtmlNode.setContent(string);
        this.childNodes.add(xhtmlNode);
        return xhtmlNode;
    }

    public XhtmlNode addDocType(String string) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.DocType);
        xhtmlNode.setContent(string);
        this.childNodes.add(xhtmlNode);
        return xhtmlNode;
    }

    public XhtmlNode addInstruction(String string) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Instruction);
        xhtmlNode.setContent(string);
        this.childNodes.add(xhtmlNode);
        return xhtmlNode;
    }

    public XhtmlNode addText(String string) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (string != null) {
            XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Text);
            xhtmlNode.setContent(string);
            this.childNodes.add(xhtmlNode);
            return xhtmlNode;
        }
        return null;
    }

    public XhtmlNode addText(int n, String string) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (string == null) {
            throw new Error("Content cannot be null");
        }
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Text);
        xhtmlNode.setContent(string);
        this.childNodes.add(n, xhtmlNode);
        return xhtmlNode;
    }

    public boolean allChildrenAreText() {
        boolean bl = true;
        for (XhtmlNode xhtmlNode : this.childNodes) {
            bl = bl && xhtmlNode.getNodeType() == NodeType.Text;
        }
        return bl;
    }

    public XhtmlNode getElement(String string) {
        for (XhtmlNode xhtmlNode : this.childNodes) {
            if (xhtmlNode.getNodeType() != NodeType.Element || !string.equals(xhtmlNode.getName())) continue;
            return xhtmlNode;
        }
        return null;
    }

    public XhtmlNode getFirstElement() {
        for (XhtmlNode xhtmlNode : this.childNodes) {
            if (xhtmlNode.getNodeType() != NodeType.Element) continue;
            return xhtmlNode;
        }
        return null;
    }

    public String allText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (XhtmlNode xhtmlNode : this.childNodes) {
            if (xhtmlNode.getNodeType() == NodeType.Text) {
                stringBuilder.append(xhtmlNode.getContent());
                continue;
            }
            if (xhtmlNode.getNodeType() != NodeType.Element) continue;
            stringBuilder.append(xhtmlNode.allText());
        }
        return stringBuilder.toString();
    }

    public XhtmlNode attribute(String string, String string2) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (string == null) {
            throw new Error("name is null");
        }
        if (string2 == null) {
            throw new Error("value is null");
        }
        this.Attributes.put(string, string2);
        return this;
    }

    public String getAttribute(String string) {
        return this.getAttributes().get(string);
    }

    public XhtmlNode setAttribute(String string, String string2) {
        this.getAttributes().put(string, string2);
        return this;
    }

    public XhtmlNode copy() {
        XhtmlNode xhtmlNode = new XhtmlNode(this.nodeType);
        xhtmlNode.name = this.name;
        for (String object : this.Attributes.keySet()) {
            xhtmlNode.Attributes.put(object, this.Attributes.get(object));
        }
        for (XhtmlNode xhtmlNode2 : this.childNodes) {
            xhtmlNode.childNodes.add(xhtmlNode2.copy());
        }
        xhtmlNode.content = this.content;
        return xhtmlNode;
    }
}

