/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.xmlpull.v1.XmlPullParser;

public class XhtmlParser {
    private Set<String> elements = new HashSet<String>();
    private Set<String> attributes = new HashSet<String>();
    private ParserSecurityPolicy policy = ParserSecurityPolicy.Accept;
    private boolean trimWhitespace;
    private boolean mustBeWellFormed = true;
    private Reader rdr;
    private String cache = "";
    private XhtmlNode unwindPoint;
    private String lastText = "";
    private int line = 1;
    private int col = 0;
    private char lastChar;

    public XhtmlParser() {
        this.elements.add("p");
        this.elements.add("br");
        this.elements.add("div");
        this.elements.add("h1");
        this.elements.add("h2");
        this.elements.add("h3");
        this.elements.add("h4");
        this.elements.add("h5");
        this.elements.add("h6");
        this.elements.add("a");
        this.elements.add("span");
        this.elements.add("b");
        this.elements.add("em");
        this.elements.add("i");
        this.elements.add("strong");
        this.elements.add("small");
        this.elements.add("big");
        this.elements.add("tt");
        this.elements.add("small");
        this.elements.add("dfn");
        this.elements.add("q");
        this.elements.add("var");
        this.elements.add("abbr");
        this.elements.add("acronym");
        this.elements.add("cite");
        this.elements.add("blockquote");
        this.elements.add("hr");
        this.elements.add("address");
        this.elements.add("bdo");
        this.elements.add("kbd");
        this.elements.add("q");
        this.elements.add("sub");
        this.elements.add("sup");
        this.elements.add("ul");
        this.elements.add("ol");
        this.elements.add("li");
        this.elements.add("dl");
        this.elements.add("dt");
        this.elements.add("dd");
        this.elements.add("pre");
        this.elements.add("table");
        this.elements.add("caption");
        this.elements.add("colgroup");
        this.elements.add("col");
        this.elements.add("thead");
        this.elements.add("tr");
        this.elements.add("tfoot");
        this.elements.add("tbody");
        this.elements.add("th");
        this.elements.add("td");
        this.elements.add("code");
        this.elements.add("samp");
        this.elements.add("img");
        this.elements.add("map");
        this.elements.add("area");
        this.attributes.add("title");
        this.attributes.add("style");
        this.attributes.add("class");
        this.attributes.add("id");
        this.attributes.add("lang");
        this.attributes.add("xml:lang");
        this.attributes.add("dir");
        this.attributes.add("accesskey");
        this.attributes.add("tabindex");
        this.attributes.add("span");
        this.attributes.add("width");
        this.attributes.add("align");
        this.attributes.add("valign");
        this.attributes.add("char");
        this.attributes.add("charoff");
        this.attributes.add("abbr");
        this.attributes.add("axis");
        this.attributes.add("headers");
        this.attributes.add("scope");
        this.attributes.add("rowspan");
        this.attributes.add("colspan");
        this.attributes.add("a.href");
        this.attributes.add("a.name");
        this.attributes.add("img.src");
        this.attributes.add("img.border");
        this.attributes.add("div.xmlns");
        this.attributes.add("blockquote.cite");
        this.attributes.add("q.cite");
        this.attributes.add("a.charset");
        this.attributes.add("a.type");
        this.attributes.add("a.name");
        this.attributes.add("a.href");
        this.attributes.add("a.hreflang");
        this.attributes.add("a.rel");
        this.attributes.add("a.rev");
        this.attributes.add("a.shape");
        this.attributes.add("a.coords");
        this.attributes.add("img.src");
        this.attributes.add("img.alt");
        this.attributes.add("img.longdesc");
        this.attributes.add("img.height");
        this.attributes.add("img.width");
        this.attributes.add("img.usemap");
        this.attributes.add("img.ismap");
        this.attributes.add("map.name");
        this.attributes.add("area.shape");
        this.attributes.add("area.coords");
        this.attributes.add("area.href");
        this.attributes.add("area.nohref");
        this.attributes.add("area.alt");
        this.attributes.add("table.summary");
        this.attributes.add("table.width");
        this.attributes.add("table.border");
        this.attributes.add("table.frame");
        this.attributes.add("table.rules");
        this.attributes.add("table.cellspacing");
        this.attributes.add("table.cellpadding");
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean bl) {
        this.trimWhitespace = bl;
    }

    public boolean isMustBeWellFormed() {
        return this.mustBeWellFormed;
    }

    public void setMustBeWellFormed(boolean bl) {
        this.mustBeWellFormed = bl;
    }

    public ParserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ParserSecurityPolicy parserSecurityPolicy) {
        this.policy = parserSecurityPolicy;
    }

    public XhtmlNode parseHtmlNode(XmlPullParser xmlPullParser) throws Exception {
        int n;
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element);
        xhtmlNode.setName(xmlPullParser.getName());
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            if (!this.attributeIsOk(xmlPullParser.getName(), xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeValue(n))) continue;
            xhtmlNode.getAttributes().put(xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeValue(n));
        }
        n = xmlPullParser.next();
        while (n != 3) {
            if (n == 4) {
                xhtmlNode.addText(xmlPullParser.getText());
                xmlPullParser.next();
            } else if (n == 9) {
                xhtmlNode.addComment(xmlPullParser.getText());
                xmlPullParser.next();
            } else if (n == 2) {
                if (this.elementIsOk(xmlPullParser.getName())) {
                    xhtmlNode.getChildNodes().add(this.parseHtmlNode(xmlPullParser));
                }
            } else {
                throw new Exception("Unhandled XHTML feature: " + Integer.toString(n) + this.descLoc());
            }
            n = xmlPullParser.getEventType();
        }
        xmlPullParser.next();
        return xhtmlNode;
    }

    private boolean attributeIsOk(String string, String string2, String string3) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.attributes.contains(string2) || this.attributes.contains(string + "." + string2);
        if (bl) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new Exception("Illegal HTML attribute " + string + "." + string2);
            }
        }
        if ((string + "." + string2).equals("img.src") && !string3.startsWith("#") && !string3.startsWith("http:") && !string3.startsWith("https:")) {
            switch (this.policy) {
                case Accept: {
                    return true;
                }
                case Drop: {
                    return false;
                }
                case Reject: {
                    throw new Exception("Illegal Image Reference " + string3);
                }
            }
        }
        return false;
    }

    private boolean elementIsOk(String string) throws Exception {
        boolean bl = this.elements.contains(string);
        if (bl) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new Exception("Illegal HTML element " + string);
            }
        }
        return false;
    }

    private String descLoc() {
        return " at line " + Integer.toString(this.line) + " column " + Integer.toString(this.col);
    }

    public XhtmlDocument parse(String string, String string2) throws Exception {
        this.rdr = new StringReader(string);
        return this.parse(string2);
    }

    public XhtmlDocument parse(InputStream inputStream, String string) throws Exception {
        this.rdr = new InputStreamReader(inputStream, "UTF-8");
        return this.parse(string);
    }

    private XhtmlDocument parse(String string) throws Exception {
        XhtmlDocument xhtmlDocument = new XhtmlDocument();
        this.skipWhiteSpaceAndComments(xhtmlDocument);
        if (this.peekChar() != '<') {
            throw new Exception("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        String string2 = this.readName().toLowerCase();
        if (string != null && !string2.equals(string)) {
            throw new Exception("Unable to Parse HTML - starts with '" + string2 + "' not '" + string + "'" + this.descLoc());
        }
        XhtmlNode xhtmlNode = xhtmlDocument.addTag(string2);
        this.readToTagEnd();
        this.unwindPoint = null;
        ArrayList<XhtmlNode> arrayList = new ArrayList<XhtmlNode>();
        this.parseElementInner(xhtmlNode, arrayList);
        return xhtmlDocument;
    }

    private void addTextNode(XhtmlNode xhtmlNode, StringBuilder stringBuilder) {
        String string;
        String string2 = string = this.isTrimWhitespace() ? stringBuilder.toString().trim() : stringBuilder.toString();
        if (string.length() > 0) {
            this.lastText = string;
            xhtmlNode.addText(string);
            stringBuilder.setLength(0);
        }
    }

    private void parseElementInner(XhtmlNode xhtmlNode, List<XhtmlNode> list) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peekChar() != '\u0000' && !list.contains(this.unwindPoint) && xhtmlNode != this.unwindPoint) {
            if (this.peekChar() == '<') {
                this.addTextNode(xhtmlNode, stringBuilder);
                this.readChar();
                if (this.peekChar() == '!') {
                    xhtmlNode.addComment(this.readToCommentEnd());
                    continue;
                }
                if (this.peekChar() == '?') {
                    xhtmlNode.addComment(this.readToTagEnd());
                    continue;
                }
                if (this.peekChar() == '/') {
                    int n;
                    this.readChar();
                    String string = this.readToTagEnd();
                    if (xhtmlNode.getName().equals(string)) {
                        return;
                    }
                    if (this.mustBeWellFormed) {
                        throw new Exception("Malformed XHTML: Found \"</" + string + ">\" expecting \"</" + xhtmlNode.getName() + ">\"" + this.descLoc());
                    }
                    for (n = list.size() - 1; n >= 0; --n) {
                        if (!list.get(n).getName().equals(string)) continue;
                        this.unwindPoint = list.get(n);
                    }
                    if (this.unwindPoint == null) continue;
                    for (n = list.size(); n > 0; --n) {
                        if (n < list.size() && list.get(n) == this.unwindPoint) {
                            return;
                        }
                        if (n == list.size()) {
                            list.get(n - 1).getChildNodes().addAll(xhtmlNode.getChildNodes());
                            xhtmlNode.getChildNodes().clear();
                            continue;
                        }
                        list.get(n - 1).getChildNodes().addAll(list.get(n).getChildNodes());
                        list.get(n).getChildNodes().clear();
                    }
                    continue;
                }
                if (Character.isLetterOrDigit(this.peekChar())) {
                    this.parseElement(xhtmlNode, list);
                    continue;
                }
                throw new Exception("Unable to Parse HTML - node '" + xhtmlNode.getName() + "' has unexpected content '" + this.peekChar() + "' (last text = '" + this.lastText + "'" + this.descLoc());
            }
            if (this.peekChar() == '&') {
                this.parseLiteral(stringBuilder);
                continue;
            }
            stringBuilder.append(this.readChar());
        }
        this.addTextNode(xhtmlNode, stringBuilder);
    }

    private void parseElement(XhtmlNode xhtmlNode, List<XhtmlNode> list) throws Exception {
        String string = this.readName();
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag(string);
        ArrayList<XhtmlNode> arrayList = new ArrayList<XhtmlNode>();
        arrayList.addAll(list);
        arrayList.add(xhtmlNode);
        this.parseAttributes(xhtmlNode2);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new Exception("unexpected non-end of element" + this.descLoc());
            }
            this.readChar();
        } else {
            this.parseElementInner(xhtmlNode2, arrayList);
        }
    }

    private void parseAttributes(XhtmlNode xhtmlNode) throws Exception {
        while (Character.isWhitespace(this.peekChar())) {
            this.readChar();
        }
        while (this.peekChar() != '>' && this.peekChar() != '/' && this.peekChar() != '\u0000') {
            String string = this.readName();
            if (string.length() == 0) {
                throw new Exception("Unable to read attribute on <" + xhtmlNode.getName() + ">" + this.descLoc());
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
            if (this.isNameChar(this.peekChar()) || this.peekChar() == '>' || this.peekChar() == '/') {
                xhtmlNode.getAttributes().put(string, null);
            } else {
                if (this.peekChar() != '=') {
                    throw new Exception("Unable to read attribute '" + string + "' value on <" + xhtmlNode.getName() + ">" + this.descLoc());
                }
                this.readChar();
                while (Character.isWhitespace(this.peekChar())) {
                    this.readChar();
                }
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    xhtmlNode.getAttributes().put(string, this.parseAttributeValue(this.readChar()));
                } else {
                    xhtmlNode.getAttributes().put(string, this.parseAttributeValue('\u0000'));
                }
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }
    }

    private String parseAttributeValue(char c) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peekChar() != '\u0000' && this.peekChar() != '>' && (c != '\u0000' || this.peekChar() != '/') && this.peekChar() != c) {
            if (this.peekChar() == '&') {
                this.parseLiteral(stringBuilder);
                continue;
            }
            stringBuilder.append(this.readChar());
        }
        if (this.peekChar() == c) {
            this.readChar();
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipWhiteSpaceAndComments(XhtmlNode xhtmlNode) throws Exception {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
        if (this.peekChar() != '<') return;
        char c = this.readChar();
        if (this.peekChar() == '!') {
            this.readChar();
            if (this.peekChar() == '-') {
                this.readChar();
                if (this.peekChar() != '-') throw new Exception("unrecognised element type <!" + this.peekChar() + this.descLoc());
                this.readChar();
                if (this.peekChar() == ' ') {
                    this.readChar();
                }
                xhtmlNode.addComment(this.readToCommentEnd());
            } else {
                xhtmlNode.addDocType(this.readToCommentEnd());
            }
            this.skipWhiteSpaceAndComments(xhtmlNode);
            return;
        } else if (this.peekChar() == '?') {
            String string = this.readToTagEnd();
            xhtmlNode.addInstruction(string.substring(1, string.length() - 1));
            this.skipWhiteSpaceAndComments(xhtmlNode);
            return;
        } else {
            this.pushChar(c);
        }
    }

    private void skipWhiteSpace() throws IOException {
        if (this.trimWhitespace) {
            while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
                this.readChar();
            }
        }
    }

    private void pushChar(char c) {
        this.cache = Character.toString(c) + this.cache;
    }

    private char peekChar() throws IOException {
        if (this.cache.length() > 0) {
            return this.cache.charAt(0);
        }
        if (!this.rdr.ready()) {
            return '\u0000';
        }
        char c = (char)this.rdr.read();
        if (c == '\uffff') {
            this.cache = "";
            return '\u0000';
        }
        this.cache = Character.toString(c);
        return c;
    }

    private char readChar() throws IOException {
        char c;
        if (this.cache.length() > 0) {
            c = this.cache.charAt(0);
            this.cache = this.cache.length() == 1 ? "" : this.cache.substring(1);
        } else {
            c = !this.rdr.ready() ? (char)'\u0000' : (char)this.rdr.read();
        }
        if (c == '\r' || c == '\n') {
            if (c == '\r' || this.lastChar != '\r') {
                ++this.line;
                this.col = 0;
            }
            this.lastChar = c;
        }
        ++this.col;
        return c;
    }

    private String readToTagEnd() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peekChar() != '>' && this.peekChar() != '\u0000') {
            stringBuilder.append(this.readChar());
        }
        if (this.peekChar() != '\u0000') {
            this.readChar();
            this.skipWhiteSpace();
        } else if (this.mustBeWellFormed) {
            throw new Exception("Unexpected termination of html source" + this.descLoc());
        }
        return stringBuilder.toString();
    }

    private String readToCommentEnd() throws Exception {
        if (this.peekChar() == '!') {
            this.readChar();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this.peekChar() == '-') {
            this.readChar();
            boolean bl2 = bl = this.peekChar() != '-';
            if (bl) {
                stringBuilder.append('-');
            } else {
                this.readChar();
            }
        }
        boolean bl3 = false;
        while (!bl3) {
            char c = this.peekChar();
            if (c == '-') {
                this.readChar();
                if (this.peekChar() == '-') {
                    this.readChar();
                    if (this.peekChar() == '>') {
                        bl3 = true;
                        continue;
                    }
                    stringBuilder.append("--");
                    continue;
                }
                stringBuilder.append('-');
                continue;
            }
            if (bl && this.peekChar() == '>') {
                bl3 = true;
                continue;
            }
            if (c != '\u0000') {
                stringBuilder.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new Exception("Unexpected termination of html source" + this.descLoc());
        }
        if (this.peekChar() != '\u0000') {
            this.readChar();
            this.skipWhiteSpace();
        }
        return stringBuilder.toString();
    }

    private boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == ':';
    }

    private String readName() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.isNameChar(this.peekChar())) {
            stringBuilder.append(this.readChar());
        }
        return stringBuilder.toString();
    }

    private String readUntil(char c) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peekChar() != '\u0000' && this.peekChar() != c) {
            stringBuilder.append(this.readChar());
        }
        this.readChar();
        return stringBuilder.toString();
    }

    private void parseLiteral(StringBuilder stringBuilder) throws Exception {
        this.readChar();
        String string = this.readUntil(';');
        if (string.equals("apos")) {
            stringBuilder.append('\'');
        } else if (string.equals("quot")) {
            stringBuilder.append('\"');
        } else if (string.equals("nbsp")) {
            stringBuilder.append(XhtmlNode.NBSP);
        } else if (string.equals("amp")) {
            stringBuilder.append('&');
        } else if (string.equals("gt")) {
            stringBuilder.append('>');
        } else if (string.equals("lt")) {
            stringBuilder.append('<');
        } else if (string.equals("copy")) {
            stringBuilder.append('\u00a9');
        } else if (string.equals("reg")) {
            stringBuilder.append('\u00ae');
        } else if (string.equals("sect")) {
            stringBuilder.append('\u00a7');
        } else if (string.charAt(0) == '#') {
            if (this.isInteger(string.substring(1), 10)) {
                stringBuilder.append((char)Integer.parseInt(string.substring(1)));
            } else if (this.isInteger(string.substring(1), 16)) {
                stringBuilder.append((char)Integer.parseInt(string.substring(1), 16));
            }
        } else if (string.equals("fnof")) {
            stringBuilder.append('\u0192');
        } else if (string.equals("Alpha")) {
            stringBuilder.append('\u0391');
        } else if (string.equals("Beta")) {
            stringBuilder.append('\u0392');
        } else if (string.equals("Gamma")) {
            stringBuilder.append('\u0393');
        } else if (string.equals("Delta")) {
            stringBuilder.append('\u0394');
        } else if (string.equals("Epsilon")) {
            stringBuilder.append('\u0395');
        } else if (string.equals("Zeta")) {
            stringBuilder.append('\u0396');
        } else if (string.equals("Eta")) {
            stringBuilder.append('\u0397');
        } else if (string.equals("Theta")) {
            stringBuilder.append('\u0398');
        } else if (string.equals("Iota")) {
            stringBuilder.append('\u0399');
        } else if (string.equals("Kappa")) {
            stringBuilder.append('\u039a');
        } else if (string.equals("Lambda")) {
            stringBuilder.append('\u039b');
        } else if (string.equals("Mu")) {
            stringBuilder.append('\u039c');
        } else if (string.equals("Nu")) {
            stringBuilder.append('\u039d');
        } else if (string.equals("Xi")) {
            stringBuilder.append('\u039e');
        } else if (string.equals("Omicron")) {
            stringBuilder.append('\u039f');
        } else if (string.equals("Pi")) {
            stringBuilder.append('\u03a0');
        } else if (string.equals("Rho")) {
            stringBuilder.append('\u03a1');
        } else if (string.equals("Sigma")) {
            stringBuilder.append('\u03a3');
        } else if (string.equals("Tau")) {
            stringBuilder.append('\u03a4');
        } else if (string.equals("Upsilon")) {
            stringBuilder.append('\u03a5');
        } else if (string.equals("Phi")) {
            stringBuilder.append('\u03a6');
        } else if (string.equals("Chi")) {
            stringBuilder.append('\u03a7');
        } else if (string.equals("Psi")) {
            stringBuilder.append('\u03a8');
        } else if (string.equals("Omega")) {
            stringBuilder.append('\u03a9');
        } else if (string.equals("alpha")) {
            stringBuilder.append('\u03b1');
        } else if (string.equals("beta")) {
            stringBuilder.append('\u03b2');
        } else if (string.equals("gamma")) {
            stringBuilder.append('\u03b3');
        } else if (string.equals("delta")) {
            stringBuilder.append('\u03b4');
        } else if (string.equals("epsilon")) {
            stringBuilder.append('\u03b5');
        } else if (string.equals("zeta")) {
            stringBuilder.append('\u03b6');
        } else if (string.equals("eta")) {
            stringBuilder.append('\u03b7');
        } else if (string.equals("theta")) {
            stringBuilder.append('\u03b8');
        } else if (string.equals("iota")) {
            stringBuilder.append('\u03b9');
        } else if (string.equals("kappa")) {
            stringBuilder.append('\u03ba');
        } else if (string.equals("lambda")) {
            stringBuilder.append('\u03bb');
        } else if (string.equals("mu")) {
            stringBuilder.append('\u03bc');
        } else if (string.equals("nu")) {
            stringBuilder.append('\u03bd');
        } else if (string.equals("xi")) {
            stringBuilder.append('\u03be');
        } else if (string.equals("omicron")) {
            stringBuilder.append('\u03bf');
        } else if (string.equals("pi")) {
            stringBuilder.append('\u03c0');
        } else if (string.equals("rho")) {
            stringBuilder.append('\u03c1');
        } else if (string.equals("sigmaf")) {
            stringBuilder.append('\u03c2');
        } else if (string.equals("sigma")) {
            stringBuilder.append('\u03c3');
        } else if (string.equals("tau")) {
            stringBuilder.append('\u03c4');
        } else if (string.equals("upsilon")) {
            stringBuilder.append('\u03c5');
        } else if (string.equals("phi")) {
            stringBuilder.append('\u03c6');
        } else if (string.equals("chi")) {
            stringBuilder.append('\u03c7');
        } else if (string.equals("psi")) {
            stringBuilder.append('\u03c8');
        } else if (string.equals("omega")) {
            stringBuilder.append('\u03c9');
        } else if (string.equals("thetasym")) {
            stringBuilder.append('\u03d1');
        } else if (string.equals("upsih")) {
            stringBuilder.append('\u03d2');
        } else if (string.equals("piv")) {
            stringBuilder.append('\u03d6');
        } else if (string.equals("bull")) {
            stringBuilder.append('\u2022');
        } else if (string.equals("hellip")) {
            stringBuilder.append('\u2026');
        } else if (string.equals("prime")) {
            stringBuilder.append('\u2032');
        } else if (string.equals("Prime")) {
            stringBuilder.append('\u2033');
        } else if (string.equals("oline")) {
            stringBuilder.append('\u203e');
        } else if (string.equals("frasl")) {
            stringBuilder.append('\u2044');
        } else if (string.equals("weierp")) {
            stringBuilder.append('\u2118');
        } else if (string.equals("image")) {
            stringBuilder.append('\u2111');
        } else if (string.equals("real")) {
            stringBuilder.append('\u211c');
        } else if (string.equals("trade")) {
            stringBuilder.append('\u2122');
        } else if (string.equals("alefsym")) {
            stringBuilder.append('\u2135');
        } else if (string.equals("larr")) {
            stringBuilder.append('\u2190');
        } else if (string.equals("uarr")) {
            stringBuilder.append('\u2191');
        } else if (string.equals("rarr")) {
            stringBuilder.append('\u2192');
        } else if (string.equals("darr")) {
            stringBuilder.append('\u2193');
        } else if (string.equals("harr")) {
            stringBuilder.append('\u2194');
        } else if (string.equals("crarr")) {
            stringBuilder.append('\u21b5');
        } else if (string.equals("lArr")) {
            stringBuilder.append('\u21d0');
        } else if (string.equals("uArr")) {
            stringBuilder.append('\u21d1');
        } else if (string.equals("rArr")) {
            stringBuilder.append('\u21d2');
        } else if (string.equals("dArr")) {
            stringBuilder.append('\u21d3');
        } else if (string.equals("hArr")) {
            stringBuilder.append('\u21d4');
        } else if (string.equals("forall")) {
            stringBuilder.append('\u2200');
        } else if (string.equals("part")) {
            stringBuilder.append('\u2202');
        } else if (string.equals("exist")) {
            stringBuilder.append('\u2203');
        } else if (string.equals("empty")) {
            stringBuilder.append('\u2205');
        } else if (string.equals("nabla")) {
            stringBuilder.append('\u2207');
        } else if (string.equals("isin")) {
            stringBuilder.append('\u2208');
        } else if (string.equals("notin")) {
            stringBuilder.append('\u2209');
        } else if (string.equals("ni")) {
            stringBuilder.append('\u220b');
        } else if (string.equals("prod")) {
            stringBuilder.append('\u220f');
        } else if (string.equals("sum")) {
            stringBuilder.append('\u2211');
        } else if (string.equals("minus")) {
            stringBuilder.append('\u2212');
        } else if (string.equals("lowast")) {
            stringBuilder.append('\u2217');
        } else if (string.equals("radic")) {
            stringBuilder.append('\u221a');
        } else if (string.equals("prop")) {
            stringBuilder.append('\u221d');
        } else if (string.equals("infin")) {
            stringBuilder.append('\u221e');
        } else if (string.equals("ang")) {
            stringBuilder.append('\u2220');
        } else if (string.equals("and")) {
            stringBuilder.append('\u2227');
        } else if (string.equals("or")) {
            stringBuilder.append('\u2228');
        } else if (string.equals("cap")) {
            stringBuilder.append('\u2229');
        } else if (string.equals("cup")) {
            stringBuilder.append('\u222a');
        } else if (string.equals("int")) {
            stringBuilder.append('\u222b');
        } else if (string.equals("there4")) {
            stringBuilder.append('\u2234');
        } else if (string.equals("sim")) {
            stringBuilder.append('\u223c');
        } else if (string.equals("cong")) {
            stringBuilder.append('\u2245');
        } else if (string.equals("asymp")) {
            stringBuilder.append('\u2248');
        } else if (string.equals("ne")) {
            stringBuilder.append('\u2260');
        } else if (string.equals("equiv")) {
            stringBuilder.append('\u2261');
        } else if (string.equals("le")) {
            stringBuilder.append('\u2264');
        } else if (string.equals("ge")) {
            stringBuilder.append('\u2265');
        } else if (string.equals("sub")) {
            stringBuilder.append('\u2282');
        } else if (string.equals("sup")) {
            stringBuilder.append('\u2283');
        } else if (string.equals("nsub")) {
            stringBuilder.append('\u2284');
        } else if (string.equals("sube")) {
            stringBuilder.append('\u2286');
        } else if (string.equals("supe")) {
            stringBuilder.append('\u2287');
        } else if (string.equals("oplus")) {
            stringBuilder.append('\u2295');
        } else if (string.equals("otimes")) {
            stringBuilder.append('\u2297');
        } else if (string.equals("perp")) {
            stringBuilder.append('\u22a5');
        } else if (string.equals("sdot")) {
            stringBuilder.append('\u22c5');
        } else if (string.equals("lceil")) {
            stringBuilder.append('\u2308');
        } else if (string.equals("rceil")) {
            stringBuilder.append('\u2309');
        } else if (string.equals("lfloor")) {
            stringBuilder.append('\u230a');
        } else if (string.equals("rfloor")) {
            stringBuilder.append('\u230b');
        } else if (string.equals("lang")) {
            stringBuilder.append('\u2329');
        } else if (string.equals("rang")) {
            stringBuilder.append('\u232a');
        } else if (string.equals("loz")) {
            stringBuilder.append('\u25ca');
        } else if (string.equals("spades")) {
            stringBuilder.append('\u2660');
        } else if (string.equals("clubs")) {
            stringBuilder.append('\u2663');
        } else if (string.equals("hearts")) {
            stringBuilder.append('\u2665');
        } else if (string.equals("diams")) {
            stringBuilder.append('\u2666');
        } else {
            throw new Exception("unable to parse character reference '" + string + "'' (last text = '" + this.lastText + "'" + this.descLoc());
        }
    }

    private boolean isInteger(String string, int n) {
        try {
            Integer.parseInt(string, n);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public XhtmlNode parseFragment(String string) throws Exception {
        this.rdr = new StringReader(string);
        return this.parseFragment();
    }

    public XhtmlNode parseFragment(InputStream inputStream) throws Exception {
        this.rdr = new InputStreamReader(inputStream);
        return this.parseFragment();
    }

    private XhtmlNode parseFragment() throws Exception {
        this.skipWhiteSpace();
        if (this.peekChar() != '<') {
            throw new Exception("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        String string = this.readName().toLowerCase();
        this.readToTagEnd();
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element);
        xhtmlNode.setName(string);
        this.unwindPoint = null;
        ArrayList<XhtmlNode> arrayList = new ArrayList<XhtmlNode>();
        this.parseElementInner(xhtmlNode, arrayList);
        return xhtmlNode;
    }

    public static enum ParserSecurityPolicy {
        Accept,
        Drop,
        Reject;

    }
}

