/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public final class NamespaceContextMap
implements NamespaceContext {
    private final Map<String, String> prefixMap;
    private final Map<String, Set<String>> nsMap;

    public NamespaceContextMap(Map<String, String> map) {
        this.prefixMap = this.createPrefixMap(map);
        this.nsMap = this.createNamespaceMap(this.prefixMap);
    }

    public NamespaceContextMap(String ... stringArray) {
        this(NamespaceContextMap.toMap(stringArray));
    }

    private static Map<String, String> toMap(String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length / 2);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray[++i]);
        }
        return hashMap;
    }

    private Map<String, String> createPrefixMap(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        this.addConstant(hashMap, "xml", "http://www.w3.org/XML/1998/namespace");
        this.addConstant(hashMap, "xmlns", "http://www.w3.org/2000/xmlns/");
        return Collections.unmodifiableMap(hashMap);
    }

    private void addConstant(Map<String, String> map, String string, String string2) {
        String string3 = map.put(string, string2);
        if (string3 != null && !string3.equals(string2)) {
            throw new IllegalArgumentException(string + " -> " + string3 + "; see NamespaceContext contract");
        }
    }

    private Map<String, Set<String>> createNamespaceMap(Map<String, String> map) {
        Object object;
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            object = entry.getValue();
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put((String)object, hashSet);
            }
            hashSet.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            object = Collections.unmodifiableSet((Set)((Object)entry.getValue()));
            entry.setValue((String)object);
        }
        return hashMap;
    }

    @Override
    public String getNamespaceURI(String string) {
        this.checkNotNull(string);
        String string2 = this.prefixMap.get(string);
        return string2 == null ? "" : string2;
    }

    @Override
    public String getPrefix(String string) {
        this.checkNotNull(string);
        Set<String> set = this.nsMap.get(string);
        return set == null ? null : set.iterator().next();
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        this.checkNotNull(string);
        Set<String> set = this.nsMap.get(string);
        return set.iterator();
    }

    private void checkNotNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
    }

    public Map<String, String> getMap() {
        return this.prefixMap;
    }
}

