/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLNamespace;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XMLWriterState;
import org.hl7.fhir.utilities.xml.XMLWriterStateStack;

public class XMLWriter
extends OutputStreamWriter
implements IXMLWriter {
    private boolean xmlHeader = true;
    private String charset;
    private boolean prettyBase;
    private boolean prettyHeader;
    private boolean pendingClose;
    private boolean pendingOpen;
    private String pendingComment;
    private int lineType = 0;
    private OutputStream stream;
    private boolean started = false;
    private String[] specialAttributeNames = new String[]{"id", "name"};
    private boolean sortAttributes;
    private int attributeLineWrap;
    public static final int LINE_UNIX = 0;
    public static final int LINE_WINDOWS = 1;
    private String[][] attributes;
    private XMLWriterStateStack levels = new XMLWriterStateStack();

    public XMLWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.stream = outputStream;
        this.charset = string;
    }

    protected boolean condition(boolean bl, String string) throws IOException {
        if (!bl) {
            throw new IOException(string);
        }
        return bl;
    }

    public static String getXMLCharsetName(String string) throws IOException {
        if (string == null || string.equals("")) {
            return "UTF-8";
        }
        if (string.equals("US-ASCII")) {
            return "UTF-8";
        }
        if (XMLUtil.charSetImpliesAscii(string)) {
            return "ISO-8859-1";
        }
        if (string.equals("UTF-8")) {
            return "UTF-8";
        }
        if (string.equals("UTF-16") || string.equals("UTF-16BE") || string.equals("UTF-16LE")) {
            return "UTF-16";
        }
        throw new IOException("Unknown charset encoding " + string);
    }

    @Override
    public void start() throws IOException {
        this.condition(!this.started, "attempt to start after starting");
        this.levels.clear();
        this.attributes = null;
        try {
            if (this.xmlHeader) {
                this.write("<?xml version=\"1.0\" encoding=\"" + XMLWriter.getXMLCharsetName(this.charset) + "\"?>");
                if (this.prettyBase || this.prettyHeader) {
                    this.write(this.lineType == 0 ? "\n" : "\r\n");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(unsupportedEncodingException.getMessage());
        }
        this.started = true;
    }

    private void checkStarted() throws IOException {
        this.condition(this.started, "not started");
    }

    private void checkInElement() throws IOException {
        this.condition(this.levels.size() > 0, "not in an element");
    }

    private void addAttribute(String string, String string2) throws IOException {
        this.addAttribute(string, string2, false);
    }

    private void addAttribute(String string, String string2, boolean bl) throws IOException {
        if (!XMLUtil.isNMToken(string)) {
            throw new IOException("XML name " + string + " is not valid for value '" + string2 + "'");
        }
        this.newLevelIfRequired();
        string2 = XMLUtil.escapeXML(string2, this.charset, bl);
        if (this.attributes == null) {
            this.attributes = new String[][]{{string, string2}};
        } else {
            String[][] stringArrayArray = new String[this.attributes.length + 1][];
            for (int i = 0; i < this.attributes.length; ++i) {
                this.condition(!this.attributes[i][0].equals(string), "attempt to define attribute with name " + string + " more than once for value '" + string2 + "'");
                stringArrayArray[i] = this.attributes[i];
            }
            this.attributes = stringArrayArray;
            this.attributes[this.attributes.length - 1] = new String[]{string, string2};
        }
    }

    protected String getAttribute(String string) {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!this.attributes[i][0].equals(string)) continue;
                return this.attributes[i][1];
            }
        }
        return null;
    }

    protected void setAttribute(String string, String string2) throws IOException {
        this.newLevelIfRequired();
        if (this.attributes == null) {
            this.addAttribute(string, string2, false);
        } else {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!this.attributes[i][0].equals(string)) continue;
                this.attributes[i][1] = XMLUtil.escapeXML(string2, this.charset, false);
                return;
            }
            this.addAttribute(string, string2);
        }
    }

    protected void commitAttributes() throws IOException {
    }

    private boolean nameIsSpecial(String string) {
        for (int i = 0; i < this.specialAttributeNames.length; ++i) {
            String string2 = this.specialAttributeNames[i];
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void writeAttributes(int n) throws IOException {
        this.commitAttributes();
        if (this.attributes != null && this.sortAttributes) {
            this.sortAttributes();
        }
        int n2 = n;
        n2 = this.writeAttributeSet(true, n2, n);
        this.writeAttributeSet(false, n2, n);
        this.attributes = null;
    }

    private void sortAttributes() {
        for (int i = 0; i < this.attributes.length - 1; ++i) {
            for (int j = 0; j < this.attributes.length - 1; ++j) {
                if (String.CASE_INSENSITIVE_ORDER.compare(this.attributes[j][0], this.attributes[j + 1][0]) >= 0) continue;
                String[] stringArray = this.attributes[j];
                this.attributes[j] = this.attributes[j + 1];
                this.attributes[j + 1] = stringArray;
            }
        }
    }

    private int writeAttributeSet(boolean bl, int n, int n2) throws IOException {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                String[] stringArray = this.attributes[i];
                if (this.nameIsSpecial(stringArray[0]) != bl) continue;
                n = n + stringArray[0].length() + stringArray[1].length() + 4;
                if (this.isPretty() && this.attributeLineWrap > 0 && n > this.attributeLineWrap && n > n2) {
                    this.write(this.lineType == 0 ? "\n" : "\r\n");
                    for (int j = 0; j < n2; ++j) {
                        this.write(" ");
                    }
                    n = n2;
                }
                this.write(32);
                this.write(stringArray[0]);
                this.write("=\"");
                if (stringArray[1] != null) {
                    this.write(stringArray[1]);
                }
                this.write("\"");
            }
        }
        return n;
    }

    @Override
    public void attribute(String string, String string2, String string3, boolean bl) throws IOException {
        if (!bl || string3 != null && !string3.equals("")) {
            this.attribute(string, string2, string3);
        }
    }

    @Override
    public void attribute(String string, String string2, String string3) throws IOException {
        this.checkStarted();
        if (string == null || string.equals("")) {
            this.addAttribute(string2, string3);
        } else {
            this.addAttribute(this.getNSAbbreviation(string) + string2, string3);
        }
    }

    @Override
    public void attribute(String string, String string2, boolean bl) throws IOException {
        if (!bl || string2 != null && !string2.equals("")) {
            this.attribute(string, string2);
        }
    }

    @Override
    public void attribute(String string, String string2) throws IOException {
        this.checkStarted();
        this.addAttribute(string, string2);
    }

    @Override
    public void attributeNoLines(String string, String string2) throws IOException {
        this.checkStarted();
        this.addAttribute(string, string2, true);
    }

    private void newLevelIfRequired() throws IOException {
        if (!this.pendingOpen) {
            if (!this.levels.empty()) {
                this.levels.current().seeChild();
            }
            XMLWriterState xMLWriterState = new XMLWriterState();
            xMLWriterState.setPretty(this.isPretty());
            this.levels.push(xMLWriterState);
            this.pendingOpen = true;
        }
    }

    private void defineNamespace(String string, String string2) throws IOException {
        this.checkStarted();
        if (string != null && !string.equals("")) {
            if ("".equals(string2)) {
                string2 = null;
            }
            this.newLevelIfRequired();
            this.levels.current().addNamespaceDefn(string, string2);
            if (string2 == null) {
                this.addAttribute("xmlns", string);
            } else {
                this.addAttribute("xmlns:" + string2, string);
            }
        }
    }

    public XMLNamespace findByNamespace(String string) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            XMLNamespace xMLNamespace = this.levels.item(i).getDefnByNamespace(string);
            if (xMLNamespace == null) continue;
            return xMLNamespace;
        }
        return null;
    }

    @Override
    public boolean namespaceDefined(String string) {
        return string == null || string.equals("") || this.findByNamespace(string) != null;
    }

    public XMLNamespace findByAbbreviation(String string) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            XMLNamespace xMLNamespace = this.levels.item(i).getDefnByAbbreviation(string);
            if (xMLNamespace == null) continue;
            return xMLNamespace;
        }
        return null;
    }

    @Override
    public boolean abbreviationDefined(String string) {
        return this.findByAbbreviation(string) != null;
    }

    protected XMLNamespace findDefaultNamespace() {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            XMLNamespace xMLNamespace = this.levels.item(i).getDefaultNamespace();
            if (xMLNamespace == null) continue;
            return xMLNamespace;
        }
        return null;
    }

    @Override
    public String getDefaultNamespace() {
        XMLNamespace xMLNamespace = this.findDefaultNamespace();
        if (xMLNamespace == null) {
            return null;
        }
        return xMLNamespace.getNamespace();
    }

    @Override
    public void namespace(String string) throws IOException {
        if (!this.namespaceDefined(string)) {
            int n = 0;
            while (this.abbreviationDefined("ns" + Integer.toString(n))) {
                ++n;
            }
            this.defineNamespace(string, "ns" + Integer.toString(n));
        }
    }

    @Override
    public void setDefaultNamespace(String string) throws IOException {
        if (string == null && this.getDefaultNamespace() != null || string != null && !string.equals(this.getDefaultNamespace())) {
            this.defineNamespace(string, "");
        }
    }

    @Override
    public void namespace(String string, String string2) throws IOException {
        XMLNamespace xMLNamespace = this.findByAbbreviation(string2);
        if (xMLNamespace == null || !xMLNamespace.getNamespace().equals(string)) {
            this.defineNamespace(string, string2);
        }
    }

    private String getNSAbbreviation(String string) throws IOException {
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml:";
        }
        if (string == null || "".equals(string)) {
            return "";
        }
        XMLNamespace xMLNamespace = this.findByNamespace(string);
        if (xMLNamespace == null) {
            throw new IOException("Namespace " + string + " is not defined");
        }
        if (xMLNamespace.getAbbreviation() == null) {
            return "";
        }
        return xMLNamespace.getAbbreviation() + ":";
    }

    @Override
    public void comment(String string, boolean bl) throws IOException {
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        if (bl) {
            this.writePretty();
            if (this.isPretty()) {
                for (int i = 0; i < this.levels.size(); ++i) {
                    this.write("  ");
                }
            }
        }
        if (this.levels.inComment()) {
            this.write("<!-- " + string + " -- >");
        } else {
            this.write("<!-- " + string + " -->");
        }
        if (bl && !this.isPretty()) {
            this.writePretty();
        }
    }

    private void writePendingComment() throws IOException {
        if (this.pendingComment != null) {
            if (this.isPretty()) {
                this.write("   ");
            }
            if (this.levels.inComment()) {
                this.write("<!-- " + this.pendingComment + " -- >");
            } else {
                this.write("<!-- " + this.pendingComment + " -->");
            }
        }
    }

    @Override
    public void open(String string, String string2) throws IOException {
        this.open(string, string2, null);
    }

    @Override
    public void open(String string, String string2, String string3) throws IOException {
        if (!XMLUtil.isNMToken(string2)) {
            throw new IOException("XML name " + string2 + " is not valid");
        }
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        if (string2 == null) {
            throw new IOException("name is null");
        }
        this.newLevelIfRequired();
        this.levels.current().setName(string2);
        this.levels.current().setNamespace(string);
        int n = this.writePretty();
        this.write(60);
        if (string == null) {
            this.write(string2);
            n = n + string2.length() + 1;
        } else {
            String string4 = this.getNSAbbreviation(string) + string2;
            this.write(string4);
            n = n + string4.length() + 1;
        }
        this.writeAttributes(n);
        this.pendingOpen = false;
        this.pendingClose = true;
        this.pendingComment = string3;
    }

    @Override
    public void close(String string) throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close null|" + string + ", nothing to close");
        }
        if (this.levels.current().getNamespace() != null || !this.levels.current().getName().equals(string)) {
            throw new IOException("Unable to close null|" + string + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    @Override
    public void close(String string, String string2) throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close " + string + "|" + string2 + ", nothing to close");
        }
        if (!this.levels.current().getNamespace().equals(string) || !this.levels.current().getName().equals(string2)) {
            throw new IOException("Unable to close " + string + "|" + string2 + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    @Override
    public void closeToLevel(int n) throws IOException {
        while (this.levels.size() > n) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            super.close();
        } else {
            if (this.pendingClose) {
                this.write("/>");
                this.writePendingComment();
                this.pendingClose = false;
            } else {
                if (this.levels.current().hasChildren()) {
                    this.writePretty();
                }
                this.write("</");
                if (this.levels.current().getNamespace() == null) {
                    this.write(this.levels.current().getName());
                } else {
                    this.write(this.getNSAbbreviation(this.levels.current().getNamespace()) + this.levels.current().getName());
                }
                this.write(62);
            }
            this.levels.pop();
        }
    }

    @Override
    public void open(String string) throws IOException {
        this.open(null, string);
    }

    @Override
    public void element(String string, String string2, String string3, boolean bl) throws IOException {
        if (!bl || string3 != null && !string3.equals("")) {
            this.element(string, string2, string3);
        }
    }

    @Override
    public void element(String string, String string2, String string3, String string4) throws IOException {
        if (!XMLUtil.isNMToken(string2)) {
            throw new IOException("XML name " + string2 + " is not valid");
        }
        this.open(string, string2, string4);
        this.text(string3);
        this.close();
    }

    @Override
    public void element(String string, String string2, String string3) throws IOException {
        if (!XMLUtil.isNMToken(string2)) {
            throw new IOException("XML name " + string2 + " is not valid");
        }
        this.open(string, string2);
        this.text(string3);
        this.close();
    }

    @Override
    public void element(String string, String string2, boolean bl) throws IOException {
        if (!bl || string2 != null && !string2.equals("")) {
            this.element(null, string, string2);
        }
    }

    @Override
    public void element(String string, String string2) throws IOException {
        this.element(null, string, string2);
    }

    @Override
    public void text(String string) throws IOException {
        this.text(string, false);
    }

    @Override
    public void text(String string, boolean bl) throws IOException {
        this.checkInElement();
        if (string != null) {
            if (this.pendingClose) {
                this.write(">");
                this.writePendingComment();
                this.pendingClose = false;
            }
            if (bl) {
                this.write(string);
            } else {
                this.write(XMLUtil.escapeXML(string, this.charset, false));
            }
        }
    }

    @Override
    public void cData(String string) throws IOException {
        this.text("<![CDATA[" + string + "]]>");
    }

    @Override
    public void writeBytes(byte[] byArray) throws IOException {
        this.checkInElement();
        if (this.pendingClose) {
            this.write(">");
            this.writePendingComment();
            this.pendingClose = false;
        }
        this.flush();
        this.stream.write(byArray);
    }

    @Override
    public boolean isPretty() throws IOException {
        return this.levels == null || this.levels.empty() ? this.prettyBase : this.levels.current().isPretty();
    }

    @Override
    public void setPretty(boolean bl) throws IOException {
        if (this.levels == null || this.levels.empty()) {
            this.prettyBase = bl;
        } else {
            this.levels.current().setPretty(bl);
        }
    }

    @Override
    public void startCommentBlock() throws IOException {
        if (this.levels.inComment()) {
            throw new IOException("cannot nest comments");
        }
        this.levels.current().setInComment(true);
        if (this.isPretty()) {
            this.writePretty();
        }
        this.write("<!--");
        if (this.isPretty()) {
            this.writePretty();
        }
    }

    @Override
    public void endCommentBlock() throws IOException {
        if (!this.levels.inComment()) {
            throw new IOException("cannot close a comment block when it is open");
        }
        if (!this.levels.current().isInComment()) {
            throw new IOException("cannot close a comment block when it is open");
        }
        if (this.isPretty()) {
            this.writePretty();
        }
        this.write("-->");
        if (this.isPretty()) {
            this.writePretty();
        }
        this.levels.current().setInComment(false);
    }

    public boolean isSortAttributes() {
        return this.sortAttributes;
    }

    public void setSortAttributes(boolean bl) {
        this.sortAttributes = bl;
    }

    public boolean isPrettyHeader() {
        return this.prettyHeader;
    }

    public void setPrettyHeader(boolean bl) {
        this.prettyHeader = bl;
    }

    public int writePretty() throws IOException {
        return this.writePretty(true);
    }

    public int writePretty(boolean bl) throws IOException {
        if (this.isPretty()) {
            if (bl) {
                this.write(this.lineType == 0 ? "\n" : "\r\n");
            }
            for (int i = 0; i < this.levels.size() - 1; ++i) {
                this.write("  ");
            }
            return (this.levels.size() - 1) * 2;
        }
        return 0;
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int n) {
        this.lineType = n;
    }

    public boolean isXmlHeader() {
        return this.xmlHeader;
    }

    public void setXmlHeader(boolean bl) {
        this.xmlHeader = bl;
    }

    public String[] getSpecialAttributeNames() {
        return this.specialAttributeNames;
    }

    public void setSpecialAttributeNames(String[] stringArray) {
        this.specialAttributeNames = stringArray;
    }

    public int getAttributeLineWrap() {
        return this.attributeLineWrap;
    }

    public void setAttributeLineWrap(int n) {
        this.attributeLineWrap = n;
    }

    public void escapedText(String string) throws IOException {
        int n;
        this.text("");
        if (this.isPretty()) {
            for (n = string.length(); n > 0 && (string.charAt(n - 1) == '\r' || string.charAt(n - 1) == '\n'); --n) {
            }
        }
        this.write(string.substring(0, n));
    }

    public void processingInstruction(String string) throws IOException {
        this.write("<?" + string + "?>");
        if (this.isPrettyHeader()) {
            this.write("\r\n");
        }
    }
}

