/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.IOException;
import org.hl7.fhir.utilities.xml.XMLNamespace;

public class XMLWriterState {
    private String name;
    private String namespace;
    private boolean children;
    private boolean inComment;
    private boolean pretty;
    private XMLNamespace[] namespaceDefns = null;

    public void addNamespaceDefn(String string, String string2) throws IOException {
        XMLNamespace xMLNamespace = this.getDefnByAbbreviation(string2);
        if (xMLNamespace != null) {
            throw new IOException("duplicate namespace declaration on \"" + string2 + "\"");
        }
        xMLNamespace = new XMLNamespace(string, string2);
        if (this.namespaceDefns == null) {
            this.namespaceDefns = new XMLNamespace[]{xMLNamespace};
        } else {
            XMLNamespace[] xMLNamespaceArray = new XMLNamespace[this.namespaceDefns.length + 1];
            for (int i = 0; i < this.namespaceDefns.length; ++i) {
                xMLNamespaceArray[i] = this.namespaceDefns[i];
            }
            this.namespaceDefns = xMLNamespaceArray;
            this.namespaceDefns[this.namespaceDefns.length - 1] = xMLNamespace;
        }
    }

    public XMLNamespace getDefnByNamespace(String string) {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i = 0; i < this.namespaceDefns.length; ++i) {
            XMLNamespace xMLNamespace = this.namespaceDefns[i];
            if (!xMLNamespace.getNamespace().equals(string)) continue;
            return xMLNamespace;
        }
        return null;
    }

    public XMLNamespace getDefnByAbbreviation(String string) {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i = 0; i < this.namespaceDefns.length; ++i) {
            XMLNamespace xMLNamespace = this.namespaceDefns[i];
            if (xMLNamespace.getAbbreviation() == null || !xMLNamespace.getAbbreviation().equals(string)) continue;
            return xMLNamespace;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public boolean hasChildren() {
        return this.children;
    }

    public void seeChild() {
        this.children = true;
    }

    public XMLNamespace getDefaultNamespace() {
        if (this.namespaceDefns == null) {
            return null;
        }
        for (int i = 0; i < this.namespaceDefns.length; ++i) {
            XMLNamespace xMLNamespace = this.namespaceDefns[i];
            if (xMLNamespace.getAbbreviation() != null) continue;
            return xMLNamespace;
        }
        return null;
    }

    public boolean isInComment() {
        return this.inComment;
    }

    public void setInComment(boolean bl) {
        this.inComment = bl;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean bl) {
        this.pretty = bl;
    }
}

