/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XhtmlGeneratorAdorner;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XhtmlGenerator {
    private static final int LINE_LIMIT = 85;
    private XhtmlGeneratorAdorner adorner;

    public XhtmlGenerator(XhtmlGeneratorAdorner xhtmlGeneratorAdorner) {
        this.adorner = xhtmlGeneratorAdorner;
    }

    public String generateInsert(Document document, String string, String string2) throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<div class=\"example\">\r\n");
        stringWriter.write("<p>Example Instance \"" + string + "\"" + (string2 == null ? "" : ": " + Utilities.escapeXml(string2)) + "</p>\r\n");
        stringWriter.write("<pre class=\"xml\">\r\n");
        XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState = null;
        for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
            this.writeNode(stringWriter, document.getChildNodes().item(i), xhtmlGeneratorAdornerState, 0);
        }
        stringWriter.write("</pre>\r\n");
        stringWriter.write("</div>\r\n");
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void generate(Document document, File file, String string, String string2, int n, boolean bl) throws Exception {
        int n2;
        bl = true;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        outputStreamWriter.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\r\n");
        outputStreamWriter.write("<head>\r\n");
        outputStreamWriter.write(" <title>Example Instance for " + string + "</title>\r\n");
        outputStreamWriter.write(" <link rel=\"stylesheet\" href=\"");
        for (n2 = 0; n2 < n; ++n2) {
            outputStreamWriter.write("../");
        }
        outputStreamWriter.write("fhir.css\" type=\"text/css\" media=\"screen\"/>\r\n");
        if (!bl) {
            outputStreamWriter.write(" <link rel=\"stylesheet\" href=\"");
            for (n2 = 0; n2 < n; ++n2) {
                outputStreamWriter.write("../");
            }
            outputStreamWriter.write("./assets/css/xml.css\" type=\"text/css\" media=\"screen\"/>\r\n");
            outputStreamWriter.write(" <script src=\"");
            for (n2 = 0; n2 < n; ++n2) {
                outputStreamWriter.write("../");
            }
            outputStreamWriter.write("./assets/js/xml.js\"></script>\r\n");
            outputStreamWriter.write("<script>\r\n  hljs.tabReplace = '  '; // 2 spaces\r\n  hljs.initHighlightingOnLoad();\r\n</script>\r\n");
        }
        outputStreamWriter.write("</head>\r\n");
        outputStreamWriter.write("<body>\r\n");
        outputStreamWriter.write("<p>&nbsp;</p>\r\n");
        outputStreamWriter.write("<div class=\"example\">\r\n");
        outputStreamWriter.write("<p>" + Utilities.escapeXml(string2) + "</p>\r\n");
        outputStreamWriter.write("<p><a href=\"" + file.getName().substring(0, file.getName().length() - 5) + "\">Raw XML</a></p>\r\n");
        if (bl) {
            outputStreamWriter.write("<pre class=\"xml\">\r\n");
            XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState = null;
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                this.writeNode(outputStreamWriter, document.getChildNodes().item(i), xhtmlGeneratorAdornerState, n);
            }
            outputStreamWriter.write("</pre>\r\n");
        } else {
            outputStreamWriter.write("<code class=\"xml\">\r\n");
            for (n2 = 0; n2 < document.getChildNodes().getLength(); ++n2) {
                this.writeNodePlain(outputStreamWriter, document.getChildNodes().item(n2), n);
            }
            outputStreamWriter.write("</code>\r\n");
        }
        outputStreamWriter.write("</div>\r\n");
        outputStreamWriter.write("</body>\r\n");
        outputStreamWriter.write("</html>\r\n");
        outputStreamWriter.flush();
        fileOutputStream.close();
    }

    public void generate(Document document, OutputStream outputStream, String string, String string2, int n, boolean bl, String string3) throws Exception {
        bl = true;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write("<div class=\"example\">\r\n");
        outputStreamWriter.write("<p>" + Utilities.escapeXml(string2) + "</p>\r\n");
        outputStreamWriter.write("<p><a href=\"" + string3.substring(0, string3.length() - 5) + "\">Raw XML</a></p>\r\n");
        if (bl) {
            outputStreamWriter.write("<pre class=\"xml\">\r\n");
            XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState = null;
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                this.writeNode(outputStreamWriter, document.getChildNodes().item(i), xhtmlGeneratorAdornerState, n);
            }
            outputStreamWriter.write("</pre>\r\n");
        } else {
            outputStreamWriter.write("<code class=\"xml\">\r\n");
            for (int i = 0; i < document.getChildNodes().getLength(); ++i) {
                this.writeNodePlain(outputStreamWriter, document.getChildNodes().item(i), n);
            }
            outputStreamWriter.write("</code>\r\n");
        }
        outputStreamWriter.write("</div>\r\n");
        outputStreamWriter.flush();
    }

    private void writeNodePlain(Writer writer, Node node, int n) throws Exception {
        if (node.getNodeType() == 1) {
            this.writeElementPlain(writer, (Element)node, n);
        } else if (node.getNodeType() == 3) {
            this.writeTextPlain(writer, (Text)node, n);
        } else if (node.getNodeType() == 8) {
            this.writeCommentPlain(writer, (Comment)node, n);
        } else if (node.getNodeType() == 7) {
            this.writeProcessingInstructionPlain(writer, (ProcessingInstruction)node);
        } else if (node.getNodeType() != 2) {
            throw new Exception("Unhandled node type");
        }
    }

    private void writeNode(Writer writer, Node node, XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState, int n) throws Exception {
        if (node.getNodeType() == 1) {
            this.writeElement(writer, (Element)node, xhtmlGeneratorAdornerState, n);
        } else if (node.getNodeType() == 3) {
            this.writeText(writer, (Text)node, n);
        } else if (node.getNodeType() == 8) {
            this.writeComment(writer, (Comment)node, n);
        } else if (node.getNodeType() == 7) {
            this.writeProcessingInstruction(writer, (ProcessingInstruction)node);
        } else if (node.getNodeType() != 2) {
            throw new Exception("Unhandled node type");
        }
    }

    private void writeProcessingInstruction(Writer writer, ProcessingInstruction processingInstruction) {
    }

    private void writeProcessingInstructionPlain(Writer writer, ProcessingInstruction processingInstruction) {
    }

    private void writeComment(Writer writer, Comment comment, int n) throws DOMException, IOException {
        writer.write("<span class=\"xmlcomment\">&lt;!-- " + this.escapeHtml(Utilities.escapeXml(comment.getTextContent()), n) + " --&gt;</span>");
    }

    private void writeCommentPlain(Writer writer, Comment comment, int n) throws DOMException, IOException {
        writer.write("<!-- " + Utilities.escapeXml(comment.getTextContent()) + " -->");
    }

    private void writeText(Writer writer, Text text, int n) throws DOMException, IOException {
        writer.write("<b>" + this.escapeHtml(Utilities.escapeXml(text.getTextContent()), n) + "</b>");
    }

    private void writeTextPlain(Writer writer, Text text, int n) throws DOMException, IOException {
        writer.write(Utilities.escapeXml(text.getTextContent()));
    }

    private void writeElement(Writer writer, Element element, XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState, int n) throws Exception {
        int n2;
        XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState2;
        writer.write("<span class=\"xmltag\">&lt;" + element.getNodeName() + "</span>");
        if (element.hasAttributes()) {
            writer.write("<span class=\"xmlattr\">");
            xhtmlGeneratorAdornerState2 = this.adorner == null ? new XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState("", "") : this.adorner.getState(this, xhtmlGeneratorAdornerState, element);
            for (n2 = 0; n2 < element.getAttributes().getLength(); ++n2) {
                if (this.adorner != null) {
                    XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState3 = this.adorner.getAttributeMarkup(this, xhtmlGeneratorAdornerState2, element, element.getAttributes().item(n2).getNodeName(), element.getAttributes().item(n2).getTextContent());
                    writer.write(" " + element.getAttributes().item(n2).getNodeName() + "=\"<span class=\"xmlattrvalue\">" + xhtmlGeneratorAdornerState3.getPrefix() + this.escapeHtml(Utilities.escapeXml(element.getAttributes().item(n2).getTextContent()), n) + xhtmlGeneratorAdornerState3.getSuffix() + "</span>\"");
                    continue;
                }
                writer.write(" " + element.getAttributes().item(n2).getNodeName() + "=\"<span class=\"xmlattrvalue\">" + this.escapeHtml(Utilities.escapeXml(element.getAttributes().item(n2).getTextContent()), n) + "</span>\"");
            }
            writer.write("</span>");
        }
        if (element.hasChildNodes()) {
            writer.write("<span class=\"xmltag\">&gt;</span>");
            XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState4 = xhtmlGeneratorAdornerState2 = this.adorner == null ? new XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState("", "") : this.adorner.getState(this, xhtmlGeneratorAdornerState, element);
            if (xhtmlGeneratorAdornerState2.isSuppress()) {
                writer.write("<span class=\"xmlcomment\">&lt;!-- " + this.escapeHtml(xhtmlGeneratorAdornerState2.getSupressionMessage(), n) + " --&gt;</span>");
            } else {
                writer.write(xhtmlGeneratorAdornerState2.getPrefix());
                for (n2 = 0; n2 < element.getChildNodes().getLength(); ++n2) {
                    this.writeNode(writer, element.getChildNodes().item(n2), xhtmlGeneratorAdornerState2, n + 2);
                }
                writer.write(xhtmlGeneratorAdornerState2.getSuffix());
            }
            writer.write("<span class=\"xmltag\">&lt;/" + element.getNodeName() + "&gt;</span>");
        } else {
            writer.write("<span class=\"xmltag\">/&gt;</span>");
        }
    }

    private void writeElementPlain(Writer writer, Element element, int n) throws Exception {
        int n2;
        writer.write("<" + element.getNodeName());
        if (element.hasAttributes()) {
            for (n2 = 0; n2 < element.getAttributes().getLength(); ++n2) {
                writer.write(" " + element.getAttributes().item(n2).getNodeName() + "=\"" + Utilities.escapeXml(element.getAttributes().item(n2).getTextContent()) + "\"");
            }
        }
        if (element.hasChildNodes()) {
            writer.write(">");
            for (n2 = 0; n2 < element.getChildNodes().getLength(); ++n2) {
                this.writeNodePlain(writer, element.getChildNodes().item(n2), n + 2);
            }
            writer.write("</" + element.getNodeName() + ">");
        } else {
            writer.write("/>");
        }
    }

    private String escapeHtml(String string, int n) {
        if (string == null) {
            return "";
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            ++n2;
            if (c == '\r' || c == '\n') {
                n2 = 0;
            }
            if (n2 > 85 && c == ' ' || n2 > 100) {
                stringBuilder.append("\r\n");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(" ");
                }
                n2 = 0;
            }
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("  ");
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

