/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.hl7.fhir.utilities.xml.XMLWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlGenerator {
    private XMLWriter xml;

    public void generate(Element element, File file, String string, String string2) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.xml = new XMLWriter((OutputStream)fileOutputStream, "UTF-8");
        this.xml.start();
        this.xml.setDefaultNamespace(string);
        this.xml.open(string, string2);
        this.processContents(element);
        this.xml.close();
        this.xml.flush();
    }

    public void generate(Element element, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.xml = new XMLWriter((OutputStream)fileOutputStream, "UTF-8");
        this.xml.start();
        this.xml.setDefaultNamespace(element.getNamespaceURI());
        this.processElement(element);
        this.xml.flush();
    }

    private void processContents(Element element) throws Exception {
        block5: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    this.processElement((Element)node);
                    continue block5;
                }
                case 3: {
                    this.processText(node);
                    continue block5;
                }
                case 8: {
                    this.processComment((Comment)node);
                    continue block5;
                }
                default: {
                    throw new Exception("unhandled node type " + Integer.toString(node.getNodeType()));
                }
            }
        }
    }

    private void processComment(Comment comment) throws Exception {
        this.xml.comment(comment.getNodeValue(), true);
    }

    private void processElement(Element element) throws Exception {
        if (!element.getNamespaceURI().equals(this.xml.getDefaultNamespace())) {
            this.xml.setDefaultNamespace(element.getNamespaceURI());
        }
        this.processAttributes(element);
        this.xml.open(element.getNamespaceURI(), element.getLocalName());
        this.processContents(element);
        this.xml.close();
    }

    private void processText(Node node) throws Exception {
        this.xml.text(node.getNodeValue());
    }

    private void processAttributes(Element element) throws Exception {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (node.getNamespaceURI() != null || node.getLocalName() == null) continue;
            this.xml.attribute(node.getLocalName(), node.getNodeValue());
        }
    }
}

