/*
 * Decompiled with CFR 0.152.
 */
package me.ghui.fruit.bind;

import me.ghui.fruit.Fruit;
import me.ghui.fruit.PickAdapter;
import me.ghui.fruit.PickAdapterFactory;
import me.ghui.fruit.annotations.Nullable;
import me.ghui.fruit.annotations.Pick;
import me.ghui.fruit.bind.CollectionPickAdapterFactory;
import me.ghui.fruit.bind.ReflectivePickAdapterFactory;
import me.ghui.fruit.internal.Preconditions;
import me.ghui.fruit.reflect.TypeToken;
import org.jsoup.nodes.Element;

public final class PickAdapters {
    private static final PickAdapter<String> STRING = new PickAdapter<String>(){

        @Override
        public String read(Element element, Pick pick) {
            return (String)PickAdapters.parseElement(element, pick, String.class);
        }
    };
    private static final PickAdapter<Number> INTEGER = new PickAdapter<Number>(){

        @Override
        public Number read(Element element, @Nullable Pick pick) {
            return (Number)PickAdapters.parseElement(element, pick, Integer.TYPE);
        }
    };
    private static final PickAdapter<Number> LONG = new PickAdapter<Number>(){

        @Override
        public Number read(Element element, @Nullable Pick pick) {
            return (Number)PickAdapters.parseElement(element, pick, Long.class);
        }
    };
    public static final PickAdapterFactory STRING_FACTORY = PickAdapters.newFactory(String.class, STRING);
    public static final PickAdapterFactory INTEGER_FACTORY = PickAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final PickAdapterFactory LONG_FACTORY = PickAdapters.newFactory(Long.TYPE, Long.class, LONG);
    public static final PickAdapterFactory COLLECTION_FACTORY = new CollectionPickAdapterFactory();
    public static final ReflectivePickAdapterFactory REFLECTIVE_ADAPTER = new ReflectivePickAdapterFactory();

    private PickAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <T> PickAdapterFactory newFactory(final Class<T> type, final PickAdapter<T> adapter) {
        return new PickAdapterFactory(){

            public <TT> PickAdapter<TT> create(Fruit fruit, TypeToken<TT> typeToken) {
                return typeToken.getRawType() == type ? adapter : null;
            }
        };
    }

    public static <TT> PickAdapterFactory newFactory(final Class<TT> unboxed, final Class<TT> boxed, final PickAdapter<? super TT> adapter) {
        return new PickAdapterFactory(){

            @Override
            public <T> PickAdapter<T> create(Fruit fruit, TypeToken<T> typeToken) {
                return unboxed == typeToken.getRawType() || boxed == typeToken.getRawType() ? adapter : null;
            }
        };
    }

    private static <T> T parseElement(Element element, Pick pick, Class<T> type) {
        String value = null;
        if (pick != null) {
            if (Preconditions.notEmpty(pick.value())) {
                element = element.select(pick.value()).first();
            }
            if (element == null) {
                return (T)value;
            }
            String attr = pick.attr();
            value = "text".equals(attr) ? element.text() : ("ownText".equals(attr) ? element.ownText() : ("html".equals(attr) ? element.outerHtml() : ("inner_html".equals(attr) ? element.html() : element.attr(attr))));
        } else {
            value = element.text();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        return (T)value;
    }
}

