/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.stream.Collectors;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.BruteForceMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.ConfigurationBuilder;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.resources.FeedbackUtil;
import me.gosimple.nbvcxz.scoring.Result;
import me.gosimple.nbvcxz.scoring.TimeEstimate;

public class Nbvcxz {
    private Configuration configuration;

    public Nbvcxz() {
        this.configuration = new ConfigurationBuilder().createConfiguration();
    }

    public Nbvcxz(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Result estimate(String password) {
        return Nbvcxz.guessEntropy(this.configuration, password);
    }

    private static Result guessEntropy(Configuration configuration, String password) {
        int k;
        List<Match> matches = Nbvcxz.getMatches(configuration, password);
        int length = password.length();
        Match[] match_at_index = new Match[length];
        ArrayList<Match> match_list = new ArrayList<Match>();
        for (k = 0; k < length; ++k) {
            for (Match match : matches) {
                if (match.getEndIndex() != k || match_at_index[k] != null && !(match_at_index[k].calculateEntropy() / (double)match_at_index[k].getLength() > match.calculateEntropy() / (double)match.getLength())) continue;
                match_at_index[k] = match;
            }
        }
        k = length - 1;
        while (k >= 0) {
            Match match = match_at_index[k];
            if (match == null) {
                match_list.add(Nbvcxz.createBruteForceMatch(password, configuration, k, k));
                --k;
                continue;
            }
            match_list.add(match);
            k = match.getStartIndex() - 1;
        }
        Collections.reverse(match_list);
        return new Result(configuration, password, match_list);
    }

    private static List<Match> getMatches(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (PasswordMatcher passwordMatcher : configuration.getPasswordMatchers()) {
            matches.addAll(passwordMatcher.match(configuration, password));
        }
        return matches;
    }

    private static Match createBruteForceMatch(String password, Configuration configuration, int start_index, int end_index) {
        return new BruteForceMatch(password.substring(start_index, end_index + 1), configuration, start_index, end_index);
    }

    public static Double getEntropyFromGuesses(BigDecimal guesses) {
        Double guesses_tmp = guesses.doubleValue();
        guesses_tmp = guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp;
        return Math.log(guesses_tmp) / Math.log(2.0);
    }

    public static BigDecimal getGuessesFromEntropy(Double entropy) {
        Double guesses_tmp = Math.pow(2.0, entropy);
        return new BigDecimal(guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp).setScale(0, RoundingMode.HALF_UP);
    }

    public static void main(String ... args) {
        Nbvcxz nbvcxz = new Nbvcxz();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        Scanner scanner = new Scanner(System.in);
        System.out.println(resourceBundle.getString("main.howToQuit"));
        while (true) {
            System.out.println(resourceBundle.getString("main.startPrompt"));
            String password = scanner.nextLine();
            if ("\\quit".equals(password)) break;
            Nbvcxz.printExstimationInfo(nbvcxz, password);
        }
        System.out.println(resourceBundle.getString("main.quitPrompt") + " ");
    }

    private static void printExstimationInfo(Nbvcxz nbvcxz, String password) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        long start = System.currentTimeMillis();
        Result result = nbvcxz.estimate(password);
        long end = System.currentTimeMillis();
        System.out.println("----------------------------------------------------------");
        System.out.println(resourceBundle.getString("main.timeToCalculate") + " " + (end - start) + " ms");
        System.out.println(resourceBundle.getString("main.password") + " " + password);
        System.out.println(resourceBundle.getString("main.entropy") + " " + result.getEntropy());
        Feedback feedback = FeedbackUtil.getFeedback(result);
        if (feedback.getWarning() != null) {
            System.out.println(resourceBundle.getString("main.feedback.warning") + " " + feedback.getWarning());
        }
        for (String suggestion : feedback.getSuggestion()) {
            System.out.println(resourceBundle.getString("main.feedback.suggestion") + " " + suggestion);
        }
        Map sortedMap = result.getConfiguration().getGuessTypes().entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (Map.Entry guessType : sortedMap.entrySet()) {
            System.out.println(resourceBundle.getString("main.timeToCrack") + " " + (String)guessType.getKey() + ": " + TimeEstimate.getTimeToCrackFormatted(result, (String)guessType.getKey()));
        }
        for (Match match : result.getMatches()) {
            System.out.println("-----------------------------------");
            System.out.println(match.getDetails());
        }
        System.out.println("----------------------------------------------------------");
    }
}

