/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching;

import java.util.ArrayList;
import java.util.List;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.DictionaryMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;

public final class DictionaryMatcher
implements PasswordMatcher {
    @Override
    public List<Match> match(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (int start = 0; start < password.length(); ++start) {
            for (int end = start + 1; end <= password.length(); ++end) {
                String split_password = password.substring(start, end);
                String lower_part = split_password.toLowerCase();
                String unleet_part = DictionaryMatcher.translateLeet(configuration, lower_part);
                String reversed_part = new StringBuilder(lower_part).reverse().toString();
                String reversed_unleet_part = new StringBuilder(unleet_part).reverse().toString();
                List<Character[]> subs = DictionaryMatcher.getLeetSub(configuration, split_password);
                for (Dictionary dictionary : configuration.getDictionaries()) {
                    Integer reversed_unleet_rank;
                    Integer reversed_rank;
                    Integer unleet_rank;
                    if (dictionary.isExclusion() && (start != 0 || end != password.length())) continue;
                    Integer lower_rank = dictionary.getDictonary().get(lower_part);
                    if (lower_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, lower_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), false, dictionary.getDictionaryName()));
                    }
                    if (!unleet_part.equals(lower_part) && (unleet_rank = dictionary.getDictonary().get(unleet_part)) != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, unleet_rank, subs, dictionary.isExclusion(), false, dictionary.getDictionaryName()));
                    }
                    if (!reversed_part.equals(lower_part) && !reversed_part.equals(unleet_part) && (reversed_rank = dictionary.getDictonary().get(reversed_part)) != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, reversed_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), true, dictionary.getDictionaryName()));
                    }
                    if (reversed_unleet_part.equals(lower_part) || reversed_unleet_part.equals(reversed_part) || reversed_unleet_part.equals(reversed_part) || (reversed_unleet_rank = dictionary.getDictonary().get(reversed_unleet_part)) == null) continue;
                    matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, reversed_unleet_rank, subs, dictionary.isExclusion(), true, dictionary.getDictionaryName()));
                }
            }
        }
        return matches;
    }

    private static String translateLeet(Configuration configuration, String password) {
        char[] array = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            Character replacement = configuration.getLeetTable().get(Character.valueOf(password.charAt(i)));
            array[i] = replacement != null ? replacement.charValue() : password.charAt(i);
        }
        return new String(array);
    }

    private static List<Character[]> getLeetSub(Configuration configuration, String password) {
        ArrayList<Character[]> leet_subs = new ArrayList<Character[]>();
        for (int i = 0; i < password.length(); ++i) {
            Character replacement = configuration.getLeetTable().get(Character.valueOf(password.charAt(i)));
            if (replacement == null) continue;
            leet_subs.add(new Character[]{Character.valueOf(password.charAt(i)), replacement});
        }
        return leet_subs;
    }
}

