/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.matching.match.SpacialMatch;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.AdjacencyGraphUtil;
import me.gosimple.nbvcxz.resources.Configuration;

public final class SpacialMatcher
implements PasswordMatcher {
    @Override
    public List<Match> match(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        HashMap<Integer, Set<Character>> neighbors = new HashMap<Integer, Set<Character>>();
        for (AdjacencyGraph adjacencyGraph : configuration.getAdjacencyGraphs()) {
            for (int i = 0; i < password.length(); ++i) {
                neighbors.put(i, AdjacencyGraphUtil.getNeighbors(adjacencyGraph, Character.valueOf(password.charAt(i))));
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < password.length(); ++i) {
                Character character = Character.valueOf(password.charAt(i));
                int neighbors_i = i + 1;
                if (neighbors_i < neighbors.size()) {
                    boolean added = false;
                    for (Character neighbor : (Set)neighbors.get(neighbors_i)) {
                        if (!neighbor.equals(character)) continue;
                        builder.append(character);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    builder.append(character);
                    if (builder.length() > 1) {
                        matches.add(new SpacialMatch(builder.toString(), configuration, i - builder.length() + 1, i, adjacencyGraph, AdjacencyGraphUtil.getTurns(adjacencyGraph, builder.toString()), AdjacencyGraphUtil.getShifts(adjacencyGraph, builder.toString())));
                    }
                    builder.setLength(0);
                    continue;
                }
                builder.append(character);
                if (builder.length() > 1) {
                    matches.add(new SpacialMatch(builder.toString(), configuration, i - builder.length() + 1, i, adjacencyGraph, AdjacencyGraphUtil.getTurns(adjacencyGraph, builder.toString()), AdjacencyGraphUtil.getShifts(adjacencyGraph, builder.toString())));
                }
                builder.setLength(0);
            }
        }
        return matches;
    }
}

