/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.Configuration;

public final class SequenceMatch
extends BaseMatch {
    private final char firstCharacter;

    public SequenceMatch(String match, Configuration configuration, int start_index, int end_index) {
        super(match, configuration, start_index, end_index);
        this.firstCharacter = match.charAt(0);
    }

    @Override
    public double calculateEntropy() {
        char firstChar = this.getFirstCharacter();
        double baseEntropy = firstChar == 'a' || firstChar == '1' ? 1.0 : (Character.isDigit(firstChar) ? LOG_10 : (Character.isLowerCase(firstChar) ? LOG_26 : LOG_26 + 1.0));
        return Math.max(0.0, baseEntropy + SequenceMatch.log2(this.getLength()));
    }

    public char getFirstCharacter() {
        return this.firstCharacter;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.firstCharacter")).append(" ").append(this.getFirstCharacter());
        return detailBuilder.toString();
    }
}

