/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.BruteForceMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.ConfigurationBuilder;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.resources.FeedbackUtil;
import me.gosimple.nbvcxz.scoring.Result;
import me.gosimple.nbvcxz.scoring.TimeEstimate;

public class Nbvcxz {
    private static StartIndexComparator comparator = new StartIndexComparator();
    private Configuration configuration;

    public Nbvcxz() {
        this.configuration = new ConfigurationBuilder().createConfiguration();
    }

    public Nbvcxz(Configuration configuration) {
        this.configuration = configuration;
    }

    private static Result guessEntropy(Configuration configuration, String password) {
        Result final_result = new Result(configuration, password, Nbvcxz.getBestCombination(configuration, password));
        return final_result;
    }

    private static List<Match> getBestCombination(Configuration configuration, String password) {
        List<Match> all_matches = Nbvcxz.getAllMatches(configuration, password);
        if (all_matches == null || all_matches.size() == 0 || Nbvcxz.isRandom(password, Nbvcxz.findGoodEnoughCombination(configuration, password, all_matches))) {
            ArrayList<Match> brute_force_matches = new ArrayList<Match>();
            Nbvcxz.backfillBruteForce(configuration, password, brute_force_matches);
            brute_force_matches.sort(comparator);
            return brute_force_matches;
        }
        Collections.sort(all_matches, comparator);
        return Nbvcxz.findBestCombination(configuration, password, all_matches);
    }

    private static List<Match> findGoodEnoughCombination(Configuration configuration, String password, List<Match> all_matches) {
        int k;
        int length = password.length();
        Match[] match_at_index = new Match[length];
        ArrayList<Match> match_list = new ArrayList<Match>();
        for (k = 0; k < length; ++k) {
            for (Match match : all_matches) {
                if (match.getEndIndex() != k || match_at_index[k] != null && !(match_at_index[k].calculateEntropy() / (double)match_at_index[k].getLength() > match.calculateEntropy() / (double)match.getLength())) continue;
                match_at_index[k] = match;
            }
        }
        k = length - 1;
        while (k >= 0) {
            Match match = match_at_index[k];
            if (match == null) {
                match_list.add(Nbvcxz.createBruteForceMatch(password, configuration, k, k));
                --k;
                continue;
            }
            match_list.add(match);
            k = match.getStartIndex() - 1;
        }
        Collections.reverse(match_list);
        return match_list;
    }

    private static List<Match> findBestCombination(Configuration configuration, String password, List<Match> all_matches) {
        HashMap<Match, Set<Match>> non_intersecting_matches = new HashMap<Match, Set<Match>>();
        for (int i = 0; i < all_matches.size(); ++i) {
            Match match = all_matches.get(i);
            HashSet<Match> forward_non_intersecting_match_set = new HashSet<Match>();
            for (int n = i + 1; n < all_matches.size(); ++n) {
                Match next_match = all_matches.get(n);
                if (next_match.getStartIndex() <= match.getEndIndex() || next_match.getStartIndex() < match.getEndIndex() && match.getStartIndex() < next_match.getEndIndex()) continue;
                boolean to_add = true;
                for (Match non_intersecting_match : forward_non_intersecting_match_set) {
                    if (next_match.getStartIndex() <= non_intersecting_match.getEndIndex()) continue;
                    to_add = false;
                    break;
                }
                if (!to_add) continue;
                forward_non_intersecting_match_set.add(next_match);
            }
            non_intersecting_matches.put(match, forward_non_intersecting_match_set);
        }
        HashSet<Match> seed_matches = new HashSet<Match>();
        for (Match match : all_matches) {
            boolean seed = true;
            for (Set matchSet : non_intersecting_matches.values()) {
                for (Match m : matchSet) {
                    if (!m.equals(match)) continue;
                    seed = false;
                }
            }
            if (!seed) continue;
            seed_matches.add(match);
        }
        ArrayList<Match> lowest_entropy_matches = new ArrayList<Match>();
        for (Match match : seed_matches) {
            Nbvcxz.generateMatches(configuration, password, match, non_intersecting_matches, new ArrayList<Match>(), lowest_entropy_matches);
        }
        lowest_entropy_matches.sort(comparator);
        return lowest_entropy_matches;
    }

    private static void generateMatches(Configuration configuration, String password, Match match, Map<Match, Set<Match>> non_intersecting_matches, List<Match> matches, List<Match> lowest_entropy_matches) {
        matches.add(match);
        if (!lowest_entropy_matches.isEmpty() && Nbvcxz.calcEntropy(matches) > Nbvcxz.calcEntropy(lowest_entropy_matches)) {
            return;
        }
        boolean found_next = false;
        for (Match next_match : non_intersecting_matches.get(match)) {
            boolean intersects = false;
            for (Match existing_match : matches) {
                if (next_match.getStartIndex() >= existing_match.getEndIndex() || existing_match.getStartIndex() >= next_match.getEndIndex()) continue;
                intersects = true;
                break;
            }
            if (intersects) continue;
            Nbvcxz.generateMatches(configuration, password, next_match, non_intersecting_matches, new ArrayList<Match>(matches), lowest_entropy_matches);
            found_next = true;
        }
        if (!found_next) {
            Nbvcxz.backfillBruteForce(configuration, password, matches);
            if (lowest_entropy_matches.isEmpty() || Nbvcxz.calcEntropy(matches) < Nbvcxz.calcEntropy(lowest_entropy_matches)) {
                lowest_entropy_matches.clear();
                lowest_entropy_matches.addAll(matches);
            }
        }
    }

    private static boolean isRandom(String password, List<Match> matches) {
        int matched_length = 0;
        int max_matched_length = 0;
        for (Match match : matches) {
            if (match instanceof BruteForceMatch) continue;
            matched_length += match.getLength();
            if (match.getLength() <= max_matched_length) continue;
            max_matched_length = match.getLength();
        }
        if ((double)matched_length < (double)password.length() * 0.5) {
            return true;
        }
        return (double)matched_length < (double)password.length() * 0.8 && (double)password.length() * 0.25 > (double)max_matched_length;
    }

    private static double calcEntropy(List<Match> matches) {
        double entropy = 0.0;
        for (Match match : matches) {
            entropy += match.calculateEntropy();
        }
        return entropy;
    }

    private static void backfillBruteForce(Configuration configuration, String password, List<Match> matches) {
        HashSet<Match> brute_force_matches = new HashSet<Match>();
        for (int index = 0; index < password.length(); ++index) {
            boolean has_match = false;
            for (Match match : matches) {
                if (index < match.getStartIndex() || index > match.getEndIndex()) continue;
                has_match = true;
            }
            if (has_match) continue;
            brute_force_matches.add(Nbvcxz.createBruteForceMatch(password, configuration, index, index));
        }
        matches.addAll(brute_force_matches);
    }

    private static List<Match> getAllMatches(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (PasswordMatcher passwordMatcher : configuration.getPasswordMatchers()) {
            matches.addAll(passwordMatcher.match(configuration, password));
        }
        Nbvcxz.keepLowestMatches(matches);
        return matches;
    }

    private static void keepLowestMatches(List<Match> matches) {
        HashSet<Match> to_remove = new HashSet<Match>();
        block0: for (Match match : matches) {
            for (Match to_compare : matches) {
                if (match.getStartIndex() != to_compare.getStartIndex() || match.getEndIndex() != to_compare.getEndIndex() || !(match.calculateEntropy() / (double)match.getLength() > to_compare.calculateEntropy() / (double)to_compare.getLength())) continue;
                to_remove.add(match);
                continue block0;
            }
        }
        matches.removeAll(to_remove);
    }

    private static Match createBruteForceMatch(String password, Configuration configuration, int start_index, int end_index) {
        return new BruteForceMatch(password.substring(start_index, end_index + 1), configuration, start_index, end_index);
    }

    public static Double getEntropyFromGuesses(BigDecimal guesses) {
        Double guesses_tmp = guesses.doubleValue();
        guesses_tmp = guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp;
        return Math.log(guesses_tmp) / Math.log(2.0);
    }

    public static BigDecimal getGuessesFromEntropy(Double entropy) {
        Double guesses_tmp = Math.pow(2.0, entropy);
        return new BigDecimal(guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp).setScale(0, RoundingMode.HALF_UP);
    }

    public static void main(String ... args) {
        Configuration configuration = new ConfigurationBuilder().createConfiguration();
        Nbvcxz nbvcxz = new Nbvcxz(configuration);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        Scanner scanner = new Scanner(System.in);
        System.out.println(resourceBundle.getString("main.howToQuit"));
        while (true) {
            System.out.println(resourceBundle.getString("main.startPrompt"));
            String password = scanner.nextLine();
            if ("\\quit".equals(password)) break;
            Nbvcxz.printEstimationInfo(nbvcxz, password);
        }
        System.out.println(resourceBundle.getString("main.quitPrompt") + " ");
    }

    private static void printEstimationInfo(Nbvcxz nbvcxz, String password) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        long start = System.currentTimeMillis();
        Result result = nbvcxz.estimate(password);
        long end = System.currentTimeMillis();
        System.out.println("----------------------------------------------------------");
        System.out.println(resourceBundle.getString("main.timeToCalculate") + " " + (end - start) + " ms");
        System.out.println(resourceBundle.getString("main.password") + " " + password);
        System.out.println(resourceBundle.getString("main.entropy") + " " + result.getEntropy());
        Feedback feedback = FeedbackUtil.getFeedback(result);
        if (feedback.getWarning() != null) {
            System.out.println(resourceBundle.getString("main.feedback.warning") + " " + feedback.getWarning());
        }
        for (String suggestion : feedback.getSuggestion()) {
            System.out.println(resourceBundle.getString("main.feedback.suggestion") + " " + suggestion);
        }
        Map sortedMap = result.getConfiguration().getGuessTypes().entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (Map.Entry guessType : sortedMap.entrySet()) {
            System.out.println(resourceBundle.getString("main.timeToCrack") + " " + (String)guessType.getKey() + ": " + TimeEstimate.getTimeToCrackFormatted(result, (String)guessType.getKey()));
        }
        for (Match match : result.getMatches()) {
            System.out.println("-----------------------------------");
            System.out.println(match.getDetails());
        }
        System.out.println("----------------------------------------------------------");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Result estimate(String password) {
        return Nbvcxz.guessEntropy(this.configuration, password);
    }

    private static class StartIndexComparator
    implements Comparator<Match> {
        private StartIndexComparator() {
        }

        @Override
        public int compare(Match match_1, Match match_2) {
            if (match_1.getStartIndex() < match_2.getStartIndex()) {
                return -1;
            }
            if (match_1.getStartIndex() > match_2.getStartIndex()) {
                return 1;
            }
            if (match_1.getStartIndex() == match_2.getStartIndex()) {
                if (match_1.calculateEntropy() / (double)match_1.getToken().length() < match_2.calculateEntropy() / (double)match_2.getToken().length()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

