/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.Configuration;

public final class DateMatch
extends BaseMatch {
    private final int day;
    private final int month;
    private final int year;
    private final String separator;

    public DateMatch(String match, Configuration configuration, int day, int month, int year, String separator, int start_index, int end_index) {
        super(match, configuration, start_index, end_index);
        this.day = day;
        this.month = month;
        this.year = year;
        this.separator = separator;
    }

    @Override
    public double calculateEntropy() {
        double entropy = this.getYear() < 100 ? LOG_37200 : LOG_47988;
        if (this.separator != null && !this.separator.isEmpty()) {
            entropy += 2.0;
        }
        return Math.max(0.0, entropy);
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.year")).append(" ").append(this.getYear());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.month")).append(" ").append(this.getMonth());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.day")).append(" ").append(this.getDay());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.separator")).append(" ").append(this.getSeparator());
        return detailBuilder.toString();
    }
}

