/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.List;
import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.scoring.BruteForceUtil;

public final class DictionaryMatch
extends BaseMatch {
    private static final String START_UPPER = "^[A-Z][^A-Z]+";
    private static final String END_UPPER = "^[^A-Z]+[A-Z]$";
    private static final String ALL_UPPER = "^[^a-z]+$";
    private static final String ALL_LOWER = "^[^A-Z]+$";
    private final String dictionary_name;
    private final String dictionary_value;
    private final int rank;
    private final boolean excluded;
    private final List<Character[]> leetSubstitution;
    private final boolean reversed;
    private final int distance;

    public DictionaryMatch(String match, Configuration configuration, int start_index, int end_index, String dictionary_value, int rank, List<Character[]> leetSubstitution, boolean excluded, boolean reversed, String dictionary_name, int distance) {
        super(match, configuration, start_index, end_index);
        this.dictionary_value = dictionary_value;
        this.rank = rank;
        this.leetSubstitution = leetSubstitution;
        this.excluded = excluded;
        this.dictionary_name = dictionary_name;
        this.reversed = reversed;
        this.distance = distance;
    }

    @Override
    public double calculateEntropy() {
        if (this.excluded) {
            return 0.0;
        }
        double baseEntropy = DictionaryMatch.log2(this.rank);
        return Math.max(0.0, baseEntropy + this.uppercaseEntropy() + this.leetEntropy() + this.reversedEntropy() + this.distanceEntropy());
    }

    private double distanceEntropy() {
        int char_shift;
        if (this.getDistance() == 0) {
            return 0.0;
        }
        int len_diff = this.getToken().length() - this.getDictionaryValue().length();
        if (len_diff + (char_shift = this.getDistance() - Math.abs(len_diff)) <= 0) {
            return 1.0;
        }
        return DictionaryMatch.log2(BruteForceUtil.getBrutForceCardinality(this.getToken()) * (len_diff + char_shift));
    }

    /*
     * WARNING - void declaration
     */
    private double uppercaseEntropy() {
        void var6_11;
        String password = this.getToken();
        if (password.matches(ALL_LOWER)) {
            return 0.0;
        }
        if (password.matches(START_UPPER)) {
            return 1.0;
        }
        if (password.matches(ALL_UPPER)) {
            return 1.0;
        }
        if (password.matches(END_UPPER)) {
            return 1.0;
        }
        int upperCount = 0;
        for (char c : password.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            ++upperCount;
        }
        int lowerCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        while (var6_11 < n) {
            char c = cArray[var6_11];
            if (Character.isLowerCase(c)) {
                ++lowerCount;
            }
            ++var6_11;
        }
        int possiblities = 0;
        int totalCase = upperCount + lowerCount;
        int n2 = Math.min(upperCount, lowerCount);
        for (int i = 0; i <= n2; ++i) {
            possiblities = (int)((long)possiblities + DictionaryMatch.nCk(totalCase, i));
        }
        return Math.max(DictionaryMatch.log2(possiblities), 1.0);
    }

    private double leetEntropy() {
        if (!this.isLeet()) {
            return 0.0;
        }
        int possibilities = 0;
        for (Character[] sub : this.leetSubstitution) {
            char original = sub[0].charValue();
            char newChar = sub[1].charValue();
            int substitutionCount = 0;
            int unSubstitutionCount = 0;
            for (char c : this.getToken().toCharArray()) {
                if (c == newChar) {
                    ++substitutionCount;
                }
                if (c != original) continue;
                ++unSubstitutionCount;
            }
            int totalSub = substitutionCount + unSubstitutionCount;
            int minSub = Math.min(substitutionCount, unSubstitutionCount);
            for (int i = 0; i <= minSub; ++i) {
                possibilities = (int)((long)possibilities + DictionaryMatch.nCk(totalSub, i));
            }
        }
        return Math.max(1.0, DictionaryMatch.log2(possibilities));
    }

    private double reversedEntropy() {
        if (this.isReversed()) {
            return 1.0;
        }
        return 0.0;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isLeet() {
        return this.leetSubstitution.size() > 0;
    }

    public String getDictionaryName() {
        return this.dictionary_name;
    }

    public List<Character[]> getLeetSubstitution() {
        return this.leetSubstitution;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public int getDistance() {
        return this.distance;
    }

    public String getDictionaryValue() {
        return this.dictionary_value;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.dictionary")).append(" ").append(this.getDictionaryName());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.dictionaryValue")).append(" ").append(this.getDictionaryValue());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.rank")).append(" ").append(this.getRank());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.length")).append(" ").append(this.getLength());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.leetSub")).append(" ").append(this.isLeet());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.reversed")).append(" ").append(this.isReversed());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.distance")).append(" ").append(this.getDistance());
        return detailBuilder.toString();
    }
}

