/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.scoring.BruteForceUtil;

public final class RepeatMatch
extends BaseMatch {
    private final String repeatingCharacters;
    private final int repeat;

    public RepeatMatch(String match, Configuration configuration, String repeatingCharacters, int start_index, int end_index) {
        super(match, configuration, start_index, end_index);
        this.repeatingCharacters = repeatingCharacters;
        this.repeat = match.length() / repeatingCharacters.length();
    }

    @Override
    public double calculateEntropy() {
        int cardinality = BruteForceUtil.getBrutForceCardinality(this.getRepeatingCharacters());
        return Math.max(0.0, RepeatMatch.log2(cardinality * this.getRepeat()));
    }

    public String getRepeatingCharacters() {
        return this.repeatingCharacters;
    }

    public int getRepeat() {
        return this.repeat;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.repeatingCharacters")).append(" ").append(this.getRepeatingCharacters());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.repeated")).append(" ").append(this.getRepeat());
        return detailBuilder.toString();
    }
}

