/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.Dictionary;

public class Configuration {
    private final List<PasswordMatcher> passwordMatchers;
    private final Map<String, Long> guessTypes;
    private final List<Dictionary> dictionaries;
    private final List<AdjacencyGraph> adjacencyGraphs;
    private final Map<Character, Character> leetTable;
    private final Pattern yearPattern;
    private final Double minimumEntropy;
    private final Locale locale;
    private final boolean distanceCalc;
    private final ResourceBundle mainResource;
    private final ResourceBundle feedbackResource;

    public Configuration(List<PasswordMatcher> passwordMatchers, Map<String, Long> guessTypes, List<Dictionary> dictionaries, List<AdjacencyGraph> adjacencyGraphs, Map<Character, Character> leetTable, Pattern yearPattern, Double minimumEntropy, Locale locale, boolean distanceCalc) {
        this.passwordMatchers = passwordMatchers;
        this.guessTypes = guessTypes;
        this.dictionaries = dictionaries;
        this.adjacencyGraphs = adjacencyGraphs;
        this.leetTable = leetTable;
        this.yearPattern = yearPattern;
        this.minimumEntropy = minimumEntropy;
        this.locale = locale;
        this.distanceCalc = distanceCalc;
        this.mainResource = ResourceBundle.getBundle("main", locale);
        this.feedbackResource = ResourceBundle.getBundle("feedback", locale);
    }

    public List<PasswordMatcher> getPasswordMatchers() {
        return this.passwordMatchers;
    }

    public Map<String, Long> getGuessTypes() {
        return this.guessTypes;
    }

    public List<Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    public List<AdjacencyGraph> getAdjacencyGraphs() {
        return this.adjacencyGraphs;
    }

    public Map<Character, Character> getLeetTable() {
        return this.leetTable;
    }

    public Pattern getYearPattern() {
        return this.yearPattern;
    }

    public Double getMinimumEntropy() {
        return this.minimumEntropy;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isDistanceCalc() {
        return this.distanceCalc;
    }

    public ResourceBundle getMainResource() {
        return this.mainResource;
    }

    public ResourceBundle getFeedbackResource() {
        return this.feedbackResource;
    }
}

