/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.scoring;

import java.math.BigDecimal;
import java.util.ResourceBundle;
import me.gosimple.nbvcxz.scoring.Result;

public final class TimeEstimate {
    public static BigDecimal getTimeToCrack(Result result, String guess_type) {
        BigDecimal guess_per_second = BigDecimal.valueOf(result.getConfiguration().getGuessTypes().get(guess_type));
        return result.getGuesses().divide(guess_per_second, 0, 3);
    }

    public static String getTimeToCrackFormatted(Result result, String guess_type) {
        BigDecimal minutes;
        BigDecimal hours;
        BigDecimal days;
        BigDecimal months;
        BigDecimal years;
        BigDecimal centuries;
        BigDecimal infinite;
        ResourceBundle mainResource = result.getConfiguration().getMainResource();
        BigDecimal seconds = TimeEstimate.getTimeToCrack(result, guess_type);
        if (seconds.divide(infinite = (centuries = (years = (months = (days = (hours = (minutes = new BigDecimal(60)).multiply(new BigDecimal(60))).multiply(new BigDecimal(24))).multiply(new BigDecimal(30))).multiply(new BigDecimal(12))).multiply(new BigDecimal(100))).multiply(new BigDecimal(100000)), 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return mainResource.getString("main.estimate.greaterCenturies");
        }
        if (seconds.divide(centuries, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(centuries, 0, 3) + " " + mainResource.getString("main.estimate.centuries");
        }
        if (seconds.divide(years, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(years, 0, 3) + " " + mainResource.getString("main.estimate.years");
        }
        if (seconds.divide(months, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(months, 0, 3) + " " + mainResource.getString("main.estimate.months");
        }
        if (seconds.divide(days, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(days, 0, 3) + " " + mainResource.getString("main.estimate.days");
        }
        if (seconds.divide(hours, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(hours, 0, 3) + " " + mainResource.getString("main.estimate.hours");
        }
        if (seconds.divide(minutes, 0, 3).compareTo(BigDecimal.ONE) >= 0) {
            return seconds.divide(minutes, 0, 3) + " " + mainResource.getString("main.estimate.minutes");
        }
        if (seconds.compareTo(BigDecimal.ONE) >= 0) {
            return seconds + " " + mainResource.getString("main.estimate.seconds");
        }
        return mainResource.getString("main.estimate.instant");
    }
}

