/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.stream.Collectors;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.BruteForceMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.ConfigurationBuilder;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.resources.FeedbackUtil;
import me.gosimple.nbvcxz.resources.Generator;
import me.gosimple.nbvcxz.scoring.Result;
import me.gosimple.nbvcxz.scoring.TimeEstimate;

public class Nbvcxz {
    private static StartIndexComparator comparator = new StartIndexComparator();
    private Configuration configuration;
    private final List<Match> best_matches = new ArrayList<Match>();
    private int best_matches_length = 0;

    public Nbvcxz() {
        this.configuration = new ConfigurationBuilder().createConfiguration();
    }

    public Nbvcxz(Configuration configuration) {
        this.configuration = configuration;
    }

    private Result guessEntropy(Configuration configuration, String password) {
        this.resetVariables();
        Result final_result = new Result(configuration, password, this.getBestCombination(configuration, password));
        return final_result;
    }

    private void resetVariables() {
        this.best_matches.clear();
        this.best_matches_length = 0;
    }

    private List<Match> getBestCombination(Configuration configuration, String password) {
        this.best_matches.clear();
        this.best_matches_length = 0;
        List<Match> all_matches = this.getAllMatches(configuration, password);
        HashMap<Integer, Match> brute_force_matches = new HashMap<Integer, Match>();
        for (int i = 0; i < password.length(); ++i) {
            brute_force_matches.put(i, Nbvcxz.createBruteForceMatch(password, configuration, i));
        }
        if (all_matches == null || all_matches.size() == 0 || this.isRandom(password, this.findGoodEnoughCombination(password, all_matches, brute_force_matches))) {
            ArrayList<Match> matches = new ArrayList<Match>();
            this.backfillBruteForce(password, brute_force_matches, matches);
            matches.sort(comparator);
            return matches;
        }
        Collections.sort(all_matches, comparator);
        return this.findBestCombination(password, all_matches, brute_force_matches);
    }

    private List<Match> findGoodEnoughCombination(String password, List<Match> all_matches, Map<Integer, Match> brute_force_matches) {
        int k;
        int length = password.length();
        Match[] match_at_index = new Match[length];
        ArrayList<Match> match_list = new ArrayList<Match>();
        for (k = 0; k < length; ++k) {
            for (Match match : all_matches) {
                if (match.getEndIndex() != k || match_at_index[k] != null && !(match_at_index[k].calculateEntropy() / (double)match_at_index[k].getLength() > match.calculateEntropy() / (double)match.getLength())) continue;
                match_at_index[k] = match;
            }
        }
        k = length - 1;
        while (k >= 0) {
            Match match = match_at_index[k];
            if (match == null) {
                match_list.add(brute_force_matches.get(k));
                --k;
                continue;
            }
            match_list.add(match);
            k = match.getStartIndex() - 1;
        }
        Collections.reverse(match_list);
        return match_list;
    }

    private List<Match> findBestCombination(String password, List<Match> all_matches, Map<Integer, Match> brute_force_matches) {
        HashMap<Match, List<Match>> non_intersecting_matches = new HashMap<Match, List<Match>>();
        for (int i = 0; i < all_matches.size(); ++i) {
            Match match = all_matches.get(i);
            ArrayList<Match> forward_non_intersecting_matches = new ArrayList<Match>();
            for (int n = i + 1; n < all_matches.size(); ++n) {
                Match next_match = all_matches.get(n);
                if (next_match.getStartIndex() <= match.getEndIndex() || next_match.getStartIndex() < match.getEndIndex() && match.getStartIndex() < next_match.getEndIndex()) continue;
                boolean to_add = true;
                for (Match non_intersecting_match : forward_non_intersecting_matches) {
                    if (next_match.getStartIndex() <= non_intersecting_match.getEndIndex()) continue;
                    to_add = false;
                    break;
                }
                if (!to_add) continue;
                forward_non_intersecting_matches.add(next_match);
            }
            forward_non_intersecting_matches.sort(comparator);
            non_intersecting_matches.put(match, forward_non_intersecting_matches);
        }
        ArrayList<Match> seed_matches = new ArrayList<Match>();
        for (Match match : all_matches) {
            boolean seed = true;
            for (List match_list : non_intersecting_matches.values()) {
                for (Match m : match_list) {
                    if (!m.equals(match)) continue;
                    seed = false;
                }
            }
            if (!seed) continue;
            seed_matches.add(match);
        }
        seed_matches.sort(comparator);
        for (Match match : seed_matches) {
            this.generateMatches(password, match, non_intersecting_matches, brute_force_matches, new ArrayList<Match>(), 0);
        }
        this.best_matches.sort(comparator);
        return this.best_matches;
    }

    private void generateMatches(String password, Match match, Map<Match, List<Match>> non_intersecting_matches, Map<Integer, Match> brute_force_matches, List<Match> matches, int matches_length) {
        int index = matches.size();
        matches.add(match);
        matches_length += match.getLength();
        boolean found_next = false;
        for (Match next_match : non_intersecting_matches.get(match)) {
            if (matches.size() > 1) {
                Match last_match = matches.get(matches.size() - 2);
                if (next_match.getStartIndex() < last_match.getEndIndex() && last_match.getStartIndex() < next_match.getEndIndex()) continue;
            }
            this.generateMatches(password, next_match, non_intersecting_matches, brute_force_matches, matches, matches_length);
            found_next = true;
        }
        if (!found_next && (this.best_matches.isEmpty() || matches_length >= this.best_matches_length && this.calcEntropy(matches, false) / (double)matches_length < this.calcEntropy(this.best_matches, false) / (double)this.best_matches_length)) {
            this.best_matches.clear();
            this.best_matches.addAll(matches);
            this.best_matches_length = matches_length;
            this.backfillBruteForce(password, brute_force_matches, this.best_matches);
        }
        matches.remove(index);
    }

    private boolean isRandom(String password, List<Match> matches) {
        int matched_length = 0;
        int max_matched_length = 0;
        for (Match match : matches) {
            if (match instanceof BruteForceMatch) continue;
            matched_length += match.getLength();
            if (match.getLength() <= max_matched_length) continue;
            max_matched_length = match.getLength();
        }
        if ((double)matched_length < (double)password.length() * 0.5) {
            return true;
        }
        return (double)matched_length < (double)password.length() * 0.8 && (double)password.length() * 0.25 > (double)max_matched_length;
    }

    private double calcEntropy(List<Match> matches, boolean include_brute_force) {
        double entropy = 0.0;
        for (Match match : matches) {
            if (!include_brute_force && match instanceof BruteForceMatch) continue;
            entropy += match.calculateEntropy();
        }
        return entropy;
    }

    private void backfillBruteForce(String password, Map<Integer, Match> brute_force_matches, List<Match> matches) {
        HashSet<Match> bf_matches = new HashSet<Match>();
        for (int index = 0; index < password.length(); ++index) {
            boolean has_match = false;
            for (Match match : matches) {
                if (index < match.getStartIndex() || index > match.getEndIndex()) continue;
                has_match = true;
            }
            if (has_match) continue;
            bf_matches.add(brute_force_matches.get(index));
        }
        matches.addAll(bf_matches);
    }

    private List<Match> getAllMatches(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (PasswordMatcher passwordMatcher : configuration.getPasswordMatchers()) {
            matches.addAll(passwordMatcher.match(configuration, password));
        }
        this.keepLowestMatches(matches);
        return matches;
    }

    private void keepLowestMatches(List<Match> matches) {
        HashSet<Match> to_remove = new HashSet<Match>();
        block0: for (Match match : matches) {
            for (Match to_compare : matches) {
                if (match.getStartIndex() != to_compare.getStartIndex() || match.getEndIndex() != to_compare.getEndIndex() || !(match.calculateEntropy() / (double)match.getLength() > to_compare.calculateEntropy() / (double)to_compare.getLength())) continue;
                to_remove.add(match);
                continue block0;
            }
        }
        matches.removeAll(to_remove);
    }

    private static Match createBruteForceMatch(String password, Configuration configuration, int index) {
        return new BruteForceMatch(password.charAt(index), configuration, index);
    }

    public static Double getEntropyFromGuesses(BigDecimal guesses) {
        Double guesses_tmp = guesses.doubleValue();
        guesses_tmp = guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp;
        return Math.log(guesses_tmp) / Math.log(2.0);
    }

    public static BigDecimal getGuessesFromEntropy(Double entropy) {
        Double guesses_tmp = Math.pow(2.0, entropy);
        return new BigDecimal(guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp).setScale(0, RoundingMode.HALF_UP);
    }

    public static void main(String ... args) {
        Configuration configuration = new ConfigurationBuilder().createConfiguration();
        Nbvcxz nbvcxz = new Nbvcxz(configuration);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.println(resourceBundle.getString("main.startPrompt"));
            System.out.println(resourceBundle.getString("main.enterCommand"));
            String input = scanner.nextLine();
            if ("q".equals(input)) break;
            if ("g".equals(input)) {
                System.out.println(resourceBundle.getString("main.generatorType"));
                input = scanner.nextLine();
                if ("p".equals(input)) {
                    System.out.println(resourceBundle.getString("main.delimiterPrompt"));
                    String delimiter = scanner.nextLine();
                    System.out.println(resourceBundle.getString("main.wordsPrompt"));
                    while (!scanner.hasNextInt()) {
                        scanner.next();
                    }
                    int words = scanner.nextInt();
                    scanner.nextLine();
                    Nbvcxz.printGenerationInfo(nbvcxz, Generator.generatePassphrase(delimiter, words));
                }
                if ("r".equals(input)) {
                    System.out.println(resourceBundle.getString("main.randomType"));
                    Generator.CharacterTypes characterTypes = null;
                    input = scanner.nextLine();
                    if ("1".equals(input)) {
                        characterTypes = Generator.CharacterTypes.ALPHA;
                    }
                    if ("2".equals(input)) {
                        characterTypes = Generator.CharacterTypes.ALPHANUMERIC;
                    }
                    if ("3".equals(input)) {
                        characterTypes = Generator.CharacterTypes.ALPHANUMERICSYMBOL;
                    }
                    if ("4".equals(input)) {
                        characterTypes = Generator.CharacterTypes.NUMERIC;
                    }
                    if (characterTypes == null) continue;
                    System.out.println(resourceBundle.getString("main.lengthPrompt"));
                    while (!scanner.hasNextInt()) {
                        scanner.next();
                    }
                    int length = scanner.nextInt();
                    scanner.nextLine();
                    Nbvcxz.printGenerationInfo(nbvcxz, Generator.generateRandomPassword(characterTypes, length));
                }
            }
            if (!"e".equals(input)) continue;
            System.out.println(resourceBundle.getString("main.estimatePrompt"));
            String password = scanner.nextLine();
            Nbvcxz.printEstimationInfo(nbvcxz, password);
        }
        System.out.println(resourceBundle.getString("main.quitPrompt") + " ");
    }

    private static void printGenerationInfo(Nbvcxz nbvcxz, String password) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        System.out.println("----------------------------------------------------------");
        System.out.println(resourceBundle.getString("main.password") + " " + password);
        System.out.println("----------------------------------------------------------");
    }

    private static void printEstimationInfo(Nbvcxz nbvcxz, String password) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("main", nbvcxz.getConfiguration().getLocale());
        long start = System.currentTimeMillis();
        Result result = nbvcxz.estimate(password);
        long end = System.currentTimeMillis();
        System.out.println("----------------------------------------------------------");
        System.out.println(resourceBundle.getString("main.timeToCalculate") + " " + (end - start) + " ms");
        System.out.println(resourceBundle.getString("main.password") + " " + password);
        System.out.println(resourceBundle.getString("main.entropy") + " " + result.getEntropy());
        Feedback feedback = FeedbackUtil.getFeedback(result);
        if (feedback.getWarning() != null) {
            System.out.println(resourceBundle.getString("main.feedback.warning") + " " + feedback.getWarning());
        }
        for (String suggestion : feedback.getSuggestion()) {
            System.out.println(resourceBundle.getString("main.feedback.suggestion") + " " + suggestion);
        }
        Map sortedMap = result.getConfiguration().getGuessTypes().entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        for (Map.Entry guessType : sortedMap.entrySet()) {
            System.out.println(resourceBundle.getString("main.timeToCrack") + " " + (String)guessType.getKey() + ": " + TimeEstimate.getTimeToCrackFormatted(result, (String)guessType.getKey()));
        }
        for (Match match : result.getMatches()) {
            System.out.println("-----------------------------------");
            System.out.println(match.getDetails());
        }
        System.out.println("----------------------------------------------------------");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Result estimate(String password) {
        return this.guessEntropy(this.configuration, password);
    }

    private static class StartIndexComparator
    implements Comparator<Match> {
        private StartIndexComparator() {
        }

        @Override
        public int compare(Match match_1, Match match_2) {
            if (match_1.getStartIndex() < match_2.getStartIndex()) {
                return -1;
            }
            if (match_1.getStartIndex() > match_2.getStartIndex()) {
                return 1;
            }
            if (match_1.getStartIndex() == match_2.getStartIndex()) {
                if (match_1.getToken().length() < match_2.getToken().length()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

