/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.DictionaryMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;

public final class DictionaryMatcher
implements PasswordMatcher {
    private static String translateLeet(Configuration configuration, String password) {
        char[] array = new char[password.length()];
        for (int i = 0; i < password.length(); ++i) {
            Character replacement = configuration.getLeetTable().get(Character.valueOf(password.charAt(i)));
            array[i] = replacement != null ? replacement.charValue() : password.charAt(i);
        }
        return new String(array);
    }

    private static List<Character[]> getLeetSub(Configuration configuration, String password) {
        ArrayList<Character[]> leet_subs = new ArrayList<Character[]>();
        for (int i = 0; i < password.length(); ++i) {
            Character replacement = configuration.getLeetTable().get(Character.valueOf(password.charAt(i)));
            if (replacement == null) continue;
            leet_subs.add(new Character[]{Character.valueOf(password.charAt(i)), replacement});
        }
        return leet_subs;
    }

    private static int distance(CharSequence left, CharSequence right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = left.length();
        int m = right.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = left;
            left = right;
            right = tmp;
            n = m;
            m = right.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i = 0; i < boundary; ++i) {
            p[i] = i;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char rightJ = right.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > max) {
                return -1;
            }
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i = min; i <= max; ++i) {
                d[i] = left.charAt(i - 1) == rightJ ? p[i - 1] : 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
            }
            int[] tempD = p;
            p = d;
            d = tempD;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    @Override
    public List<Match> match(Configuration configuration, String password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (int start = 0; start < password.length(); ++start) {
            for (int end = start + 1; end <= password.length(); ++end) {
                String split_password = password.substring(start, end);
                for (Dictionary dictionary : configuration.getDictionaries()) {
                    if (dictionary.isExclusion() && (start != 0 || end != password.length())) continue;
                    Integer exact_rank = dictionary.getDictonary().get(split_password);
                    if (exact_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, split_password, exact_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), false, dictionary.getDictionaryName(), 0));
                        continue;
                    }
                    String lower_part = split_password.toLowerCase();
                    Integer lower_rank = dictionary.getDictonary().get(lower_part);
                    if (lower_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, lower_part, lower_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), false, dictionary.getDictionaryName(), 0));
                        continue;
                    }
                    String reversed_part = new StringBuilder(lower_part).reverse().toString();
                    Integer reversed_rank = dictionary.getDictonary().get(reversed_part);
                    if (reversed_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, reversed_part, reversed_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), true, dictionary.getDictionaryName(), 0));
                        continue;
                    }
                    List<Character[]> subs = DictionaryMatcher.getLeetSub(configuration, split_password);
                    String unleet_part = DictionaryMatcher.translateLeet(configuration, lower_part);
                    Integer unleet_rank = dictionary.getDictonary().get(unleet_part);
                    if (unleet_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, unleet_part, unleet_rank, subs, dictionary.isExclusion(), false, dictionary.getDictionaryName(), 0));
                        continue;
                    }
                    String reversed_unleet_part = new StringBuilder(unleet_part).reverse().toString();
                    Integer reversed_unleet_rank = dictionary.getDictonary().get(reversed_unleet_part);
                    if (reversed_unleet_rank != null) {
                        matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, reversed_unleet_part, reversed_unleet_rank, subs, dictionary.isExclusion(), true, dictionary.getDictionaryName(), 0));
                        continue;
                    }
                    if (!configuration.isDistanceCalc() || start != 0 || end != password.length() || password.length() < 3) continue;
                    int threshold = password.length() / 4;
                    int start_index = dictionary.getSortedDictionaryLengthLookup().containsKey(password.length() - threshold) ? dictionary.getSortedDictionaryLengthLookup().get(password.length() - threshold).intValue() : dictionary.getSortedDictionary().size();
                    int end_index = dictionary.getSortedDictionaryLengthLookup().containsKey(password.length() + threshold + 1) ? dictionary.getSortedDictionaryLengthLookup().get(password.length() + threshold + 1).intValue() : dictionary.getSortedDictionary().size();
                    int dist_min = Integer.MAX_VALUE;
                    String dist_val = null;
                    Integer dist_rank = null;
                    for (String key : dictionary.getSortedDictionary().subList(start_index, end_index)) {
                        int dist_curr = DictionaryMatcher.distance(password, key, threshold);
                        if (dist_curr == -1) continue;
                        Integer dist_curr_rank = dictionary.getDictonary().get(key);
                        if (dist_curr > dist_min || dist_rank != null && dist_curr_rank > dist_rank) continue;
                        dist_min = dist_curr;
                        dist_val = key;
                        dist_rank = dist_curr_rank;
                    }
                    if (dist_rank == null) continue;
                    matches.add(new DictionaryMatch(split_password, configuration, start, end - 1, dist_val, dist_rank, new ArrayList<Character[]>(), dictionary.isExclusion(), false, dictionary.getDictionaryName(), dist_min));
                }
            }
        }
        return matches;
    }
}

