/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.matching.DateMatcher;
import me.gosimple.nbvcxz.matching.DictionaryMatcher;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.RepeatMatcher;
import me.gosimple.nbvcxz.matching.SeparatorMatcher;
import me.gosimple.nbvcxz.matching.SequenceMatcher;
import me.gosimple.nbvcxz.matching.SpacialMatcher;
import me.gosimple.nbvcxz.matching.YearMatcher;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.AdjacencyGraphUtil;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.DictionaryUtil;

public class ConfigurationBuilder {
    private List<PasswordMatcher> passwordMatchers;
    private Map<String, Long> guessTypes;
    private List<Dictionary> dictionaries;
    private List<AdjacencyGraph> adjacencyGraphs;
    private Map<Character, Character> leetTable;
    private Pattern yearPattern;
    private Double minimumEntropy;
    private Locale locale;
    private Boolean distanceCalc;

    public static List<PasswordMatcher> getDefaultPasswordMatchers() {
        ArrayList<PasswordMatcher> passwordMatchers = new ArrayList<PasswordMatcher>();
        passwordMatchers.add(new DateMatcher());
        passwordMatchers.add(new YearMatcher());
        passwordMatchers.add(new RepeatMatcher());
        passwordMatchers.add(new SequenceMatcher());
        passwordMatchers.add(new SpacialMatcher());
        passwordMatchers.add(new DictionaryMatcher());
        passwordMatchers.add(new SeparatorMatcher());
        return passwordMatchers;
    }

    public static Map<String, Long> getDefaultGuessTypes() {
        HashMap<String, Long> guessTypes = new HashMap<String, Long>();
        guessTypes.put("OFFLINE_MD5", 115840000000L);
        guessTypes.put("OFFLINE_SHA1", 37336000000L);
        guessTypes.put("OFFLINE_SHA512", 5000000000L);
        guessTypes.put("OFFLINE_BCRYPT_5", 64000L);
        guessTypes.put("OFFLINE_BCRYPT_10", 2000L);
        guessTypes.put("OFFLINE_BCRYPT_12", 500L);
        guessTypes.put("OFFLINE_BCRYPT_14", 125L);
        guessTypes.put("ONLINE_UNTHROTTLED", 100L);
        guessTypes.put("ONLINE_THROTTLED", 2L);
        return guessTypes;
    }

    public static List<Dictionary> getDefaultDictionaries() {
        ArrayList<Dictionary> tmpDictionaries = new ArrayList<Dictionary>();
        tmpDictionaries.add(new Dictionary("passwords", DictionaryUtil.loadRankedDictionary("passwords.txt"), false));
        tmpDictionaries.add(new Dictionary("male_names", DictionaryUtil.loadRankedDictionary("male-names.txt"), false));
        tmpDictionaries.add(new Dictionary("female_names", DictionaryUtil.loadRankedDictionary("female-names.txt"), false));
        tmpDictionaries.add(new Dictionary("surnames", DictionaryUtil.loadRankedDictionary("surnames.txt"), false));
        tmpDictionaries.add(new Dictionary("english", DictionaryUtil.loadRankedDictionary("english.txt"), false));
        tmpDictionaries.add(new Dictionary("eff_large", DictionaryUtil.loadUnrankedDictionary("eff_large.txt"), false));
        return tmpDictionaries;
    }

    public static List<AdjacencyGraph> getDefaultAdjacencyGraphs() {
        ArrayList<AdjacencyGraph> tmpAdjacencyGraphs = new ArrayList<AdjacencyGraph>();
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Qwerty", AdjacencyGraphUtil.qwerty));
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Standard Keypad", AdjacencyGraphUtil.standardKeypad));
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Mac Keypad", AdjacencyGraphUtil.macKeypad));
        return tmpAdjacencyGraphs;
    }

    public static Map<Character, Character> getDefaultLeetTable() {
        HashMap<Character, Character> tmpLeetTable = new HashMap<Character, Character>();
        tmpLeetTable.put(Character.valueOf('4'), Character.valueOf('a'));
        tmpLeetTable.put(Character.valueOf('@'), Character.valueOf('a'));
        tmpLeetTable.put(Character.valueOf('8'), Character.valueOf('b'));
        tmpLeetTable.put(Character.valueOf('('), Character.valueOf('c'));
        tmpLeetTable.put(Character.valueOf('{'), Character.valueOf('c'));
        tmpLeetTable.put(Character.valueOf('['), Character.valueOf('c'));
        tmpLeetTable.put(Character.valueOf('<'), Character.valueOf('c'));
        tmpLeetTable.put(Character.valueOf('3'), Character.valueOf('e'));
        tmpLeetTable.put(Character.valueOf('9'), Character.valueOf('g'));
        tmpLeetTable.put(Character.valueOf('6'), Character.valueOf('g'));
        tmpLeetTable.put(Character.valueOf('!'), Character.valueOf('i'));
        tmpLeetTable.put(Character.valueOf('1'), Character.valueOf('l'));
        tmpLeetTable.put(Character.valueOf('|'), Character.valueOf('l'));
        tmpLeetTable.put(Character.valueOf('0'), Character.valueOf('o'));
        tmpLeetTable.put(Character.valueOf('$'), Character.valueOf('s'));
        tmpLeetTable.put(Character.valueOf('5'), Character.valueOf('s'));
        tmpLeetTable.put(Character.valueOf('+'), Character.valueOf('t'));
        tmpLeetTable.put(Character.valueOf('7'), Character.valueOf('t'));
        tmpLeetTable.put(Character.valueOf('%'), Character.valueOf('x'));
        tmpLeetTable.put(Character.valueOf('2'), Character.valueOf('z'));
        return tmpLeetTable;
    }

    public static Pattern getDefaultYearPattern() {
        return Pattern.compile("19\\d\\d|200\\d|201\\d|202\\d");
    }

    public static double getDefaultMinimumEntropy() {
        return 35.0;
    }

    public static Boolean getDefaultDistanceCalc() {
        return true;
    }

    public ConfigurationBuilder setPasswordMatchers(List<PasswordMatcher> passwordMatchers) {
        this.passwordMatchers = passwordMatchers;
        return this;
    }

    public ConfigurationBuilder setGuessTypes(Map<String, Long> guessTypes) {
        this.guessTypes = guessTypes;
        return this;
    }

    public ConfigurationBuilder setDictionaries(List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
        return this;
    }

    public ConfigurationBuilder setAdjacencyGraphs(List<AdjacencyGraph> adjacencyGraphs) {
        this.adjacencyGraphs = adjacencyGraphs;
        return this;
    }

    public ConfigurationBuilder setLeetTable(Map<Character, Character> leetTable) {
        this.leetTable = leetTable;
        return this;
    }

    public ConfigurationBuilder setYearPattern(Pattern yearPattern) {
        this.yearPattern = yearPattern;
        return this;
    }

    public ConfigurationBuilder setMinimumEntropy(Double minimumEntropy) {
        this.minimumEntropy = minimumEntropy;
        return this;
    }

    public ConfigurationBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ConfigurationBuilder setDistanceCalc(Boolean distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    public Configuration createConfiguration() {
        if (this.passwordMatchers == null) {
            this.passwordMatchers = ConfigurationBuilder.getDefaultPasswordMatchers();
        }
        if (this.guessTypes == null) {
            this.guessTypes = ConfigurationBuilder.getDefaultGuessTypes();
        }
        if (this.dictionaries == null) {
            this.dictionaries = ConfigurationBuilder.getDefaultDictionaries();
        }
        if (this.adjacencyGraphs == null) {
            this.adjacencyGraphs = ConfigurationBuilder.getDefaultAdjacencyGraphs();
        }
        if (this.leetTable == null) {
            this.leetTable = ConfigurationBuilder.getDefaultLeetTable();
        }
        if (this.yearPattern == null) {
            this.yearPattern = ConfigurationBuilder.getDefaultYearPattern();
        }
        if (this.minimumEntropy == null) {
            this.minimumEntropy = ConfigurationBuilder.getDefaultMinimumEntropy();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.distanceCalc == null) {
            this.distanceCalc = ConfigurationBuilder.getDefaultDistanceCalc();
        }
        return new Configuration(this.passwordMatchers, this.guessTypes, this.dictionaries, this.adjacencyGraphs, this.leetTable, this.yearPattern, this.minimumEntropy, this.locale, this.distanceCalc);
    }
}

