/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.List;
import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.BruteForceUtil;
import me.gosimple.nbvcxz.resources.Configuration;

public final class DictionaryMatch
extends BaseMatch {
    private final String dictionary_name;
    private final String dictionary_value;
    private final int rank;
    private final boolean excluded;
    private final List<Character[]> leetSubstitution;
    private final boolean reversed;
    private final int distance;

    public DictionaryMatch(String match, Configuration configuration, int start_index, int end_index, String dictionary_value, int rank, List<Character[]> leetSubstitution, boolean excluded, boolean reversed, String dictionary_name, int distance) {
        super(match, configuration, start_index, end_index);
        this.dictionary_value = dictionary_value;
        this.rank = rank;
        this.leetSubstitution = leetSubstitution;
        this.excluded = excluded;
        this.dictionary_name = dictionary_name;
        this.reversed = reversed;
        this.distance = distance;
        super.setEntropy(this.getEntropy());
    }

    private double getEntropy() {
        if (this.excluded) {
            return 0.0;
        }
        return DictionaryMatch.log2(this.rank) + this.uppercaseEntropy() + this.leetEntropy() + this.reversedEntropy() + this.distanceEntropy();
    }

    private double distanceEntropy() {
        int char_shift;
        if (this.getDistance() == 0) {
            return 0.0;
        }
        int len_diff = this.getToken().length() - this.getDictionaryValue().length();
        if (len_diff + (char_shift = this.getDistance() - Math.abs(len_diff)) <= 0) {
            return 1.0;
        }
        return DictionaryMatch.log2(BruteForceUtil.getBrutForceCardinality(this.getToken()) * (len_diff + char_shift));
    }

    /*
     * WARNING - void declaration
     */
    private double uppercaseEntropy() {
        void var9_14;
        String password = this.getToken();
        char[] password_array = password.toCharArray();
        if (password.toLowerCase().equals(password)) {
            return 0.0;
        }
        if (password.toUpperCase().equals(password)) {
            return 1.0;
        }
        String first_upper = password.substring(1);
        if (Character.isUpperCase(password_array[0]) && first_upper.toLowerCase().equals(first_upper)) {
            return 1.0;
        }
        String last_upper = password.substring(0, password.length() - 2);
        if (Character.isUpperCase(password_array[password.length() - 1]) && last_upper.toLowerCase().equals(last_upper)) {
            return 1.0;
        }
        int upperCount = 0;
        for (char c : password_array) {
            if (!Character.isUpperCase(c)) continue;
            ++upperCount;
        }
        int lowerCount = 0;
        char[] cArray = password_array;
        int n = cArray.length;
        boolean bl = false;
        while (var9_14 < n) {
            char c = cArray[var9_14];
            if (Character.isLowerCase(c)) {
                ++lowerCount;
            }
            ++var9_14;
        }
        int possiblities = 0;
        int totalCase = upperCount + lowerCount;
        int n2 = Math.min(upperCount, lowerCount);
        for (int i = 0; i <= n2; ++i) {
            possiblities = (int)((long)possiblities + DictionaryMatch.nCk(totalCase, i));
        }
        return Math.max(DictionaryMatch.log2(possiblities), 1.0);
    }

    private double leetEntropy() {
        if (!this.isLeet()) {
            return 0.0;
        }
        int possibilities = 0;
        for (Character[] sub : this.leetSubstitution) {
            char original = sub[0].charValue();
            char newChar = sub[1].charValue();
            int substitutionCount = 0;
            int unSubstitutionCount = 0;
            for (char c : this.getToken().toCharArray()) {
                if (c == newChar) {
                    ++substitutionCount;
                }
                if (c != original) continue;
                ++unSubstitutionCount;
            }
            int totalSub = substitutionCount + unSubstitutionCount;
            int minSub = Math.min(substitutionCount, unSubstitutionCount);
            for (int i = 0; i <= minSub; ++i) {
                possibilities = (int)((long)possibilities + DictionaryMatch.nCk(totalSub, i));
            }
        }
        return Math.max(1.0, DictionaryMatch.log2(possibilities));
    }

    private double reversedEntropy() {
        if (this.isReversed()) {
            return 1.0;
        }
        return 0.0;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isLeet() {
        return this.leetSubstitution.size() > 0;
    }

    public String getDictionaryName() {
        return this.dictionary_name;
    }

    public List<Character[]> getLeetSubstitution() {
        return this.leetSubstitution;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public int getDistance() {
        return this.distance;
    }

    public String getDictionaryValue() {
        return this.dictionary_value;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.dictionary")).append(" ").append(this.getDictionaryName());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.dictionaryValue")).append(" ").append(this.getDictionaryValue());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.rank")).append(" ").append(this.getRank());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.length")).append(" ").append(this.getLength());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.leetSub")).append(" ").append(this.isLeet());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.reversed")).append(" ").append(this.isReversed());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.distance")).append(" ").append(this.getDistance());
        return detailBuilder.toString();
    }
}

