/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.BruteForceUtil;
import me.gosimple.nbvcxz.resources.Configuration;

public final class RepeatMatch
extends BaseMatch {
    private final String repeatingCharacters;
    private final int repeat;

    public RepeatMatch(String match, Configuration configuration, String repeatingCharacters, int start_index, int end_index) {
        super(match, configuration, start_index, end_index);
        this.repeatingCharacters = repeatingCharacters;
        this.repeat = match.length() / repeatingCharacters.length();
        super.setEntropy(this.getEntropy());
    }

    private double getEntropy() {
        int cardinality = BruteForceUtil.getBrutForceCardinality(this.getRepeatingCharacters());
        if (this.getRepeat() != this.getRepeatingCharacters().length()) {
            return Math.max(0.0, RepeatMatch.log2(cardinality * this.getRepeat() * this.getRepeatingCharacters().length()));
        }
        return Math.max(0.0, RepeatMatch.log2(cardinality * this.getRepeat()));
    }

    public String getRepeatingCharacters() {
        return this.repeatingCharacters;
    }

    public int getRepeat() {
        return this.repeat;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.repeatingCharacters")).append(" ").append(this.getRepeatingCharacters());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.repeated")).append(" ").append(this.getRepeat());
        return detailBuilder.toString();
    }
}

