/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching.match;

import java.util.ResourceBundle;
import me.gosimple.nbvcxz.matching.match.BaseMatch;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.Configuration;

public final class SpacialMatch
extends BaseMatch {
    private final AdjacencyGraph adjacencyGraph;
    private final int turns;
    private final int shiftedCount;

    public SpacialMatch(String match, Configuration configuration, int start_index, int end_index, AdjacencyGraph adjacencyGraph, int turns, int shiftedNumber) {
        super(match, configuration, start_index, end_index);
        this.adjacencyGraph = adjacencyGraph;
        this.turns = turns;
        this.shiftedCount = shiftedNumber;
        super.setEntropy(this.getEntropy());
    }

    private double getEntropy() {
        int size = this.adjacencyGraph.getKeyMap().size();
        double avgDegree = this.adjacencyGraph.getAverageDegree();
        double entropy = 0.0;
        long possibilities = 0L;
        int length = this.getToken().length();
        for (int i = 2; i <= length; ++i) {
            int possibleTurns = Math.min(this.turns, i - 1);
            for (int j = 1; j <= possibleTurns; ++j) {
                possibilities = (long)((double)possibilities + (double)(SpacialMatch.nCk(i - 1, j - 1) * (long)size) * Math.pow(avgDegree, j));
            }
        }
        entropy += Math.max(0.0, SpacialMatch.log2(possibilities));
        possibilities = 0L;
        if (this.shiftedCount > 0) {
            int unshiftedCount = length - this.shiftedCount;
            int min = Math.min(this.shiftedCount, unshiftedCount);
            for (int i = 0; i <= min; ++i) {
                possibilities += SpacialMatch.nCk(length, i);
            }
        }
        return entropy += Math.max(0.0, SpacialMatch.log2(possibilities));
    }

    public AdjacencyGraph getAdjacencyGraph() {
        return this.adjacencyGraph;
    }

    public int getTurns() {
        return this.turns;
    }

    public int getShiftedNumber() {
        return this.shiftedCount;
    }

    @Override
    public String getDetails() {
        ResourceBundle mainResource = this.configuration.getMainResource();
        StringBuilder detailBuilder = new StringBuilder();
        detailBuilder.append(super.getDetails());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.spacialType")).append(" ").append(this.getAdjacencyGraph().getName());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.turns")).append(" ").append(this.getTurns());
        detailBuilder.append("\n");
        detailBuilder.append(mainResource.getString("main.match.shifts")).append(" ").append(this.getShiftedNumber());
        return detailBuilder.toString();
    }
}

