/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.matching.DateMatcher;
import me.gosimple.nbvcxz.matching.DictionaryMatcher;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.RepeatMatcher;
import me.gosimple.nbvcxz.matching.SeparatorMatcher;
import me.gosimple.nbvcxz.matching.SequenceMatcher;
import me.gosimple.nbvcxz.matching.SpacialMatcher;
import me.gosimple.nbvcxz.matching.YearMatcher;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.AdjacencyGraphUtil;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.DictionaryUtil;

public class ConfigurationBuilder {
    private static final double YEAR = 3.1556926079999996E10;
    private static final long START = 1533096000000L;
    private List<PasswordMatcher> passwordMatchers;
    private Map<String, Long> guessTypes;
    private List<Dictionary> dictionaries;
    private List<AdjacencyGraph> adjacencyGraphs;
    private Map<Character, Character[]> leetTable;
    private Pattern yearPattern;
    private Double minimumEntropy;
    private Locale locale;
    private Boolean distanceCalc;
    private Long combinationAlgorithmTimeout;

    public static List<PasswordMatcher> getDefaultPasswordMatchers() {
        ArrayList<PasswordMatcher> passwordMatchers = new ArrayList<PasswordMatcher>();
        passwordMatchers.add(new DateMatcher());
        passwordMatchers.add(new YearMatcher());
        passwordMatchers.add(new RepeatMatcher());
        passwordMatchers.add(new SequenceMatcher());
        passwordMatchers.add(new SpacialMatcher());
        passwordMatchers.add(new DictionaryMatcher());
        passwordMatchers.add(new SeparatorMatcher());
        return passwordMatchers;
    }

    public static BigDecimal getMooresMultiplier() {
        double years = (double)(System.currentTimeMillis() - 1533096000000L) / 3.1556926079999996E10;
        if (years <= 1.0) {
            years = 0.0;
        }
        return BigDecimal.valueOf(Math.pow(2.0, years / 2.0));
    }

    public static Map<String, Long> getDefaultGuessTypes() {
        BigDecimal moores_multiplier = ConfigurationBuilder.getMooresMultiplier();
        HashMap<String, Long> guessTypes = new HashMap<String, Long>();
        guessTypes.put("OFFLINE_MD5", moores_multiplier.multiply(BigDecimal.valueOf(250375000000L)).longValue());
        guessTypes.put("OFFLINE_SHA1", moores_multiplier.multiply(BigDecimal.valueOf(85963750000L)).longValue());
        guessTypes.put("OFFLINE_SHA512", moores_multiplier.multiply(BigDecimal.valueOf(10780875000L)).longValue());
        guessTypes.put("OFFLINE_BCRYPT_5", moores_multiplier.multiply(BigDecimal.valueOf(130875L)).longValue());
        guessTypes.put("OFFLINE_BCRYPT_10", moores_multiplier.multiply(BigDecimal.valueOf(4129L)).longValue());
        guessTypes.put("OFFLINE_BCRYPT_12", moores_multiplier.multiply(BigDecimal.valueOf(1033L)).longValue());
        guessTypes.put("OFFLINE_BCRYPT_14", moores_multiplier.multiply(BigDecimal.valueOf(259L)).longValue());
        guessTypes.put("ONLINE_UNTHROTTLED", 100L);
        guessTypes.put("ONLINE_THROTTLED", 2L);
        return guessTypes;
    }

    public static List<Dictionary> getDefaultDictionaries() {
        ArrayList<Dictionary> tmpDictionaries = new ArrayList<Dictionary>();
        tmpDictionaries.add(new Dictionary("passwords", DictionaryUtil.loadRankedDictionary("passwords.txt"), false));
        tmpDictionaries.add(new Dictionary("male_names", DictionaryUtil.loadRankedDictionary("male-names.txt"), false));
        tmpDictionaries.add(new Dictionary("female_names", DictionaryUtil.loadRankedDictionary("female-names.txt"), false));
        tmpDictionaries.add(new Dictionary("surnames", DictionaryUtil.loadRankedDictionary("surnames.txt"), false));
        tmpDictionaries.add(new Dictionary("english", DictionaryUtil.loadRankedDictionary("english.txt"), false));
        tmpDictionaries.add(new Dictionary("eff_large", DictionaryUtil.loadUnrankedDictionary("eff_large.txt"), false));
        return tmpDictionaries;
    }

    public static List<AdjacencyGraph> getDefaultAdjacencyGraphs() {
        ArrayList<AdjacencyGraph> tmpAdjacencyGraphs = new ArrayList<AdjacencyGraph>();
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Qwerty", AdjacencyGraphUtil.qwerty));
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Standard Keypad", AdjacencyGraphUtil.standardKeypad));
        tmpAdjacencyGraphs.add(new AdjacencyGraph("Mac Keypad", AdjacencyGraphUtil.macKeypad));
        return tmpAdjacencyGraphs;
    }

    public static Map<Character, Character[]> getDefaultLeetTable() {
        HashMap<Character, Character[]> tmpLeetTable = new HashMap<Character, Character[]>();
        tmpLeetTable.put(Character.valueOf('4'), new Character[]{Character.valueOf('a')});
        tmpLeetTable.put(Character.valueOf('@'), new Character[]{Character.valueOf('a')});
        tmpLeetTable.put(Character.valueOf('8'), new Character[]{Character.valueOf('b')});
        tmpLeetTable.put(Character.valueOf('('), new Character[]{Character.valueOf('c')});
        tmpLeetTable.put(Character.valueOf('{'), new Character[]{Character.valueOf('c')});
        tmpLeetTable.put(Character.valueOf('['), new Character[]{Character.valueOf('c')});
        tmpLeetTable.put(Character.valueOf('<'), new Character[]{Character.valueOf('c')});
        tmpLeetTable.put(Character.valueOf('3'), new Character[]{Character.valueOf('e')});
        tmpLeetTable.put(Character.valueOf('9'), new Character[]{Character.valueOf('g')});
        tmpLeetTable.put(Character.valueOf('6'), new Character[]{Character.valueOf('g')});
        tmpLeetTable.put(Character.valueOf('&'), new Character[]{Character.valueOf('g')});
        tmpLeetTable.put(Character.valueOf('#'), new Character[]{Character.valueOf('h')});
        tmpLeetTable.put(Character.valueOf('!'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        tmpLeetTable.put(Character.valueOf('1'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        tmpLeetTable.put(Character.valueOf('|'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        tmpLeetTable.put(Character.valueOf('0'), new Character[]{Character.valueOf('o')});
        tmpLeetTable.put(Character.valueOf('$'), new Character[]{Character.valueOf('s')});
        tmpLeetTable.put(Character.valueOf('5'), new Character[]{Character.valueOf('s')});
        tmpLeetTable.put(Character.valueOf('+'), new Character[]{Character.valueOf('t')});
        tmpLeetTable.put(Character.valueOf('7'), new Character[]{Character.valueOf('t'), Character.valueOf('l')});
        tmpLeetTable.put(Character.valueOf('%'), new Character[]{Character.valueOf('x')});
        tmpLeetTable.put(Character.valueOf('2'), new Character[]{Character.valueOf('z')});
        return tmpLeetTable;
    }

    public static Pattern getDefaultYearPattern() {
        return Pattern.compile("19\\d\\d|200\\d|201\\d|202\\d");
    }

    public static double getDefaultMinimumEntropy() {
        return 35.0;
    }

    public static Boolean getDefaultDistanceCalc() {
        return true;
    }

    public static long getDefaultCombinationAlgorithmTimeout() {
        return 500L;
    }

    public ConfigurationBuilder setPasswordMatchers(List<PasswordMatcher> passwordMatchers) {
        this.passwordMatchers = passwordMatchers;
        return this;
    }

    public ConfigurationBuilder setGuessTypes(Map<String, Long> guessTypes) {
        this.guessTypes = guessTypes;
        return this;
    }

    public ConfigurationBuilder setDictionaries(List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
        return this;
    }

    public ConfigurationBuilder setAdjacencyGraphs(List<AdjacencyGraph> adjacencyGraphs) {
        this.adjacencyGraphs = adjacencyGraphs;
        return this;
    }

    public ConfigurationBuilder setLeetTable(Map<Character, Character[]> leetTable) {
        this.leetTable = leetTable;
        return this;
    }

    public ConfigurationBuilder setYearPattern(Pattern yearPattern) {
        this.yearPattern = yearPattern;
        return this;
    }

    public ConfigurationBuilder setMinimumEntropy(Double minimumEntropy) {
        this.minimumEntropy = minimumEntropy;
        return this;
    }

    public ConfigurationBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ConfigurationBuilder setDistanceCalc(Boolean distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    public ConfigurationBuilder setCombinationAlgorithmTimeout(Long combinationAlgorithmTimeout) {
        this.combinationAlgorithmTimeout = combinationAlgorithmTimeout;
        return this;
    }

    public Configuration createConfiguration() {
        if (this.passwordMatchers == null) {
            this.passwordMatchers = ConfigurationBuilder.getDefaultPasswordMatchers();
        }
        if (this.guessTypes == null) {
            this.guessTypes = ConfigurationBuilder.getDefaultGuessTypes();
        }
        if (this.dictionaries == null) {
            this.dictionaries = ConfigurationBuilder.getDefaultDictionaries();
        }
        if (this.adjacencyGraphs == null) {
            this.adjacencyGraphs = ConfigurationBuilder.getDefaultAdjacencyGraphs();
        }
        if (this.leetTable == null) {
            this.leetTable = ConfigurationBuilder.getDefaultLeetTable();
        }
        if (this.yearPattern == null) {
            this.yearPattern = ConfigurationBuilder.getDefaultYearPattern();
        }
        if (this.minimumEntropy == null) {
            this.minimumEntropy = ConfigurationBuilder.getDefaultMinimumEntropy();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.distanceCalc == null) {
            this.distanceCalc = ConfigurationBuilder.getDefaultDistanceCalc();
        }
        if (this.combinationAlgorithmTimeout == null) {
            this.combinationAlgorithmTimeout = ConfigurationBuilder.getDefaultCombinationAlgorithmTimeout();
        }
        return new Configuration(this.passwordMatchers, this.guessTypes, this.dictionaries, this.adjacencyGraphs, this.leetTable, this.yearPattern, this.minimumEntropy, this.locale, this.distanceCalc, this.combinationAlgorithmTimeout);
    }
}

