/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.security.SecureRandom;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.DictionaryUtil;

public class Generator {
    public static String generatePassphrase(String delimiter, int words) {
        return Generator.generatePassphrase(delimiter, words, new Dictionary("eff_large", DictionaryUtil.loadUnrankedDictionary("eff_large.txt"), false));
    }

    public static String generatePassphrase(String delimiter, int words, Dictionary dictionary) {
        String result = "";
        SecureRandom rnd = new SecureRandom();
        int high = dictionary.getSortedDictionary().size();
        for (int i = 1; i <= words; ++i) {
            result = result + dictionary.getSortedDictionary().get(rnd.nextInt(high));
            if (i >= words) continue;
            result = result + delimiter;
        }
        return result;
    }

    public static String generateRandomPassword(CharacterTypes characterTypes, int length) {
        StringBuffer buffer = new StringBuffer();
        String characters = "";
        switch (characterTypes) {
            case ALPHA: {
                characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                break;
            }
            case ALPHANUMERIC: {
                characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                break;
            }
            case ALPHANUMERICSYMBOL: {
                characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()";
                break;
            }
            case NUMERIC: {
                characters = "1234567890";
            }
        }
        int charactersLength = characters.length();
        SecureRandom rnd = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            double index = rnd.nextInt(charactersLength);
            buffer.append(characters.charAt((int)index));
        }
        return buffer.toString();
    }

    public static enum CharacterTypes {
        ALPHA,
        ALPHANUMERIC,
        ALPHANUMERICSYMBOL,
        NUMERIC;

    }
}

