/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.Nbvcxz;
import me.gosimple.nbvcxz.matching.DateMatcher;
import me.gosimple.nbvcxz.matching.DictionaryMatcher;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.RepeatMatcher;
import me.gosimple.nbvcxz.matching.SeparatorMatcher;
import me.gosimple.nbvcxz.matching.SequenceMatcher;
import me.gosimple.nbvcxz.matching.SpacialMatcher;
import me.gosimple.nbvcxz.matching.YearMatcher;
import me.gosimple.nbvcxz.resources.AdjacencyGraph;
import me.gosimple.nbvcxz.resources.AdjacencyGraphUtil;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Dictionary;
import me.gosimple.nbvcxz.resources.DictionaryUtil;

public class ConfigurationBuilder {
    private static final double YEAR = 3.1556926079999996E10;
    private static final long START = 1596254400000L;
    private static final List<Dictionary> defaultDictionaries = new ArrayList<Dictionary>();
    private static final List<PasswordMatcher> defaultPasswordMatchers = new ArrayList<PasswordMatcher>();
    private static final List<AdjacencyGraph> defaultAdjacencyGraphs = new ArrayList<AdjacencyGraph>();
    private static final Map<Character, Character[]> defaultLeetTable = new HashMap<Character, Character[]>();
    private List<PasswordMatcher> passwordMatchers;
    private Map<String, Long> guessTypes;
    private List<Dictionary> dictionaries;
    private List<AdjacencyGraph> adjacencyGraphs;
    private Map<Character, Character[]> leetTable;
    private Pattern yearPattern;
    private Double minimumEntropy;
    private Locale locale;
    private Boolean distanceCalc;
    private Long combinationAlgorithmTimeout;
    private Long crackingHardwareCost;

    public static List<PasswordMatcher> getDefaultPasswordMatchers() {
        return defaultPasswordMatchers;
    }

    public static BigDecimal getMooresMultiplier() {
        double years = (double)(System.currentTimeMillis() - 1596254400000L) / 3.1556926079999996E10;
        if (years <= 1.0) {
            years = 0.0;
        }
        return BigDecimal.valueOf(Math.pow(2.0, years / 2.0));
    }

    public static Map<String, Long> getDefaultGuessTypes(Long crackingHardwareCost) {
        BigDecimal moores_multiplier = ConfigurationBuilder.getMooresMultiplier();
        BigDecimal cost_multiplier = BigDecimal.valueOf(crackingHardwareCost).divide(BigDecimal.valueOf(ConfigurationBuilder.getDefaultCrackingHardwareCost()), 5, RoundingMode.HALF_UP);
        HashMap<String, Long> guessTypes = new HashMap<String, Long>();
        guessTypes.put("OFFLINE_MD5", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(500750000000L))).longValue());
        guessTypes.put("OFFLINE_SHA1", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(171927500000L))).longValue());
        guessTypes.put("OFFLINE_SHA512", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(21561750000L))).longValue());
        guessTypes.put("OFFLINE_BCRYPT_5", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(1047000L))).longValue());
        guessTypes.put("OFFLINE_BCRYPT_8", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(132128L))).longValue());
        guessTypes.put("OFFLINE_BCRYPT_10", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(33032L))).longValue());
        guessTypes.put("OFFLINE_BCRYPT_12", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(8264L))).longValue());
        guessTypes.put("OFFLINE_BCRYPT_14", cost_multiplier.multiply(moores_multiplier.multiply(BigDecimal.valueOf(2072L))).longValue());
        guessTypes.put("ONLINE_UNTHROTTLED", 100L);
        guessTypes.put("ONLINE_THROTTLED", 2L);
        return guessTypes;
    }

    public static Map<String, Long> getDefaultGuessTypes() {
        return ConfigurationBuilder.getDefaultGuessTypes(ConfigurationBuilder.getDefaultCrackingHardwareCost());
    }

    public static List<Dictionary> getDefaultDictionaries() {
        return defaultDictionaries;
    }

    public static List<AdjacencyGraph> getDefaultAdjacencyGraphs() {
        return defaultAdjacencyGraphs;
    }

    public static Map<Character, Character[]> getDefaultLeetTable() {
        return defaultLeetTable;
    }

    public static Pattern getDefaultYearPattern() {
        return Pattern.compile("19\\d\\d|200\\d|201\\d|202\\d");
    }

    public static double getDefaultMinimumEntropy() {
        return 35.0;
    }

    public static Boolean getDefaultDistanceCalc() {
        return true;
    }

    public static long getDefaultCombinationAlgorithmTimeout() {
        return 500L;
    }

    public static long getDefaultCrackingHardwareCost() {
        return 20000L;
    }

    public ConfigurationBuilder setPasswordMatchers(List<PasswordMatcher> passwordMatchers) {
        this.passwordMatchers = passwordMatchers;
        return this;
    }

    public ConfigurationBuilder setGuessTypes(Map<String, Long> guessTypes) {
        this.guessTypes = guessTypes;
        return this;
    }

    public ConfigurationBuilder setDictionaries(List<Dictionary> dictionaries) {
        this.dictionaries = dictionaries;
        return this;
    }

    public ConfigurationBuilder setAdjacencyGraphs(List<AdjacencyGraph> adjacencyGraphs) {
        this.adjacencyGraphs = adjacencyGraphs;
        return this;
    }

    public ConfigurationBuilder setLeetTable(Map<Character, Character[]> leetTable) {
        this.leetTable = leetTable;
        return this;
    }

    public ConfigurationBuilder setYearPattern(Pattern yearPattern) {
        this.yearPattern = yearPattern;
        return this;
    }

    public ConfigurationBuilder setMinimumEntropy(Double minimumEntropy) {
        this.minimumEntropy = minimumEntropy;
        return this;
    }

    public ConfigurationBuilder setMinimumEntropy(BigDecimal seconds_to_crack, String guess_type) {
        BigDecimal guesses_per_second = this.guessTypes != null ? BigDecimal.valueOf(this.guessTypes.get(guess_type)) : BigDecimal.valueOf(ConfigurationBuilder.getDefaultGuessTypes(null != this.crackingHardwareCost ? this.crackingHardwareCost : ConfigurationBuilder.getDefaultCrackingHardwareCost()).get(guess_type));
        BigDecimal guesses = guesses_per_second.multiply(seconds_to_crack);
        this.minimumEntropy = Nbvcxz.getEntropyFromGuesses(guesses);
        return this;
    }

    public ConfigurationBuilder setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ConfigurationBuilder setDistanceCalc(Boolean distanceCalc) {
        this.distanceCalc = distanceCalc;
        return this;
    }

    public ConfigurationBuilder setCombinationAlgorithmTimeout(Long combinationAlgorithmTimeout) {
        this.combinationAlgorithmTimeout = combinationAlgorithmTimeout;
        return this;
    }

    public ConfigurationBuilder setCrackingHardwareCost(Long crackingHardwareCost) {
        this.crackingHardwareCost = crackingHardwareCost;
        return this;
    }

    public Configuration createConfiguration() {
        if (this.crackingHardwareCost == null) {
            this.crackingHardwareCost = ConfigurationBuilder.getDefaultCrackingHardwareCost();
        }
        if (this.passwordMatchers == null) {
            this.passwordMatchers = ConfigurationBuilder.getDefaultPasswordMatchers();
        }
        if (this.guessTypes == null) {
            this.guessTypes = ConfigurationBuilder.getDefaultGuessTypes(this.crackingHardwareCost);
        }
        if (this.dictionaries == null) {
            this.dictionaries = ConfigurationBuilder.getDefaultDictionaries();
        }
        if (this.adjacencyGraphs == null) {
            this.adjacencyGraphs = ConfigurationBuilder.getDefaultAdjacencyGraphs();
        }
        if (this.leetTable == null) {
            this.leetTable = ConfigurationBuilder.getDefaultLeetTable();
        }
        if (this.yearPattern == null) {
            this.yearPattern = ConfigurationBuilder.getDefaultYearPattern();
        }
        if (this.minimumEntropy == null) {
            this.minimumEntropy = ConfigurationBuilder.getDefaultMinimumEntropy();
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.distanceCalc == null) {
            this.distanceCalc = ConfigurationBuilder.getDefaultDistanceCalc();
        }
        if (this.combinationAlgorithmTimeout == null) {
            this.combinationAlgorithmTimeout = ConfigurationBuilder.getDefaultCombinationAlgorithmTimeout();
        }
        return new Configuration(this.passwordMatchers, this.guessTypes, this.dictionaries, this.adjacencyGraphs, this.leetTable, this.yearPattern, this.minimumEntropy, this.locale, this.distanceCalc, this.combinationAlgorithmTimeout);
    }

    static {
        defaultPasswordMatchers.add(new DateMatcher());
        defaultPasswordMatchers.add(new YearMatcher());
        defaultPasswordMatchers.add(new RepeatMatcher());
        defaultPasswordMatchers.add(new SequenceMatcher());
        defaultPasswordMatchers.add(new SpacialMatcher());
        defaultPasswordMatchers.add(new DictionaryMatcher());
        defaultPasswordMatchers.add(new SeparatorMatcher());
        defaultDictionaries.add(new Dictionary("passwords", DictionaryUtil.loadRankedDictionary("passwords.txt"), false));
        defaultDictionaries.add(new Dictionary("male_names", DictionaryUtil.loadRankedDictionary("male-names.txt"), false));
        defaultDictionaries.add(new Dictionary("female_names", DictionaryUtil.loadRankedDictionary("female-names.txt"), false));
        defaultDictionaries.add(new Dictionary("surnames", DictionaryUtil.loadRankedDictionary("surnames.txt"), false));
        defaultDictionaries.add(new Dictionary("english", DictionaryUtil.loadRankedDictionary("english.txt"), false));
        defaultDictionaries.add(new Dictionary("eff_large", DictionaryUtil.loadUnrankedDictionary("eff_large.txt"), false));
        defaultAdjacencyGraphs.add(new AdjacencyGraph("Qwerty", AdjacencyGraphUtil.qwerty));
        defaultAdjacencyGraphs.add(new AdjacencyGraph("Standard Keypad", AdjacencyGraphUtil.standardKeypad));
        defaultAdjacencyGraphs.add(new AdjacencyGraph("Mac Keypad", AdjacencyGraphUtil.macKeypad));
        defaultLeetTable.put(Character.valueOf('4'), new Character[]{Character.valueOf('a')});
        defaultLeetTable.put(Character.valueOf('@'), new Character[]{Character.valueOf('a')});
        defaultLeetTable.put(Character.valueOf('8'), new Character[]{Character.valueOf('b')});
        defaultLeetTable.put(Character.valueOf('('), new Character[]{Character.valueOf('c')});
        defaultLeetTable.put(Character.valueOf('{'), new Character[]{Character.valueOf('c')});
        defaultLeetTable.put(Character.valueOf('['), new Character[]{Character.valueOf('c')});
        defaultLeetTable.put(Character.valueOf('<'), new Character[]{Character.valueOf('c')});
        defaultLeetTable.put(Character.valueOf('3'), new Character[]{Character.valueOf('e')});
        defaultLeetTable.put(Character.valueOf('9'), new Character[]{Character.valueOf('g')});
        defaultLeetTable.put(Character.valueOf('6'), new Character[]{Character.valueOf('g')});
        defaultLeetTable.put(Character.valueOf('&'), new Character[]{Character.valueOf('g')});
        defaultLeetTable.put(Character.valueOf('#'), new Character[]{Character.valueOf('h')});
        defaultLeetTable.put(Character.valueOf('!'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        defaultLeetTable.put(Character.valueOf('1'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        defaultLeetTable.put(Character.valueOf('|'), new Character[]{Character.valueOf('i'), Character.valueOf('l')});
        defaultLeetTable.put(Character.valueOf('0'), new Character[]{Character.valueOf('o')});
        defaultLeetTable.put(Character.valueOf('$'), new Character[]{Character.valueOf('s')});
        defaultLeetTable.put(Character.valueOf('5'), new Character[]{Character.valueOf('s')});
        defaultLeetTable.put(Character.valueOf('+'), new Character[]{Character.valueOf('t')});
        defaultLeetTable.put(Character.valueOf('7'), new Character[]{Character.valueOf('t'), Character.valueOf('l')});
        defaultLeetTable.put(Character.valueOf('%'), new Character[]{Character.valueOf('x')});
        defaultLeetTable.put(Character.valueOf('2'), new Character[]{Character.valueOf('z')});
    }
}

