/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.gosimple.nbvcxz.resources.Configuration;

public class Feedback {
    private final String result;
    private final String warning;
    private final List<String> suggestions;
    private final Configuration configuration;

    public Feedback(Configuration configuration, String result) {
        this.configuration = configuration;
        this.result = result;
        this.warning = null;
        this.suggestions = new ArrayList<String>();
    }

    public Feedback(Configuration configuration, String result, String warning, String ... suggestions) {
        this.configuration = configuration;
        this.result = result;
        this.warning = warning;
        this.suggestions = new ArrayList<String>();
        Collections.addAll(this.suggestions, suggestions);
    }

    public String getResult() {
        return this.result;
    }

    public String getWarningKey() {
        return this.warning;
    }

    public String getWarning() {
        try {
            return this.configuration.getFeedbackResource().getString(this.warning);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<String> getSuggestionKeys() {
        return this.suggestions;
    }

    public List<String> getSuggestion() {
        ArrayList<String> convertedSuggestions = new ArrayList<String>();
        for (String suggestion : this.suggestions) {
            convertedSuggestions.add(this.configuration.getFeedbackResource().getString(suggestion));
        }
        return convertedSuggestions;
    }
}

