/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.matching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gosimple.nbvcxz.matching.PasswordMatcher;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.matching.match.SeparatorMatch;
import me.gosimple.nbvcxz.resources.Configuration;

public final class SeparatorMatcher
implements PasswordMatcher {
    private static final Pattern NON_ALPHA_NUMERIC = Pattern.compile("[^a-zA-Z\\d]");

    @Override
    public List<Match> match(Configuration configuration, String password) {
        Matcher matcher = NON_ALPHA_NUMERIC.matcher(password);
        ArrayList<Match> matches = new ArrayList<Match>();
        if (password.length() <= 5) {
            return matches;
        }
        ArrayList<String> occurrences = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.start() == 0 || matcher.end() == password.length() - 1) continue;
            occurrences.add(matcher.group());
        }
        int count = 0;
        String token = null;
        for (String new_token : new HashSet(occurrences)) {
            int new_count = Collections.frequency(occurrences, new_token);
            if (new_count <= count) continue;
            count = new_count;
            token = new_token;
        }
        matcher.reset();
        while (matcher.find()) {
            if (!matcher.group().equals(token) || matcher.start() == 0 || matcher.end() == password.length() - 1) continue;
            matches.add(new SeparatorMatch(matcher.group(), configuration, matcher.start(), matcher.end() - 1));
        }
        return matches;
    }
}

