/*
 * Decompiled with CFR 0.152.
 */
package me.gosimple.nbvcxz.scoring;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import me.gosimple.nbvcxz.matching.match.BruteForceMatch;
import me.gosimple.nbvcxz.matching.match.Match;
import me.gosimple.nbvcxz.resources.Configuration;
import me.gosimple.nbvcxz.resources.Feedback;
import me.gosimple.nbvcxz.resources.FeedbackUtil;

public class Result {
    final Configuration configuration;
    final String password;
    final String full_password;
    final List<Match> matches;

    public Result(Configuration configuration, String password, String full_password, List<Match> matches) throws IllegalStateException {
        this.configuration = configuration;
        this.password = password;
        this.full_password = full_password;
        this.matches = matches;
        if (!this.isValid()) {
            throw new IllegalStateException("There was an unexpected error and all of the matches put together do not equal the original password.");
        }
    }

    private boolean isValid() {
        StringBuilder builder = new StringBuilder();
        for (Match match : this.matches) {
            builder.append(match.getToken());
        }
        return this.password.equals(builder.toString());
    }

    public Double getEntropy() {
        double entropy = 0.0;
        for (Match match : this.matches) {
            entropy += match.calculateEntropy();
        }
        return entropy;
    }

    public BigDecimal getGuesses() {
        Double guesses_tmp = Math.pow(2.0, this.getEntropy());
        return BigDecimal.valueOf(guesses_tmp.isInfinite() ? Double.MAX_VALUE : guesses_tmp).setScale(0, RoundingMode.HALF_UP);
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFullPassword() {
        return this.full_password;
    }

    public boolean isTruncated() {
        return !this.password.equals(this.full_password);
    }

    public boolean isMinimumEntropyMet() {
        return this.getEntropy().compareTo(this.configuration.getMinimumEntropy()) >= 0;
    }

    public boolean isRandom() {
        boolean is_random = true;
        for (Match match : this.matches) {
            if (match instanceof BruteForceMatch) continue;
            is_random = false;
            break;
        }
        return is_random;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Feedback getFeedback() {
        return FeedbackUtil.getFeedback(this);
    }

    public int getBasicScore() {
        BigDecimal guesses = this.getGuesses();
        if (guesses.compareTo(BigDecimal.valueOf(1000.0)) == -1) {
            return 0;
        }
        if (guesses.compareTo(BigDecimal.valueOf(1000000.0)) == -1) {
            return 1;
        }
        if (guesses.compareTo(BigDecimal.valueOf(1.0E8)) == -1) {
            return 2;
        }
        if (guesses.compareTo(BigDecimal.valueOf(1.0E10)) == -1) {
            return 3;
        }
        return 4;
    }
}

