/*
 * Decompiled with CFR 0.152.
 */
package me.grantland.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.WeakHashMap;
import me.grantland.widget.AutofitHelper;
import me.grantland.widget.R;

public class AutofitLayout
extends FrameLayout {
    private boolean mEnabled;
    private float mMinTextSize;
    private float mPrecision;
    private WeakHashMap<View, AutofitHelper> mHelpers = new WeakHashMap();

    public AutofitLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public AutofitLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public AutofitLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        boolean sizeToFit = true;
        int minTextSize = -1;
        float precision = -1.0f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.AutofitTextView, defStyle, 0);
            sizeToFit = ta.getBoolean(R.styleable.AutofitTextView_sizeToFit, sizeToFit);
            minTextSize = ta.getDimensionPixelSize(R.styleable.AutofitTextView_minTextSize, minTextSize);
            precision = ta.getFloat(R.styleable.AutofitTextView_precision, precision);
            ta.recycle();
        }
        this.mEnabled = sizeToFit;
        this.mMinTextSize = minTextSize;
        this.mPrecision = precision;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        TextView textView = (TextView)child;
        AutofitHelper helper = AutofitHelper.create(textView).setEnabled(this.mEnabled);
        if (this.mPrecision > 0.0f) {
            helper.setPrecision(this.mPrecision);
        }
        if (this.mMinTextSize > 0.0f) {
            helper.setMinTextSize(0, this.mMinTextSize);
        }
        this.mHelpers.put((View)textView, helper);
    }

    public AutofitHelper getAutofitHelper(TextView textView) {
        return this.mHelpers.get(textView);
    }

    public AutofitHelper getAutofitHelper(int index) {
        return this.mHelpers.get(this.getChildAt(index));
    }
}

