/*
 * Decompiled with CFR 0.152.
 */
package me.grison.jtoml;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;

public class Util {

    public static class TomlFieldComparator
    implements Comparator<Field> {
        List<Field> originalFields;

        public TomlFieldComparator(List<Field> fields) {
            this.setOriginalFields(fields);
        }

        public void setOriginalFields(List<Field> originalFields) {
            this.originalFields = originalFields;
        }

        @Override
        public int compare(Field field1, Field field2) {
            boolean o1Supported = Reflection.isTomlSupportedTypeExceptMap(field1.getType());
            boolean o2Supported = Reflection.isTomlSupportedTypeExceptMap(field2.getType());
            if (o1Supported && o2Supported || !o1Supported && !o2Supported) {
                return Integer.valueOf(this.originalFields.indexOf(field1)).compareTo(this.originalFields.indexOf(field2));
            }
            return o1Supported ? -1 : 1;
        }
    }

    public static class Reflection {
        static final Set<Class<?>> TOML_SUPPORTED = new HashSet<Class>(Arrays.asList(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Calendar.class, Character.TYPE, char[].class, Boolean.TYPE, Boolean.class, String.class, List.class, Map.class));

        public static boolean isTomlSupportedType(Class<?> clazz) {
            return TOML_SUPPORTED.contains(clazz);
        }

        public static boolean isTomlSupportedTypeExceptMap(Class<?> clazz) {
            return TOML_SUPPORTED.contains(clazz) && !clazz.equals(Map.class);
        }

        public static void setFieldValue(Field field, Object object, Object value) throws IllegalAccessException {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(isAccessible);
        }

        public static Object getFieldValue(Field field, Object object) throws IllegalAccessException {
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            Object result = field.get(object);
            field.setAccessible(isAccessible);
            return result;
        }

        public static TomlFieldComparator newTomlFieldComparator(List<Field> fields) {
            return new TomlFieldComparator(fields);
        }
    }

    public static class FileToString {
        public static String read(File file) throws FileNotFoundException {
            try {
                return new Scanner(file).useDelimiter("\\Z").next();
            }
            catch (NoSuchElementException e) {
                return "";
            }
        }
    }

    public static class TomlString {
        private static Map<Character, Character> ESCAPE = new HashMap<Character, Character>();
        private static Map<Character, Character> UNESCAPE = new HashMap<Character, Character>(){
            {
                this.put(Character.valueOf('0'), Character.valueOf('\u0000'));
                this.put(Character.valueOf('t'), Character.valueOf('\t'));
                this.put(Character.valueOf('n'), Character.valueOf('\n'));
                this.put(Character.valueOf('r'), Character.valueOf('\r'));
                this.put(Character.valueOf('\\'), Character.valueOf('\\'));
                this.put(Character.valueOf('\"'), Character.valueOf('\"'));
            }
        };

        public static String unescape(String input) {
            StringBuffer buffer = new StringBuffer(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (ch != '\\') {
                    buffer.append(ch);
                    continue;
                }
                if (i == input.length() - 1) {
                    throw new IllegalStateException("Invalid escape sequence at the end of the input.");
                }
                if (UNESCAPE.containsKey(Character.valueOf(ch = input.charAt(++i)))) {
                    buffer.append(UNESCAPE.get(Character.valueOf(ch)));
                    continue;
                }
                if (ch == 'u') {
                    String unicodeHexValue;
                    if (!(unicodeHexValue = String.valueOf(input.charAt(++i)) + String.valueOf(input.charAt(++i)) + String.valueOf(input.charAt(++i)) + String.valueOf(input.charAt(++i))).matches("[0-9a-fA-F]{4}")) continue;
                    buffer.append((char)Integer.parseInt(unicodeHexValue, 16));
                    continue;
                }
                throw new IllegalArgumentException("Escape sequence \\ " + ch + " in isn't known. " + "Known sequences are: " + "\\0, \\t, \\n, \\b, \\r, \\\\, \\\".\n" + "Offending string: " + input + "\n" + "                 " + TomlString.createWhitespaceString(i) + "^");
            }
            return buffer.toString();
        }

        public static String escape(String input) {
            StringBuffer buffer = new StringBuffer(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (ESCAPE.containsKey(Character.valueOf(ch))) {
                    buffer.append("\\").append(ESCAPE.get(Character.valueOf(ch)));
                    continue;
                }
                if (ch >= '\u0000' && ch < ' ' || ch >= '\u007f') {
                    buffer.append("\\u").append(Integer.toHexString(ch));
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }

        private static String createWhitespaceString(int length) {
            char[] charArray = new char[length];
            Arrays.fill(charArray, ' ');
            return String.valueOf(charArray);
        }

        public static int countOccurrences(String str, String needle) {
            int index = 0;
            int count = 0;
            while (index != -1) {
                if ((index = str.indexOf(needle, index)) == -1) continue;
                ++count;
                index += needle.length();
            }
            return count;
        }

        static {
            for (Map.Entry<Character, Character> e : UNESCAPE.entrySet()) {
                ESCAPE.put(e.getValue(), e.getKey());
            }
        }
    }

    public static class ISO8601 {
        public static Calendar toCalendar(String iso8601string) throws ParseException {
            Calendar calendar = GregorianCalendar.getInstance();
            String s = iso8601string.replace("Z", "+00:00");
            try {
                s = s.substring(0, 22) + s.substring(23);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ParseException("Invalid length", 0);
            }
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(s);
            calendar.setTime(date);
            return calendar;
        }

        public static String fromCalendar(Calendar calendar) {
            Date date = calendar.getTime();
            String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(date);
            return (formatted.substring(0, 22) + ":" + formatted.substring(22)).replace("+00:00", "Z");
        }
    }
}

