/*
 * Decompiled with CFR 0.152.
 */
package me.grison.jtoml.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.grison.jtoml.TomlSerializer;
import me.grison.jtoml.Util;

public class SimpleTomlSerializer
implements TomlSerializer {
    private Map<Class<?>, Converter> converters = new HashMap<Class<?>, Converter>(){
        {
            this.put(String.class, new Converter(){

                @Override
                public String convert(Object o) {
                    return "\"" + Util.TomlString.escape((String)o) + "\"";
                }
            });
            this.put(Calendar.class, new Converter(){

                @Override
                public String convert(Object o) {
                    return Util.ISO8601.fromCalendar((Calendar)o);
                }
            });
            this.put(char[].class, new Converter(){

                @Override
                public String convert(Object o) {
                    return ((Converter)this.get(String.class)).convert(String.valueOf((char[])o));
                }
            });
        }
    };

    @Override
    public String serialize(Object object) {
        return this.serialize(null, object);
    }

    private String serializeList(List<?> list) {
        StringBuffer buffer = new StringBuffer("[");
        StringBuffer ibuff = new StringBuffer();
        for (Object item : list) {
            if (item instanceof List) {
                ibuff.append(", ").append(this.serializeList((List)item));
                continue;
            }
            if (!Util.Reflection.isTomlSupportedType(item.getClass())) continue;
            if (this.converters.containsKey(item.getClass())) {
                ibuff.append(", ").append(this.converters.get(item.getClass()).convert(item));
                continue;
            }
            ibuff.append(", ").append(item);
        }
        if (ibuff.length() > 0) {
            buffer.append(ibuff.substring(2));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String serializeMap(String rootKey, Map<String, Object> map) {
        StringBuffer buffer = new StringBuffer(rootKey == null ? "" : "[" + rootKey + "]\n");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            String nextRootKey = rootKey == null ? name : rootKey + "." + name;
            Class<?> type = entry.getValue().getClass();
            Object value = entry.getValue();
            if (value instanceof List) {
                buffer.append(name + " = " + this.serializeList((List)value) + "\n");
                continue;
            }
            if (Util.Reflection.isTomlSupportedTypeExceptMap(type)) {
                if (this.converters.containsKey(type)) {
                    value = this.converters.get(type).convert(value);
                }
                buffer.append(name + " = " + value + "\n");
                continue;
            }
            if (value instanceof Map) {
                buffer.append("\n" + this.serializeMap(nextRootKey, (Map)value));
                continue;
            }
            buffer.append("\n" + this.serialize(nextRootKey, value));
        }
        return buffer.toString();
    }

    @Override
    public String serialize(String rootKey, Object object) {
        try {
            if (object instanceof Map) {
                return this.serializeMap(rootKey, (Map)object);
            }
            StringBuffer buffer = new StringBuffer(rootKey == null ? "" : "[" + rootKey + "]\n");
            List<Field> fields = Arrays.asList(object.getClass().getDeclaredFields());
            Collections.sort(fields, Util.Reflection.newTomlFieldComparator(fields));
            for (Field f : fields) {
                Class<?> type = f.getType();
                Object value = Util.Reflection.getFieldValue(f, object);
                if (type.equals(List.class)) {
                    buffer.append(f.getName() + " = " + this.serializeList((List)value) + "\n");
                    continue;
                }
                if (Util.Reflection.isTomlSupportedTypeExceptMap(type)) {
                    if (this.converters.containsKey(type)) {
                        value = this.converters.get(type).convert(value);
                    }
                    buffer.append(f.getName() + " = " + value + "\n");
                    continue;
                }
                buffer.append("\n" + this.serialize(rootKey + "." + f.getName(), value));
            }
            return buffer.toString();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not serialize object with rootKey `" + rootKey + "`.", e);
        }
    }

    static interface Converter {
        public String convert(Object var1);
    }
}

