/*
 * Decompiled with CFR 0.152.
 */
package me.grison.jtoml.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.grison.jtoml.Getter;
import me.grison.jtoml.Parser;
import me.grison.jtoml.TomlParser;
import me.grison.jtoml.TomlSerializer;
import me.grison.jtoml.Util;
import me.grison.jtoml.impl.SimpleTomlParser;
import me.grison.jtoml.impl.SimpleTomlSerializer;

public class Toml
implements Parser,
Getter {
    private static final Logger LOGGER = Logger.getLogger(Toml.class.getName());
    private static TomlParser defaultParser;
    protected Map<String, Object> context = new LinkedHashMap<String, Object>();
    protected final Matcher keyPathMatcher = Pattern.compile("((\\w+[.])+).*").matcher("");
    protected TomlParser tomlParser;
    private static TomlSerializer tomlSerializer;

    public Toml() {
        this(null);
    }

    public Toml(TomlParser tomlParser) {
        this.tomlParser = tomlParser;
    }

    public static Toml parse(String tomlString) {
        return Toml.parse(tomlString, null);
    }

    public static Toml parse(String tomlString, TomlParser tomlParser) {
        return new Toml(tomlParser).parseString(tomlString);
    }

    public static Toml parse(File file) throws IOException {
        return Toml.parse(file, null);
    }

    public static Toml parse(File file, TomlParser tomlParser) throws IOException {
        return new Toml(tomlParser).parseFile(file);
    }

    public Toml parseString(String string) {
        this.context = this.internalParser().parse(string);
        return this;
    }

    public Toml parseFile(File file) throws FileNotFoundException {
        return this.parseString(Util.FileToString.read(file));
    }

    private TomlParser internalParser() {
        if (this.tomlParser == null) {
            this.tomlParser = defaultParser;
        }
        return this.tomlParser;
    }

    public TomlParser getTomlParser() {
        return this.tomlParser;
    }

    private String keyPath(String key) {
        if (this.keyPathMatcher.reset(key).matches()) {
            return this.keyPathMatcher.group(1).substring(0, this.keyPathMatcher.group(1).length() - 1);
        }
        return key;
    }

    public Map<String, Object> findContext(Map<String, Object> context, String key) {
        Map visitor = context;
        for (String part : key.split("[.]")) {
            if (!visitor.containsKey(part)) {
                return null;
            }
            visitor = (Map)visitor.get(part);
        }
        return visitor;
    }

    @Override
    public Object get(String key) {
        if (key == null || "".equals(key.trim())) {
            return this.context;
        }
        if (key.contains(".")) {
            String keyPath = this.keyPath(key);
            return this.findContext(this.context, keyPath).get(key.replace(keyPath + ".", ""));
        }
        return this.context.get(key);
    }

    @Override
    public String getString(String key) {
        return this.get(key, String.class);
    }

    @Override
    public Long getLong(String key) {
        return this.get(key, Long.class);
    }

    @Override
    public Double getDouble(String key) {
        return this.get(key, Double.class);
    }

    @Override
    public Calendar getDate(String key) {
        return this.get(key, Calendar.class);
    }

    @Override
    public List<Object> getList(String key) {
        return this.get(key, List.class);
    }

    @Override
    public Map<String, Object> getMap(String key) {
        return this.get(key, Map.class);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    @Override
    public <T> T getAs(String key, Class<T> clazz) {
        try {
            T result = clazz.newInstance();
            for (Field f : clazz.getDeclaredFields()) {
                Class<?> fieldType = f.getType();
                String fieldName = key == null || "".equals(key.trim()) ? f.getName() : key + "." + f.getName();
                Object fieldValue = Util.Reflection.isTomlSupportedType(fieldType) ? this.get(fieldName, fieldType) : this.getAs(fieldName, fieldType);
                Util.Reflection.setFieldValue(f, result, fieldValue);
            }
            return result;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not map value of key `" + key + "` to Object of class `" + clazz.getName() + "`.", e);
        }
    }

    private <T> T get(String key, Class<T> clazz) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        throw this.illegalArg(key, value, clazz);
    }

    public String serialize() {
        return this.serialize(null);
    }

    public String serialize(String rootKey) {
        return Toml.serialize(rootKey, this.context);
    }

    public static String serialize(Object object) {
        return Toml.serialize(null, object);
    }

    public static String serialize(String rootKey, Object object) {
        return tomlSerializer.serialize(rootKey, object);
    }

    private IllegalArgumentException illegalArg(String key, Object value, Class<?> expected) {
        return new IllegalArgumentException(String.format("Value for key `%s` is `%s`%s.", key, value, value == null ? "" : ". Expected type was `" + expected.getName() + "`"));
    }

    private static void initDefaultParser() {
        ArrayList<TomlParser> parsers = new ArrayList<TomlParser>();
        Iterator<TomlParser> parserIterator = ServiceLoader.load(TomlParser.class).iterator();
        while (parserIterator.hasNext()) {
            parsers.add(parserIterator.next());
        }
        if (parsers.size() > 2) {
            throw new IllegalStateException("Too much TomlParser found on classpath: " + parsers);
        }
        for (TomlParser parser : parsers) {
            LOGGER.log(Level.CONFIG, "Found TomlParser instance on classpath: " + parser.getClass().getName());
            if (SimpleTomlParser.class.equals(parser.getClass()) && defaultParser != null) continue;
            defaultParser = parser;
        }
        if (defaultParser == null) {
            defaultParser = new SimpleTomlParser();
            LOGGER.log(Level.WARNING, "No TomlParser service loaded, defaulting to: " + defaultParser.getClass().getName());
        }
    }

    static {
        tomlSerializer = new SimpleTomlSerializer();
        Toml.initDefaultParser();
    }
}

