/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight;

import app.cash.sqldelight.RollbackException;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.db.SqlDriver;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u0001H\tH\u0004\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u0015\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u0016\u0012\u0004\u0012\u00020\u00120\u0016H\u0004J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0014H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lapp/cash/sqldelight/BaseTransacterImpl;", "", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "getDriver", "()Lapp/cash/sqldelight/db/SqlDriver;", "postTransactionCleanup", "R", "transaction", "Lapp/cash/sqldelight/Transacter$Transaction;", "enclosing", "thrownException", "", "returnValue", "(Lapp/cash/sqldelight/Transacter$Transaction;Lapp/cash/sqldelight/Transacter$Transaction;Ljava/lang/Throwable;Ljava/lang/Object;)Ljava/lang/Object;", "notifyQueries", "", "identifier", "", "tableProvider", "Lkotlin/Function1;", "", "createArguments", "count", "runtime"})
@SourceDebugExtension(value={"SMAP\nTransacter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transacter.kt\napp/cash/sqldelight/BaseTransacterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,423:1\n1863#2,2:424\n1863#2,2:428\n37#3,2:426\n37#3,2:430\n*S KotlinDebug\n*F\n+ 1 Transacter.kt\napp/cash/sqldelight/BaseTransacterImpl\n*L\n270#1:424,2\n284#1:428,2\n280#1:426,2\n323#1:430,2\n*E\n"})
public abstract class BaseTransacterImpl {
    @NotNull
    private final SqlDriver driver;

    public BaseTransacterImpl(@NotNull SqlDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.driver = driver;
    }

    @NotNull
    protected final SqlDriver getDriver() {
        return this.driver;
    }

    protected final <R> R postTransactionCleanup(@NotNull Transacter.Transaction transaction, @Nullable Transacter.Transaction enclosing, @Nullable Throwable thrownException, @Nullable R returnValue) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (enclosing == null) {
            if (!transaction.getSuccessful$runtime() || !transaction.getChildrenSuccessful$runtime()) {
                try {
                    Iterable $this$forEach$iv = transaction.getPostRollbackHooks$runtime();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Function0 it = (Function0)element$iv;
                        boolean bl = false;
                        it.invoke();
                    }
                }
                catch (Throwable rollbackException) {
                    if (thrownException != null) {
                        Throwable it = thrownException;
                        boolean bl = false;
                        throw new Throwable("Exception while rolling back from an exception.\nOriginal exception: " + thrownException + "\nwith cause " + thrownException.getCause() + "\n\nRollback exception: " + rollbackException, rollbackException);
                    }
                    throw rollbackException;
                }
                transaction.getPostRollbackHooks$runtime().clear();
            } else {
                if (!((Collection)transaction.getPendingTables$runtime()).isEmpty()) {
                    Collection $this$toTypedArray$iv = transaction.getPendingTables$runtime();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] rollbackException = thisCollection$iv.toArray(new String[0]);
                    this.driver.notifyListeners(Arrays.copyOf(rollbackException, rollbackException.length));
                }
                transaction.getPendingTables$runtime().clear();
                transaction.getRegisteredQueries$runtime().clear();
                Iterable $this$forEach$iv = transaction.getPostCommitHooks$runtime();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
                transaction.getPostCommitHooks$runtime().clear();
            }
        } else {
            enclosing.setChildrenSuccessful$runtime(transaction.getSuccessful$runtime() && transaction.getChildrenSuccessful$runtime());
            enclosing.getPostCommitHooks$runtime().addAll((Collection<Function0<Unit>>)transaction.getPostCommitHooks$runtime());
            enclosing.getPostRollbackHooks$runtime().addAll((Collection<Function0<Unit>>)transaction.getPostRollbackHooks$runtime());
            enclosing.getRegisteredQueries$runtime().addAll((Collection<Integer>)transaction.getRegisteredQueries$runtime());
            enclosing.getPendingTables$runtime().addAll((Collection<String>)transaction.getPendingTables$runtime());
        }
        if (enclosing == null && thrownException instanceof RollbackException) {
            return (R)((RollbackException)thrownException).getValue();
        }
        if (thrownException != null) {
            throw thrownException;
        }
        return returnValue;
    }

    protected final void notifyQueries(int identifier, @NotNull Function1<? super Function1<? super String, Unit>, Unit> tableProvider) {
        Intrinsics.checkNotNullParameter(tableProvider, (String)"tableProvider");
        Transacter.Transaction transaction = this.driver.currentTransaction();
        if (transaction != null) {
            if (transaction.getRegisteredQueries$runtime().add(identifier)) {
                tableProvider.invoke(arg_0 -> BaseTransacterImpl.notifyQueries$lambda$3(transaction, arg_0));
            }
        } else {
            Set tableKeys = new LinkedHashSet();
            tableProvider.invoke(arg_0 -> BaseTransacterImpl.notifyQueries$lambda$4(tableKeys, arg_0));
            Collection $this$toTypedArray$iv = tableKeys;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            this.driver.notifyListeners(Arrays.copyOf(stringArray, stringArray.length));
        }
    }

    @NotNull
    protected final String createArguments(int count) {
        StringBuilder stringBuilder;
        if (count == 0) {
            return "()";
        }
        int n = count * 2 + 1;
        StringBuilder $this$createArguments_u24lambda_u246 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$createArguments_u24lambda_u246.append("(?");
        int n2 = count - 1;
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl2 = false;
            $this$createArguments_u24lambda_u246.append(",?");
        }
        $this$createArguments_u24lambda_u246.append(')');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit notifyQueries$lambda$3(Transacter.Transaction $transaction, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $transaction.getPendingTables$runtime().add(it);
        return Unit.INSTANCE;
    }

    private static final Unit notifyQueries$lambda$4(Set $tableKeys, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $tableKeys.add(it);
        return Unit.INSTANCE;
    }
}

