/*
 * Decompiled with CFR 0.152.
 */
package app.cash.sqldelight.logs;

import app.cash.sqldelight.Query;
import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlCursor;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlPreparedStatement;
import app.cash.sqldelight.logs.StatementParameterInterceptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016JH\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000f2\u0019\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015Jh\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\f\"\u0004\b\u0000\u0010\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\f0\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\u0019\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J)\u0010\u001d\u001a\u00020\u00062\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001f\"\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J)\u0010#\u001a\u00020\u00062\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001f\"\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J!\u0010$\u001a\u00020\u00062\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001f\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010%J#\u0010&\u001a\u00020\u00062\u0019\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lapp/cash/sqldelight/logs/LogSqliteDriver;", "Lapp/cash/sqldelight/db/SqlDriver;", "sqlDriver", "logger", "Lkotlin/Function1;", "", "", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;Lkotlin/jvm/functions/Function1;)V", "currentTransaction", "Lapp/cash/sqldelight/Transacter$Transaction;", "execute", "Lapp/cash/sqldelight/db/QueryResult;", "", "identifier", "", "sql", "parameters", "binders", "Lapp/cash/sqldelight/db/SqlPreparedStatement;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Integer;Ljava/lang/String;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "executeQuery", "R", "mapper", "Lapp/cash/sqldelight/db/SqlCursor;", "(Ljava/lang/Integer;Ljava/lang/String;Lkotlin/jvm/functions/Function1;ILkotlin/jvm/functions/Function1;)Lapp/cash/sqldelight/db/QueryResult;", "newTransaction", "close", "addListener", "queryKeys", "", "listener", "Lapp/cash/sqldelight/Query$Listener;", "([Ljava/lang/String;Lapp/cash/sqldelight/Query$Listener;)V", "removeListener", "notifyListeners", "([Ljava/lang/String;)V", "logParameters", "runtime"})
public final class LogSqliteDriver
implements SqlDriver {
    @NotNull
    private final SqlDriver sqlDriver;
    @NotNull
    private final Function1<String, Unit> logger;

    public LogSqliteDriver(@NotNull SqlDriver sqlDriver, @NotNull Function1<? super String, Unit> logger) {
        Intrinsics.checkNotNullParameter((Object)sqlDriver, (String)"sqlDriver");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.sqlDriver = sqlDriver;
        this.logger = logger;
    }

    @Override
    @Nullable
    public Transacter.Transaction currentTransaction() {
        return this.sqlDriver.currentTransaction();
    }

    @Override
    @NotNull
    public QueryResult<Long> execute(@Nullable Integer identifier, @NotNull String sql, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.logger.invoke((Object)("EXECUTE\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.execute(identifier, sql, parameters, binders);
    }

    @Override
    @NotNull
    public <R> QueryResult<R> executeQuery(@Nullable Integer identifier, @NotNull String sql, @NotNull Function1<? super SqlCursor, ? extends QueryResult<R>> mapper, int parameters, @Nullable Function1<? super SqlPreparedStatement, Unit> binders) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.logger.invoke((Object)("QUERY\n " + sql));
        this.logParameters(binders);
        return this.sqlDriver.executeQuery(identifier, sql, mapper, parameters, binders);
    }

    @Override
    @NotNull
    public QueryResult<Transacter.Transaction> newTransaction() {
        this.logger.invoke((Object)"TRANSACTION BEGIN");
        Transacter.Transaction transaction = this.sqlDriver.newTransaction().getValue();
        transaction.afterCommit((Function0<Unit>)((Function0)() -> LogSqliteDriver.newTransaction$lambda$0(this)));
        transaction.afterRollback((Function0<Unit>)((Function0)() -> LogSqliteDriver.newTransaction$lambda$1(this)));
        return QueryResult.Value.box-impl(QueryResult.Value.constructor-impl(transaction));
    }

    @Override
    public void close() {
        this.logger.invoke((Object)"CLOSE CONNECTION");
        this.sqlDriver.close();
    }

    @Override
    public void addListener(@NotNull String[] queryKeys, @NotNull Query.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("BEGIN " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.addListener(Arrays.copyOf(queryKeys, queryKeys.length), listener);
    }

    @Override
    public void removeListener(@NotNull String[] queryKeys, @NotNull Query.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.logger.invoke((Object)("END " + listener + " LISTENING TO [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.removeListener(Arrays.copyOf(queryKeys, queryKeys.length), listener);
    }

    @Override
    public void notifyListeners(String ... queryKeys) {
        Intrinsics.checkNotNullParameter((Object)queryKeys, (String)"queryKeys");
        this.logger.invoke((Object)("NOTIFYING LISTENERS OF [" + ArraysKt.joinToString$default((Object[])queryKeys, null, null, null, (int)0, null, null, (int)63, null) + ']'));
        this.sqlDriver.notifyListeners(Arrays.copyOf(queryKeys, queryKeys.length));
    }

    private final void logParameters(Function1<? super SqlPreparedStatement, Unit> binders) {
        block1: {
            Function1<? super SqlPreparedStatement, Unit> function1 = binders;
            if (function1 == null) break block1;
            Function1<? super SqlPreparedStatement, Unit> func = function1;
            boolean bl = false;
            StatementParameterInterceptor parametersInterceptor = new StatementParameterInterceptor();
            func.invoke((Object)parametersInterceptor);
            List<Object> logParameters = parametersInterceptor.getAndClearParameters();
            if (!((Collection)logParameters).isEmpty()) {
                this.logger.invoke((Object)("" + ' ' + logParameters));
            }
        }
    }

    private static final Unit newTransaction$lambda$0(LogSqliteDriver this$0) {
        this$0.logger.invoke((Object)"TRANSACTION COMMIT");
        return Unit.INSTANCE;
    }

    private static final Unit newTransaction$lambda$1(LogSqliteDriver this$0) {
        this$0.logger.invoke((Object)"TRANSACTION ROLLBACK");
        return Unit.INSTANCE;
    }
}

