/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Parameter<T>
implements Map.Entry<String, T>,
Serializable {
    private static final long serialVersionUID = -6525353427059094141L;
    protected final String name;
    protected final T value;

    public Parameter(String key, T value) {
        this.name = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
    }

    public static <V> Parameter<V> of(String key, V value) {
        return new Parameter<V>(key, value);
    }

    @Override
    @Deprecated
    public String getKey() {
        return this.name;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public T getValue() {
        return this.value;
    }

    public T value() {
        return this.value;
    }

    @Override
    @Deprecated
    public T setValue(T value) {
        throw new UnsupportedOperationException("Pair is read only");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (!this.name.equals(parameter.name)) {
            return false;
        }
        return this.value.equals(parameter.value);
    }

    @Override
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.name + " = " + this.value + ")";
    }
}

