/*
 * Decompiled with CFR 0.152.
 */
package me.gv7.woodpecker.requests;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.gv7.woodpecker.requests.BasicAuth;
import me.gv7.woodpecker.requests.DefaultSettings;
import me.gv7.woodpecker.requests.Interceptor;
import me.gv7.woodpecker.requests.InterceptorChain;
import me.gv7.woodpecker.requests.Proxies;
import me.gv7.woodpecker.requests.RawResponse;
import me.gv7.woodpecker.requests.Request;
import me.gv7.woodpecker.requests.body.Part;
import me.gv7.woodpecker.requests.body.RequestBody;
import me.gv7.woodpecker.requests.config.CustomHttpHeaderConfig;
import me.gv7.woodpecker.requests.config.HttpConfigManager;
import me.gv7.woodpecker.requests.config.ProxyConfig;
import me.gv7.woodpecker.requests.config.TimeoutConfig;
import me.gv7.woodpecker.requests.exception.RequestsException;
import me.gv7.woodpecker.requests.executor.HttpExecutor;
import me.gv7.woodpecker.requests.executor.RequestExecutorFactory;
import me.gv7.woodpecker.requests.executor.SessionContext;
import net.dongliu.commons.collection.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class RequestBuilder {
    public static boolean DEBUG = true;
    private boolean ignoreHttpConfig = false;
    String method = "GET";
    URL url;
    Collection<? extends Map.Entry<String, ?>> headers = Lists.of();
    Collection<? extends Map.Entry<String, ?>> cookies = Lists.of();
    String userAgent = DefaultSettings.USER_AGENT;
    Collection<? extends Map.Entry<String, ?>> params = Lists.of();
    Charset charset = StandardCharsets.UTF_8;
    @Nullable RequestBody<?> body;
    boolean timeoutIsSet = false;
    int socksTimeout = 5000;
    int connectTimeout = 3000;
    @Nullable Proxy proxy;
    boolean followRedirect = false;
    int maxRedirectCount = 5;
    boolean acceptCompress = true;
    boolean verify = false;
    @Nullable BasicAuth basicAuth;
    @Nullable SessionContext sessionContext;
    boolean keepAlive = true;
    @Nullable KeyStore keyStore;
    private List<? extends Interceptor> interceptors = Collections.emptyList();

    RequestBuilder() {
    }

    RequestBuilder(Request request) {
        this.method = request.method();
        this.headers = request.headers();
        this.cookies = request.cookies();
        this.userAgent = request.userAgent();
        this.charset = request.charset();
        this.body = request.body();
        this.socksTimeout = request.socksTimeout();
        this.connectTimeout = request.connectTimeout();
        this.proxy = request.proxy();
        this.followRedirect = request.followRedirect();
        this.maxRedirectCount = request.maxRedirectCount();
        this.acceptCompress = request.acceptCompress();
        this.verify = request.verify();
        this.basicAuth = request.basicAuth();
        this.sessionContext = request.sessionContext();
        this.keepAlive = request.keepAlive();
        this.keyStore = request.keyStore();
        this.url = request.url();
        this.params = request.params();
    }

    public RequestBuilder method(String method) {
        this.method = Objects.requireNonNull(method);
        return this;
    }

    public RequestBuilder url(String url) {
        try {
            this.url = new URL(Objects.requireNonNull(url));
        }
        catch (MalformedURLException e) {
            throw new RequestsException("Resolve url error, url: " + url, e);
        }
        return this;
    }

    public RequestBuilder url(URL url) {
        this.url = Objects.requireNonNull(url);
        return this;
    }

    public RequestBuilder headers(Collection<? extends Map.Entry<String, ?>> headers) {
        this.headers = headers;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder headers(Map.Entry<String, ?> ... headers) {
        this.headers(Lists.of((Object[])headers));
        return this;
    }

    public final RequestBuilder headers(Map<String, ?> map) {
        this.headers = map.entrySet();
        return this;
    }

    public RequestBuilder cookies(Collection<? extends Map.Entry<String, ?>> cookies) {
        this.cookies = cookies;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder cookies(Map.Entry<String, ?> ... cookies) {
        this.cookies(Lists.of((Object[])cookies));
        return this;
    }

    public final RequestBuilder cookies(Map<String, ?> map) {
        this.cookies = map.entrySet();
        return this;
    }

    public RequestBuilder userAgent(String userAgent) {
        this.userAgent = Objects.requireNonNull(userAgent);
        return this;
    }

    public RequestBuilder params(Collection<? extends Map.Entry<String, ?>> params) {
        this.params = params;
        return this;
    }

    @SafeVarargs
    public final RequestBuilder params(Map.Entry<String, ?> ... params) {
        this.params = Lists.of((Object[])params);
        return this;
    }

    public final RequestBuilder params(Map<String, ?> map) {
        this.params = map.entrySet();
        return this;
    }

    public RequestBuilder requestCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public RequestBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public RequestBuilder body(@Nullable RequestBody<?> body) {
        this.body = body;
        return this;
    }

    @Deprecated
    public RequestBuilder forms(Collection<? extends Map.Entry<String, ?>> params) {
        this.body = RequestBody.form(params);
        return this;
    }

    @Deprecated
    @SafeVarargs
    public final RequestBuilder forms(Map.Entry<String, ?> ... formBody) {
        return this.forms(Lists.of((Object[])formBody));
    }

    @Deprecated
    public RequestBuilder forms(Map<String, ?> formBody) {
        return this.forms(formBody.entrySet());
    }

    public RequestBuilder body(Collection<? extends Map.Entry<String, ?>> params) {
        this.body = RequestBody.form(params);
        return this;
    }

    @SafeVarargs
    public final RequestBuilder body(Map.Entry<String, ?> ... formBody) {
        return this.body(Lists.of((Object[])formBody));
    }

    public RequestBuilder body(Map<String, ?> formBody) {
        return this.body(formBody.entrySet());
    }

    public RequestBuilder body(String str) {
        this.body = RequestBody.text(str);
        return this;
    }

    public RequestBuilder body(byte[] bytes) {
        this.body = RequestBody.bytes(bytes);
        return this;
    }

    @Deprecated
    public RequestBuilder body(InputStream input) {
        this.body = RequestBody.inputStream(input);
        return this;
    }

    public RequestBuilder jsonBody(Object value) {
        this.body = RequestBody.json(value);
        return this;
    }

    public RequestBuilder socksTimeout(int timeout) {
        RequestBuilder.checkTimeout(timeout);
        this.socksTimeout = timeout;
        return this;
    }

    public RequestBuilder connectTimeout(int timeout) {
        RequestBuilder.checkTimeout(timeout);
        this.connectTimeout = timeout;
        return this;
    }

    private static void checkTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout should not less than 0");
        }
    }

    public RequestBuilder proxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public RequestBuilder followRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public RequestBuilder maxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = maxRedirectCount;
        return this;
    }

    @Deprecated
    public RequestBuilder compress(boolean compress) {
        this.acceptCompress = compress;
        return this;
    }

    public RequestBuilder acceptCompress(boolean acceptCompress) {
        this.acceptCompress = acceptCompress;
        return this;
    }

    public RequestBuilder verify(boolean verify) {
        this.verify = verify;
        return this;
    }

    public RequestBuilder keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public RequestBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public RequestBuilder basicAuth(String user, String password) {
        this.basicAuth = new BasicAuth(user, password);
        return this;
    }

    public RequestBuilder basicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        return this;
    }

    public RequestBuilder ignoreHttpConfig(boolean ignoreHttpConfig) {
        this.ignoreHttpConfig = ignoreHttpConfig;
        return this;
    }

    Request build() {
        if (!this.ignoreHttpConfig) {
            TimeoutConfig timeoutConfig;
            ProxyConfig proxyConfig = HttpConfigManager.getProxyConfig();
            if (proxyConfig.isEnable()) {
                if (proxyConfig.getProtocol().equals("http")) {
                    this.proxy(Proxies.httpProxy(proxyConfig.getHost(), proxyConfig.getPort()));
                } else if (proxyConfig.getProtocol().equals("socks")) {
                    this.proxy(Proxies.socksProxy(proxyConfig.getHost(), proxyConfig.getPort()));
                }
            }
            if ((timeoutConfig = HttpConfigManager.getTimeoutConfig()).isEnableMandatoryTimeout()) {
                this.timeout(timeoutConfig.getMandatoryTimeout());
            } else if (!this.timeoutIsSet && timeoutConfig.getDefaultTimeout() != 0) {
                this.timeout(timeoutConfig.getDefaultTimeout());
            }
            String userAgent = HttpConfigManager.getUserAgent();
            if (userAgent != null) {
                this.userAgent(userAgent);
            }
            CustomHttpHeaderConfig customHttpHeaderConfig = HttpConfigManager.getCustomHttpHeaderConfig();
            LinkedHashMap<String, String> customHttpHeaders = customHttpHeaderConfig.getCustomHttpHeaders();
            if (customHttpHeaderConfig.isOverwriteHttpHeader()) {
                LinkedHashMap<String, Object> oldHeaders = this.getHeaders();
                HashMap<String, Object> newHeaders = new HashMap<String, Object>();
                newHeaders.putAll(oldHeaders);
                newHeaders.putAll(customHttpHeaders);
                this.headers(newHeaders);
            } else {
                customHttpHeaders.remove("Host");
                LinkedHashMap<String, Object> newHeaders = new LinkedHashMap<String, Object>();
                newHeaders.putAll(customHttpHeaders);
                newHeaders.putAll(this.getHeaders());
                this.headers(newHeaders);
            }
        }
        return new Request(this);
    }

    public Object getHeader(String headerKey) {
        for (Map.Entry<String, ?> obj : this.headers) {
            String keyName = obj.getKey();
            if (!keyName.equals(headerKey)) continue;
            return obj.getValue();
        }
        return null;
    }

    public LinkedHashMap<String, Object> getHeaders() {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ?> obj : this.headers) {
            String keyName = obj.getKey();
            Object value = obj.getValue();
            headers.put(keyName, value);
        }
        return headers;
    }

    public RawResponse send() {
        Request request = this.build();
        RequestExecutorFactory factory = RequestExecutorFactory.getInstance();
        HttpExecutor executor = factory.getHttpExecutor();
        return new InterceptorChain(this.interceptors, executor).proceed(request);
    }

    public RequestBuilder timeout(int timeout) {
        this.timeoutIsSet = true;
        RequestBuilder.checkTimeout(timeout);
        return this.connectTimeout(timeout).socksTimeout(timeout);
    }

    public RequestBuilder timeout(int connectTimeout, int socksTimeout) {
        return this.connectTimeout(connectTimeout).socksTimeout(socksTimeout);
    }

    public final RequestBuilder multiPartBody(Part<?> ... parts) {
        return this.multiPartBody(Lists.of((Object[])parts));
    }

    public RequestBuilder multiPartBody(Collection<Part<?>> parts) {
        return this.body(RequestBody.multiPart(parts));
    }

    public RequestBuilder interceptors(List<? extends Interceptor> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public RequestBuilder interceptors(Interceptor ... interceptors) {
        return this.interceptors(Lists.of((Object[])interceptors));
    }

    RequestBuilder sessionContext(@Nullable SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }
}

